/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.util.biome;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import me.pepperbell.continuity.client.util.ClientJoinEvent;
import me.pepperbell.continuity.client.util.biome.BiomeHolder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import org.jetbrains.annotations.ApiStatus;

public final class BiomeHolderManager {
    private static final Map<ResourceLocation, BiomeHolder> HOLDER_CACHE = new Object2ObjectOpenHashMap();
    private static RegistryAccess registryManager;

    public static BiomeHolder getOrCreateHolder(ResourceLocation id) {
        BiomeHolder holder = HOLDER_CACHE.get(id);
        if (holder == null) {
            holder = new BiomeHolder(id);
            HOLDER_CACHE.put(id, holder);
        }
        return holder;
    }

    @ApiStatus.Internal
    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(BiomeHolderManager::worldJoin);
    }

    public static void worldJoin(ClientJoinEvent event) {
        registryManager = event.getHandler().m_105152_();
        BiomeHolderManager.refreshHolders();
    }

    public static void refreshHolders() {
        if (registryManager == null) {
            return;
        }
        Object2ObjectOpenHashMap compressedIdMap = new Object2ObjectOpenHashMap();
        Registry biomeRegistry = registryManager.m_175515_(Registry.f_122885_);
        for (ResourceLocation id : biomeRegistry.m_6566_()) {
            ResourceLocation compressedId;
            String compressedPath;
            String path = id.m_135815_();
            if (path.equals(compressedPath = path.replace("_", "")) || biomeRegistry.m_7804_(compressedId = new ResourceLocation(id.m_135827_(), compressedPath))) continue;
            compressedIdMap.put(compressedId, id);
        }
        for (BiomeHolder holder : HOLDER_CACHE.values()) {
            holder.refresh((Registry<Biome>)biomeRegistry, (Map<ResourceLocation, ResourceLocation>)compressedIdMap);
        }
    }

    @ApiStatus.Internal
    public static void clearCache() {
        HOLDER_CACHE.clear();
    }
}

