/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.util;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.ApiStatus;

public final class SpriteCalculator {
    private static final BlockModelShaper MODELS = Minecraft.m_91087_().m_91304_().m_119430_();
    private static final EnumMap<Direction, SpriteCache> SPRITE_CACHES = new EnumMap(Direction.class);

    public static TextureAtlasSprite getSprite(BlockState state, Direction face, BlockAndTintGetter view, BlockPos pos) {
        return SPRITE_CACHES.get(face).getSprite(state, view, pos);
    }

    public static TextureAtlasSprite calculateSprite(BlockState state, Direction face, Supplier<RandomSource> randomSupplier, BlockAndTintGetter view, BlockPos pos) {
        BakedModel model = MODELS.m_110893_(state);
        ModelData data = model.getModelData(view, pos, state, ModelData.EMPTY);
        try {
            List quads = model.getQuads(state, face, randomSupplier.get(), data, null);
            if (!quads.isEmpty()) {
                return ((BakedQuad)quads.get(0)).m_173410_();
            }
            quads = model.getQuads(state, null, randomSupplier.get(), data, null);
            if (!quads.isEmpty()) {
                int amount = quads.size();
                for (int i = 0; i < amount; ++i) {
                    BakedQuad quad = (BakedQuad)quads.get(i);
                    if (quad.m_111306_() != face) continue;
                    return quad.m_173410_();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return model.getParticleIcon(data);
    }

    @ApiStatus.Internal
    public static void clearCache() {
        for (SpriteCache cache : SPRITE_CACHES.values()) {
            cache.clear();
        }
    }

    static {
        for (Direction direction : Direction.values()) {
            SPRITE_CACHES.put(direction, new SpriteCache(direction));
        }
    }

    private static class SpriteCache {
        private final Direction face;
        private final Map<BlockState, TextureAtlasSprite> sprites = new Object2ObjectOpenHashMap();
        private final Supplier<RandomSource> randomSupplier = new Supplier<RandomSource>(){
            private final RandomSource random = RandomSource.m_216327_();

            @Override
            public RandomSource get() {
                this.random.m_188584_(42L);
                return this.random;
            }
        };
        private final StampedLock lock = new StampedLock();

        public SpriteCache(Direction face) {
            this.face = face;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TextureAtlasSprite getSprite(BlockState state, BlockAndTintGetter view, BlockPos pos) {
            TextureAtlasSprite sprite;
            long readStamp = this.lock.readLock();
            try {
                sprite = this.sprites.get(state);
            }
            finally {
                this.lock.unlockRead(readStamp);
            }
            if (sprite == null) {
                long writeStamp = this.lock.writeLock();
                try {
                    sprite = SpriteCalculator.calculateSprite(state, this.face, this.randomSupplier, view, pos);
                    this.sprites.put(state, sprite);
                }
                finally {
                    this.lock.unlockWrite(writeStamp);
                }
            }
            return sprite;
        }

        public void clear() {
            long writeStamp = this.lock.writeLock();
            try {
                this.sprites.clear();
            }
            finally {
                this.lock.unlockWrite(writeStamp);
            }
        }
    }
}

