/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.resource;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.function.Consumer;
import me.pepperbell.continuity.api.client.CTMLoader;
import me.pepperbell.continuity.api.client.CTMLoaderRegistry;
import me.pepperbell.continuity.api.client.CTMProperties;
import me.pepperbell.continuity.client.ContinuityClient;
import me.pepperbell.continuity.client.resource.CTMLoadingContainer;
import me.pepperbell.continuity.client.resource.InvalidIdentifierStateHolder;
import me.pepperbell.continuity.client.util.BooleanState;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class CTMPropertiesLoader {
    private static final List<CTMLoadingContainer<?>> ALL = new ObjectArrayList();
    private static final List<CTMLoadingContainer<?>> AFFECTS_BLOCK = new ObjectArrayList();
    private static final List<CTMLoadingContainer<?>> IGNORES_BLOCK = new ObjectArrayList();
    private static final List<CTMLoadingContainer<?>> VALID_FOR_MULTIPASS = new ObjectArrayList();
    private static final OptionalListCreator<CTMLoadingContainer<?>> LIST_CREATOR = new OptionalListCreator();

    @ApiStatus.Internal
    public static void loadAll(ResourceManager resourceManager) {
        int packPriority = 0;
        Iterator iterator = resourceManager.m_7536_().iterator();
        BooleanState invalidIdentifierState = InvalidIdentifierStateHolder.get();
        invalidIdentifierState.enable();
        while (iterator.hasNext()) {
            PackResources pack = (PackResources)iterator.next();
            CTMPropertiesLoader.loadAll(pack, packPriority);
            ++packPriority;
        }
        invalidIdentifierState.disable();
        CTMPropertiesLoader.resolveMultipassDependents();
    }

    private static void loadAll(PackResources pack, int packPriority) {
        String packName = pack.m_8017_();
        for (String namespace : pack.m_5698_(PackType.CLIENT_RESOURCES)) {
            Collection ids = pack.m_214146_(PackType.CLIENT_RESOURCES, namespace, "optifine/ctm", id -> id.m_135815_().endsWith(".properties"));
            for (ResourceLocation id2 : ids) {
                try {
                    InputStream stream = pack.m_8031_(PackType.CLIENT_RESOURCES, id2);
                    try {
                        Properties properties = new Properties();
                        properties.load(stream);
                        CTMPropertiesLoader.load(properties, id2, packName, packPriority);
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (Exception e) {
                    ContinuityClient.LOGGER.error("Failed to load CTM properties from file '" + id2 + "' in pack '" + packName + "'", (Throwable)e);
                }
            }
        }
    }

    private static void load(Properties properties, ResourceLocation id, String packName, int packPriority) {
        String method = properties.getProperty("method", "ctm").trim();
        CTMLoader<?> loader = CTMLoaderRegistry.get().getLoader(method);
        if (loader != null) {
            CTMPropertiesLoader.load(loader, properties, id, packName, packPriority, method);
        } else {
            ContinuityClient.LOGGER.error("Unknown 'method' value '" + method + "' in file '" + id + "' in pack '" + packName + "'");
        }
    }

    private static <T extends CTMProperties> void load(CTMLoader<T> loader, Properties properties, ResourceLocation id, String packName, int packPriority, String method) {
        T ctmProperties = loader.getPropertiesFactory().createProperties(properties, id, packName, packPriority, method);
        if (ctmProperties != null) {
            CTMLoadingContainer<T> container = new CTMLoadingContainer<T>(loader, ctmProperties);
            ALL.add(container);
            if (ctmProperties.affectsBlockStates()) {
                AFFECTS_BLOCK.add(container);
            } else {
                IGNORES_BLOCK.add(container);
            }
            if (ctmProperties.affectsTextures() && ctmProperties.isValidForMultipass()) {
                VALID_FOR_MULTIPASS.add(container);
            }
        }
    }

    private static void resolveMultipassDependents() {
        if (CTMPropertiesLoader.isEmpty()) {
            return;
        }
        Object2ObjectOpenHashMap texture2ContainerMap = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap texture2ContainerListMap = new Object2ObjectOpenHashMap();
        int amount = ALL.size();
        for (int i = 0; i < amount; ++i) {
            CTMLoadingContainer<?> container = ALL.get(i);
            Collection<Material> textureDependencies = container.getProperties().getTextureDependencies();
            for (Material spriteId : textureDependencies) {
                ResourceLocation textureId = spriteId.m_119203_();
                CTMLoadingContainer containerValue = (CTMLoadingContainer)texture2ContainerMap.get((Object)textureId);
                if (containerValue == null) {
                    List containerListValue = (List)texture2ContainerListMap.get((Object)textureId);
                    if (containerListValue == null) {
                        texture2ContainerMap.put((Object)textureId, container);
                        continue;
                    }
                    containerListValue.add(container);
                    continue;
                }
                ObjectArrayList containerList = new ObjectArrayList();
                containerList.add(containerValue);
                containerList.add(container);
                texture2ContainerListMap.put((Object)textureId, (Object)containerList);
                texture2ContainerMap.remove((Object)textureId);
            }
        }
        int amount1 = VALID_FOR_MULTIPASS.size();
        ObjectIterator iterator = texture2ContainerMap.object2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)iterator.next();
            ResourceLocation textureId = (ResourceLocation)entry.getKey();
            CTMLoadingContainer container1 = (CTMLoadingContainer)entry.getValue();
            for (int i = 0; i < amount1; ++i) {
                CTMLoadingContainer<?> container = VALID_FOR_MULTIPASS.get(i);
                if (!container.getProperties().affectsTexture(textureId)) continue;
                container1.addMultipassDependent(container);
            }
        }
        ObjectIterator iterator1 = texture2ContainerListMap.object2ObjectEntrySet().fastIterator();
        while (iterator1.hasNext()) {
            Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)iterator1.next();
            ResourceLocation textureId = (ResourceLocation)entry.getKey();
            List containerList = (List)entry.getValue();
            int amount2 = containerList.size();
            for (int i = 0; i < amount1; ++i) {
                CTMLoadingContainer<?> container = VALID_FOR_MULTIPASS.get(i);
                if (!container.getProperties().affectsTexture(textureId)) continue;
                for (int j = 0; j < amount2; ++j) {
                    CTMLoadingContainer container1 = (CTMLoadingContainer)containerList.get(j);
                    container1.addMultipassDependent(container);
                }
            }
        }
        for (int i = 0; i < amount; ++i) {
            CTMLoadingContainer<?> container = ALL.get(i);
            container.resolveRecursiveMultipassDependents();
        }
    }

    public static void consumeAllAffecting(BlockState state, Consumer<CTMLoadingContainer<?>> consumer) {
        int amount = AFFECTS_BLOCK.size();
        for (int i = 0; i < amount; ++i) {
            CTMLoadingContainer<?> container = AFFECTS_BLOCK.get(i);
            if (!container.getProperties().affectsBlockState(state)) continue;
            consumer.accept(container);
        }
    }

    @Nullable
    public static List<CTMLoadingContainer<?>> getAllAffecting(BlockState state) {
        CTMPropertiesLoader.consumeAllAffecting(state, LIST_CREATOR);
        return LIST_CREATOR.get();
    }

    public static void consumeAllAffecting(Collection<Material> spriteIds, Consumer<CTMLoadingContainer<?>> consumer) {
        int amount = IGNORES_BLOCK.size();
        block0: for (int i = 0; i < amount; ++i) {
            CTMLoadingContainer<?> container = IGNORES_BLOCK.get(i);
            for (Material spriteId : spriteIds) {
                if (!container.getProperties().affectsTexture(spriteId.m_119203_())) continue;
                consumer.accept(container);
                continue block0;
            }
        }
    }

    @Nullable
    public static List<CTMLoadingContainer<?>> getAllAffecting(Collection<Material> spriteIds) {
        CTMPropertiesLoader.consumeAllAffecting(spriteIds, LIST_CREATOR);
        return LIST_CREATOR.get();
    }

    public static boolean isEmpty() {
        return ALL.isEmpty();
    }

    @ApiStatus.Internal
    public static void clearAll() {
        ALL.clear();
        AFFECTS_BLOCK.clear();
        IGNORES_BLOCK.clear();
        VALID_FOR_MULTIPASS.clear();
    }

    private static class OptionalListCreator<T>
    implements Consumer<T> {
        private ObjectArrayList<T> list = null;

        private OptionalListCreator() {
        }

        @Override
        public void accept(T t) {
            if (this.list == null) {
                this.list = new ObjectArrayList();
            }
            this.list.add(t);
        }

        @Nullable
        public ObjectArrayList<T> get() {
            ObjectArrayList<T> list = this.list;
            this.list = null;
            return list;
        }
    }
}

