/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.properties.overlay;

import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import me.pepperbell.continuity.client.properties.ConnectingCTMProperties;
import me.pepperbell.continuity.client.properties.PropertiesParsingHelper;
import me.pepperbell.continuity.client.properties.overlay.OverlayPropertiesSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;

public class StandardOverlayCTMProperties
extends ConnectingCTMProperties
implements OverlayPropertiesSection.Provider {
    protected OverlayPropertiesSection overlaySection;
    protected Set<ResourceLocation> connectTilesSet;
    protected Predicate<BlockState> connectBlocksPredicate;

    public StandardOverlayCTMProperties(Properties properties, ResourceLocation id, String packName, int packPriority, String method) {
        super(properties, id, packName, packPriority, method);
        this.overlaySection = new OverlayPropertiesSection(properties, id, packName);
    }

    @Override
    public void init() {
        super.init();
        this.overlaySection.init();
        this.parseConnectTiles();
        this.parseConnectBlocks();
    }

    @Override
    public OverlayPropertiesSection getOverlayPropertiesSection() {
        return this.overlaySection;
    }

    protected void parseConnectTiles() {
        this.connectTilesSet = PropertiesParsingHelper.parseMatchTiles(this.properties, "connectTiles", this.id, this.packName);
    }

    protected void parseConnectBlocks() {
        this.connectBlocksPredicate = PropertiesParsingHelper.parseBlockStates(this.properties, "connectBlocks", this.id, this.packName);
    }

    public Set<ResourceLocation> getConnectTilesSet() {
        return this.connectTilesSet;
    }

    public Predicate<BlockState> getConnectBlocksPredicate() {
        return this.connectBlocksPredicate;
    }
}

