/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.properties;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import me.pepperbell.continuity.api.client.CTMProperties;
import me.pepperbell.continuity.api.client.CTMPropertiesFactory;
import me.pepperbell.continuity.client.ContinuityClient;
import me.pepperbell.continuity.client.properties.PropertiesParsingHelper;
import me.pepperbell.continuity.client.resource.ResourcePackUtil;
import me.pepperbell.continuity.client.resource.ResourceRedirectHandler;
import me.pepperbell.continuity.client.util.MathUtil;
import me.pepperbell.continuity.client.util.TextureUtil;
import me.pepperbell.continuity.client.util.biome.BiomeHolder;
import me.pepperbell.continuity.client.util.biome.BiomeHolderManager;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.VanillaPackResources;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;

public class BaseCTMProperties
implements CTMProperties {
    public static final ResourceLocation SPECIAL_SKIP_ID = ContinuityClient.asId("special/skip");
    public static final ResourceLocation SPECIAL_DEFAULT_ID = ContinuityClient.asId("special/default");
    public static final Material SPECIAL_SKIP_SPRITE_ID = TextureUtil.toSpriteId(SPECIAL_SKIP_ID);
    public static final Material SPECIAL_DEFAULT_SPRITE_ID = TextureUtil.toSpriteId(SPECIAL_DEFAULT_ID);
    protected static final int DIRECTION_AMOUNT = Direction.values().length;
    protected Properties properties;
    protected ResourceLocation id;
    protected String packName;
    protected int packPriority;
    protected String method;
    protected Set<ResourceLocation> matchTilesSet;
    protected Predicate<BlockState> matchBlocksPredicate;
    protected List<ResourceLocation> tiles = Collections.emptyList();
    protected EnumSet<Direction> faces;
    protected Predicate<Biome> biomePredicate;
    protected IntPredicate heightPredicate;
    protected Predicate<String> blockEntityNamePredicate;
    protected boolean prioritized = false;
    protected boolean valid = true;
    protected Set<Material> textureDependencies;
    protected List<Material> spriteIds;

    public BaseCTMProperties(Properties properties, ResourceLocation id, String packName, int packPriority, String method) {
        this.properties = properties;
        this.id = id;
        this.packName = packName;
        this.packPriority = packPriority;
        this.method = method;
    }

    @Override
    public boolean affectsTextures() {
        return this.matchTilesSet != null;
    }

    @Override
    public boolean affectsTexture(ResourceLocation id) {
        if (this.matchTilesSet != null) {
            return this.matchTilesSet.contains(id);
        }
        return false;
    }

    @Override
    public boolean affectsBlockStates() {
        return this.matchBlocksPredicate != null;
    }

    @Override
    public boolean affectsBlockState(BlockState state) {
        if (this.matchBlocksPredicate != null) {
            return this.matchBlocksPredicate.test(state);
        }
        return false;
    }

    public Set<Material> getTextureDependencies() {
        if (this.textureDependencies == null) {
            this.resolveTiles();
        }
        return this.textureDependencies;
    }

    @Override
    public int compareTo(@NotNull CTMProperties o) {
        if (o instanceof BaseCTMProperties) {
            BaseCTMProperties o1 = (BaseCTMProperties)o;
            if (this.prioritized && !o1.prioritized) {
                return 1;
            }
            if (!this.prioritized && o1.prioritized) {
                return -1;
            }
            int c = MathUtil.signum(this.packPriority - o1.packPriority);
            if (c != 0) {
                return c;
            }
            return o1.getId().compareTo(this.getId());
        }
        return 0;
    }

    public void init() {
        this.parseMatchTiles();
        this.parseMatchBlocks();
        this.detectMatches();
        this.validateMatches();
        this.parseTiles();
        this.parseFaces();
        this.parseBiomes();
        this.parseHeights();
        this.parseLegacyHeights();
        this.parseName();
        this.parsePrioritize();
        this.parseResourceCondition();
    }

    protected void parseMatchTiles() {
        this.matchTilesSet = PropertiesParsingHelper.parseMatchTiles(this.properties, "matchTiles", this.id, this.packName);
        if (this.matchTilesSet != null && this.matchTilesSet.isEmpty()) {
            this.valid = false;
        }
    }

    protected void parseMatchBlocks() {
        this.matchBlocksPredicate = PropertiesParsingHelper.parseBlockStates(this.properties, "matchBlocks", this.id, this.packName);
        if (this.matchBlocksPredicate == PropertiesParsingHelper.EMPTY_BLOCK_STATE_PREDICATE) {
            this.valid = false;
        }
    }

    protected void detectMatches() {
        String baseName = FilenameUtils.getBaseName((String)this.id.m_135815_());
        if (this.matchBlocksPredicate == null && baseName.startsWith("block_")) {
            try {
                ResourceLocation id = new ResourceLocation(baseName.substring(6));
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(id);
                if (block != Blocks.f_50016_) {
                    this.matchBlocksPredicate = state -> state.m_60734_() == block;
                }
            }
            catch (ResourceLocationException resourceLocationException) {
                // empty catch block
            }
        }
    }

    protected void validateMatches() {
        if (this.matchTilesSet == null && this.matchBlocksPredicate == null) {
            ContinuityClient.LOGGER.error("No tile or block matches provided in file '" + this.id + "' in pack '" + this.packName + "'");
            this.valid = false;
        }
    }

    protected void parseTiles() {
        String tilesStr = this.properties.getProperty("tiles");
        if (tilesStr == null) {
            ContinuityClient.LOGGER.error("No 'tiles' value provided in file '" + this.id + "' in pack '" + this.packName + "'");
            this.valid = false;
            return;
        }
        String[] tileStrs = tilesStr.trim().split("[ ,]");
        if (tileStrs.length != 0) {
            String basePath = FilenameUtils.getPath((String)this.id.m_135815_());
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            for (int i = 0; i < tileStrs.length; ++i) {
                String tileStr;
                block24: {
                    tileStr = tileStrs[i];
                    if (tileStr.isEmpty()) continue;
                    if (tileStr.endsWith("<skip>") || tileStr.endsWith("<skip>.png")) {
                        listBuilder.add((Object)SPECIAL_SKIP_ID);
                        continue;
                    }
                    if (tileStr.endsWith("<default>") || tileStr.endsWith("<default>.png")) {
                        listBuilder.add((Object)SPECIAL_DEFAULT_ID);
                        continue;
                    }
                    String[] rangeParts = tileStr.split("-");
                    if (rangeParts.length == 0) continue;
                    if (rangeParts.length == 2) {
                        try {
                            int min = Integer.parseInt(rangeParts[0]);
                            int max = Integer.parseInt(rangeParts[1]);
                            if (min <= max) {
                                for (int tile = min; tile <= max; ++tile) {
                                    listBuilder.add((Object)new ResourceLocation(this.id.m_135827_(), basePath + tile + ".png"));
                                }
                                continue;
                            }
                            break block24;
                        }
                        catch (NumberFormatException | ResourceLocationException min) {
                            break block24;
                        }
                    }
                    if (rangeParts.length == 1) {
                        Object path;
                        String namespace;
                        String[] parts = tileStr.split(":", 2);
                        if (parts.length == 0) continue;
                        if (parts.length > 1) {
                            namespace = parts[0];
                            path = parts[1];
                        } else {
                            namespace = null;
                            path = parts[0];
                        }
                        if (!((String)path).endsWith(".png")) {
                            path = (String)path + ".png";
                        }
                        if (((String)path).startsWith("./")) {
                            path = basePath + ((String)path).substring(2);
                        } else if (((String)path).startsWith("~/")) {
                            path = "optifine/" + ((String)path).substring(2);
                        } else if (((String)path).startsWith("/")) {
                            path = "optifine/" + ((String)path).substring(1);
                        } else if (!((String)path).startsWith("textures/") && !((String)path).startsWith("optifine/")) {
                            path = basePath + (String)path;
                        }
                        if (((String)path).startsWith("optifine/") && namespace == null) {
                            namespace = this.id.m_135827_();
                        }
                        try {
                            listBuilder.add((Object)new ResourceLocation(namespace, (String)path));
                            continue;
                        }
                        catch (ResourceLocationException resourceLocationException) {
                            // empty catch block
                        }
                    }
                }
                ContinuityClient.LOGGER.warn("Invalid 'tiles' element '" + tileStr + "' at index " + i + " in file '" + this.id + "' in pack '" + this.packName + "'");
            }
            this.tiles = listBuilder.build();
        }
    }

    protected void parseFaces() {
        String facesStr = this.properties.getProperty("faces");
        if (facesStr == null) {
            return;
        }
        String[] faceStrs = facesStr.trim().split("[ ,]");
        if (faceStrs.length != 0) {
            this.faces = EnumSet.noneOf(Direction.class);
            for (int i = 0; i < faceStrs.length; ++i) {
                String faceStr = faceStrs[i];
                if (faceStr.isEmpty()) continue;
                String faceStr1 = faceStr.toUpperCase(Locale.ROOT);
                if (faceStr1.equals("BOTTOM")) {
                    this.faces.add(Direction.DOWN);
                    continue;
                }
                if (faceStr1.equals("TOP")) {
                    this.faces.add(Direction.UP);
                    continue;
                }
                if (faceStr1.equals("SIDES")) {
                    Iterators.addAll(this.faces, (Iterator)Direction.Plane.HORIZONTAL.iterator());
                    continue;
                }
                if (faceStr1.equals("ALL")) {
                    this.faces = null;
                    return;
                }
                try {
                    this.faces.add(Direction.valueOf((String)faceStr1));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    ContinuityClient.LOGGER.warn("Unknown 'faces' element '" + faceStr + "' at index " + i + " in file '" + this.id + "' in pack '" + this.packName + "'");
                }
            }
            if (this.faces.isEmpty()) {
                this.valid = false;
            } else if (this.faces.size() == DIRECTION_AMOUNT) {
                this.faces = null;
            }
        } else {
            this.valid = false;
        }
    }

    protected void parseBiomes() {
        String biomesStr = this.properties.getProperty("biomes");
        if (biomesStr == null) {
            return;
        }
        if (!(biomesStr = biomesStr.trim()).isEmpty()) {
            String[] biomeStrs;
            boolean negate = false;
            if (biomesStr.charAt(0) == '!') {
                negate = true;
                biomesStr = biomesStr.substring(1);
            }
            if ((biomeStrs = biomesStr.split(" ")).length != 0) {
                ImmutableSet.Builder biomeSetBuilder = ImmutableSet.builder();
                for (int i = 0; i < biomeStrs.length; ++i) {
                    String biomeStr = biomeStrs[i];
                    if (biomeStr.isEmpty()) continue;
                    try {
                        ResourceLocation biomeId = new ResourceLocation(biomeStr.toLowerCase(Locale.ROOT));
                        biomeSetBuilder.add((Object)BiomeHolderManager.getOrCreateHolder(biomeId));
                        continue;
                    }
                    catch (ResourceLocationException e) {
                        ContinuityClient.LOGGER.warn("Invalid 'biomes' element '" + biomeStr + "' at index " + i + " in file '" + this.id + "' in pack '" + this.packName + "'", (Throwable)e);
                    }
                }
                ImmutableSet biomeSet = biomeSetBuilder.build();
                if (!biomeSet.isEmpty()) {
                    BiomeHolder[] biomeArray = (BiomeHolder[])biomeSet.toArray(BiomeHolder[]::new);
                    this.biomePredicate = biome -> {
                        for (BiomeHolder holder : biomeArray) {
                            if (holder.getBiome() != biome) continue;
                            return true;
                        }
                        return false;
                    };
                    if (negate) {
                        this.biomePredicate = this.biomePredicate.negate();
                    }
                } else if (!negate) {
                    this.valid = false;
                }
            } else if (!negate) {
                this.valid = false;
            }
        } else {
            this.valid = false;
        }
    }

    protected void parseHeights() {
        String heightsStr = this.properties.getProperty("heights");
        if (heightsStr == null) {
            return;
        }
        String[] heightStrs = heightsStr.trim().split("[ ,]");
        if (heightStrs.length != 0) {
            ImmutableList.Builder predicateListBuilder = ImmutableList.builder();
            for (int i = 0; i < heightStrs.length; ++i) {
                String heightStr1;
                String[] parts;
                String heightStr = heightStrs[i];
                if (heightStr.isEmpty() || (parts = heightStr.split("\\.\\.", 2)).length == 0) continue;
                if (parts.length == 2) {
                    try {
                        int max;
                        int min;
                        if (parts[1].isEmpty()) {
                            min = Integer.parseInt(parts[0]);
                            predicateListBuilder.add(y -> y >= min);
                            continue;
                        }
                        if (parts[0].isEmpty()) {
                            int max2 = Integer.parseInt(parts[1]);
                            predicateListBuilder.add(y -> y <= max2);
                            continue;
                        }
                        min = Integer.parseInt(parts[0]);
                        if (min < (max = Integer.parseInt(parts[1]))) {
                            predicateListBuilder.add(y -> y >= min && y <= max);
                            continue;
                        }
                        if (min > max) {
                            predicateListBuilder.add(y -> y >= max && y <= min);
                            continue;
                        }
                        predicateListBuilder.add(y -> y == min);
                        continue;
                    }
                    catch (NumberFormatException min) {
                    }
                } else if (parts.length == 1 && !(heightStr1 = heightStr.replaceAll("[()]", "")).isEmpty()) {
                    int separatorIndex = heightStr1.indexOf(45, heightStr1.charAt(0) == '-' ? 1 : 0);
                    try {
                        int max;
                        if (separatorIndex == -1) {
                            int height = Integer.parseInt(heightStr1);
                            predicateListBuilder.add(y -> y == height);
                            continue;
                        }
                        int min = Integer.parseInt(heightStr1.substring(0, separatorIndex));
                        if (min < (max = Integer.parseInt(heightStr1.substring(separatorIndex + 1)))) {
                            predicateListBuilder.add(y -> y >= min && y <= max);
                            continue;
                        }
                        if (min > max) {
                            predicateListBuilder.add(y -> y >= max && y <= min);
                            continue;
                        }
                        predicateListBuilder.add(y -> y == min);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                ContinuityClient.LOGGER.warn("Invalid 'heights' element '" + heightStr + "' at index " + i + " in file '" + this.id + "' in pack '" + this.packName + "'");
            }
            ImmutableList predicateList = predicateListBuilder.build();
            if (!predicateList.isEmpty()) {
                IntPredicate[] predicateArray = (IntPredicate[])predicateList.toArray(IntPredicate[]::new);
                this.heightPredicate = y -> {
                    for (IntPredicate predicate : predicateArray) {
                        if (!predicate.test(y)) continue;
                        return true;
                    }
                    return false;
                };
            } else {
                this.valid = false;
            }
        } else {
            this.valid = false;
        }
    }

    protected void parseLegacyHeights() {
        if (this.heightPredicate == null) {
            boolean hasMaxHeight;
            String minHeightStr = this.properties.getProperty("minHeight");
            String maxHeightStr = this.properties.getProperty("maxHeight");
            boolean hasMinHeight = minHeightStr != null;
            boolean bl = hasMaxHeight = maxHeightStr != null;
            if (hasMinHeight || hasMaxHeight) {
                int min = 0;
                int max = 0;
                if (hasMinHeight) {
                    try {
                        min = Integer.parseInt(minHeightStr.trim());
                    }
                    catch (NumberFormatException e) {
                        hasMinHeight = false;
                        ContinuityClient.LOGGER.warn("Invalid 'minHeight' value '" + minHeightStr + "' in file '" + this.id + "' in pack '" + this.packName + "'");
                    }
                }
                if (hasMaxHeight) {
                    try {
                        max = Integer.parseInt(maxHeightStr.trim());
                    }
                    catch (NumberFormatException e) {
                        hasMaxHeight = false;
                        ContinuityClient.LOGGER.warn("Invalid 'maxHeight' value '" + minHeightStr + "' in file '" + this.id + "' in pack '" + this.packName + "'");
                    }
                }
                int finalMin = min;
                int finalMax = max;
                if (hasMinHeight && hasMaxHeight) {
                    this.heightPredicate = finalMin < finalMax ? y -> y >= finalMin && y <= finalMax : (finalMin > finalMax ? y -> y >= finalMax && y <= finalMin : y -> y == finalMin);
                } else if (hasMinHeight) {
                    this.heightPredicate = y -> y >= finalMin;
                } else if (hasMaxHeight) {
                    this.heightPredicate = y -> y <= finalMax;
                }
            }
        }
    }

    protected void parseName() {
        boolean caseInsensitive;
        boolean isPattern;
        String nameStr = this.properties.getProperty("name");
        if (nameStr == null) {
            return;
        }
        if ((nameStr = StringEscapeUtils.escapeJava((String)nameStr.trim())).startsWith("regex:")) {
            nameStr = nameStr.substring(6);
            isPattern = false;
            caseInsensitive = false;
        } else if (nameStr.startsWith("iregex:")) {
            nameStr = nameStr.substring(7);
            isPattern = false;
            caseInsensitive = true;
        } else if (nameStr.startsWith("pattern:")) {
            nameStr = nameStr.substring(8);
            isPattern = true;
            caseInsensitive = false;
        } else if (nameStr.startsWith("ipattern:")) {
            nameStr = nameStr.substring(9);
            isPattern = true;
            caseInsensitive = true;
        } else {
            this.blockEntityNamePredicate = nameStr::equals;
            return;
        }
        String patternStr = nameStr;
        if (isPattern) {
            patternStr = Pattern.quote(patternStr);
            patternStr = patternStr.replace("?", "\\E.\\Q");
            patternStr = patternStr.replace("*", "\\E.*\\Q");
        }
        Pattern pattern = Pattern.compile(patternStr, caseInsensitive ? 2 : 0);
        this.blockEntityNamePredicate = blockEntityName -> pattern.matcher((CharSequence)blockEntityName).matches();
    }

    protected void parsePrioritize() {
        String prioritizeStr = this.properties.getProperty("prioritize");
        if (prioritizeStr == null) {
            this.prioritized = this.affectsTextures();
            return;
        }
        this.prioritized = Boolean.parseBoolean(prioritizeStr.trim());
    }

    protected void parseResourceCondition() {
        String conditionsStr = this.properties.getProperty("resourceCondition");
        if (conditionsStr == null) {
            return;
        }
        String[] conditionStrs = conditionsStr.trim().split("\\|");
        if (conditionStrs.length != 0) {
            VanillaPackResources defaultPack = ResourcePackUtil.getDefaultResourcePack();
            for (int i = 0; i < conditionStrs.length; ++i) {
                PackResources pack;
                ResourceLocation resourceId;
                String[] parts;
                String conditionStr = conditionStrs[i];
                if (conditionStr.isEmpty() || (parts = conditionStr.split("@", 2)).length == 0) continue;
                String resourceStr = parts[0];
                try {
                    resourceId = new ResourceLocation(resourceStr);
                }
                catch (ResourceLocationException e) {
                    ContinuityClient.LOGGER.warn("Invalid resource '" + resourceStr + "' in 'resourceCondition' element '" + conditionStr + "' at index " + i + " in file '" + this.id + "' in pack '" + this.packName + "'");
                    continue;
                }
                String packStr = parts.length > 1 ? parts[1] : null;
                if (packStr == null || packStr.equals("default")) {
                    pack = ResourcePackUtil.getProvidingResourcePack(resourceId);
                    if (pack == null || pack == defaultPack) continue;
                    this.valid = false;
                    break;
                }
                if (packStr.equals("programmer_art")) {
                    pack = ResourcePackUtil.getProvidingResourcePack(resourceId);
                    if (pack == null || pack.m_8017_().equals("Programmer Art")) continue;
                    this.valid = false;
                    break;
                }
                ContinuityClient.LOGGER.warn("Unknown pack '" + packStr + "' in 'resourceCondition' element '" + conditionStr + "' at index " + i + " in file '" + this.id + "' in pack '" + this.packName + "'");
            }
        }
    }

    protected boolean isValid() {
        return this.valid;
    }

    protected void resolveTiles() {
        this.textureDependencies = new ObjectOpenHashSet();
        this.spriteIds = new ObjectArrayList();
        ResourceRedirectHandler redirectHandler = ResourceRedirectHandler.get();
        for (ResourceLocation tile : this.tiles) {
            Material spriteId;
            if (tile.equals((Object)SPECIAL_SKIP_ID)) {
                spriteId = SPECIAL_SKIP_SPRITE_ID;
            } else if (tile.equals((Object)SPECIAL_DEFAULT_ID)) {
                spriteId = SPECIAL_DEFAULT_SPRITE_ID;
            } else {
                String namespace = tile.m_135827_();
                String path = tile.m_135815_();
                if (path.startsWith("textures/")) {
                    if ((path = path.substring(9)).endsWith(".png")) {
                        path = path.substring(0, path.length() - 4);
                    }
                    spriteId = TextureUtil.toSpriteId(new ResourceLocation(namespace, path));
                    this.textureDependencies.add(spriteId);
                } else if (redirectHandler != null) {
                    path = redirectHandler.getSourceSpritePath(path);
                    spriteId = TextureUtil.toSpriteId(new ResourceLocation(namespace, path));
                    this.textureDependencies.add(spriteId);
                } else {
                    spriteId = TextureUtil.MISSING_SPRITE_ID;
                }
            }
            this.spriteIds.add(spriteId);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getPackName() {
        return this.packName;
    }

    public int getPackPriority() {
        return this.packPriority;
    }

    public String getMethod() {
        return this.method;
    }

    public Set<ResourceLocation> getMatchTilesSet() {
        return this.matchTilesSet;
    }

    public Predicate<BlockState> getMatchBlocksPredicate() {
        return this.matchBlocksPredicate;
    }

    public int getTileAmount() {
        return this.tiles.size();
    }

    public EnumSet<Direction> getFaces() {
        return this.faces;
    }

    public Predicate<Biome> getBiomePredicate() {
        return this.biomePredicate;
    }

    public IntPredicate getHeightPredicate() {
        return this.heightPredicate;
    }

    public Predicate<String> getBlockEntityNamePredicate() {
        return this.blockEntityNamePredicate;
    }

    public boolean isPrioritized() {
        return this.prioritized;
    }

    public List<Material> getSpriteIds() {
        if (this.spriteIds == null) {
            this.resolveTiles();
        }
        return this.spriteIds;
    }

    public static <T extends BaseCTMProperties> CTMPropertiesFactory<T> wrapFactory(CTMPropertiesFactory<T> factory) {
        return (properties, id, packName, packPriority, method) -> {
            BaseCTMProperties ctmProperties = (BaseCTMProperties)factory.createProperties(properties, id, packName, packPriority, method);
            if (ctmProperties == null) {
                return null;
            }
            ctmProperties.init();
            if (ctmProperties.isValid()) {
                return ctmProperties;
            }
            return null;
        };
    }
}

