/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.processor;

import java.util.function.Supplier;
import me.pepperbell.continuity.api.client.QuadProcessor;
import me.pepperbell.continuity.client.processor.AbstractQuadProcessorFactory;
import me.pepperbell.continuity.client.processor.BaseProcessingPredicate;
import me.pepperbell.continuity.client.processor.ConnectingQuadProcessor;
import me.pepperbell.continuity.client.processor.ConnectionPredicate;
import me.pepperbell.continuity.client.processor.ProcessingDataKeys;
import me.pepperbell.continuity.client.processor.ProcessingPredicate;
import me.pepperbell.continuity.client.processor.simple.SimpleQuadProcessor;
import me.pepperbell.continuity.client.properties.StandardConnectingCTMProperties;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class TopQuadProcessor
extends ConnectingQuadProcessor {
    public TopQuadProcessor(TextureAtlasSprite[] sprites, ProcessingPredicate processingPredicate, ConnectionPredicate connectionPredicate, boolean innerSeams) {
        super(sprites, processingPredicate, connectionPredicate, innerSeams);
    }

    @Override
    public QuadProcessor.ProcessingResult processQuadInner(MutableQuadView quad, TextureAtlasSprite sprite, BlockAndTintGetter blockView, BlockState state, BlockPos pos, Supplier<RandomSource> randomSupplier, int pass, int processorIndex, QuadProcessor.ProcessingContext context) {
        Direction lightFace = quad.lightFace();
        Direction.Axis axis = state.m_61138_((Property)BlockStateProperties.f_61365_) ? (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_) : Direction.Axis.Y;
        if (lightFace.m_122434_() != axis) {
            Direction up = Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
            BlockPos.MutableBlockPos mutablePos = context.getData(ProcessingDataKeys.MUTABLE_POS_KEY).m_122159_((Vec3i)pos, up);
            if (this.connectionPredicate.shouldConnect(blockView, state, pos, mutablePos, lightFace, sprite, this.innerSeams)) {
                return SimpleQuadProcessor.process(quad, sprite, this.sprites[0]);
            }
        }
        return QuadProcessor.ProcessingResult.CONTINUE;
    }

    public static class Factory
    extends AbstractQuadProcessorFactory<StandardConnectingCTMProperties> {
        @Override
        public QuadProcessor createProcessor(StandardConnectingCTMProperties properties, TextureAtlasSprite[] sprites) {
            return new TopQuadProcessor(sprites, BaseProcessingPredicate.fromProperties(properties), properties.getConnectionPredicate(), properties.getInnerSeams());
        }

        @Override
        public int getTextureAmount(StandardConnectingCTMProperties properties) {
            return 1;
        }
    }
}

