/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.processor;

import java.util.EnumSet;
import java.util.Set;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import me.pepperbell.continuity.api.client.ProcessingDataProvider;
import me.pepperbell.continuity.client.processor.ProcessingDataKeys;
import me.pepperbell.continuity.client.processor.ProcessingPredicate;
import me.pepperbell.continuity.client.properties.BaseCTMProperties;
import me.pepperbell.continuity.client.util.biome.BiomeRetriever;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class BaseProcessingPredicate
implements ProcessingPredicate {
    protected Set<ResourceLocation> matchTilesSet;
    protected EnumSet<Direction> faces;
    protected Predicate<Biome> biomePredicate;
    protected IntPredicate heightPredicate;
    protected Predicate<String> blockEntityNamePredicate;

    public BaseProcessingPredicate(Set<ResourceLocation> matchTilesSet, EnumSet<Direction> faces, Predicate<Biome> biomePredicate, IntPredicate heightPredicate, Predicate<String> blockEntityNamePredicate) {
        this.matchTilesSet = matchTilesSet;
        this.faces = faces;
        this.biomePredicate = biomePredicate;
        this.heightPredicate = heightPredicate;
        this.blockEntityNamePredicate = blockEntityNamePredicate;
    }

    @Override
    public boolean shouldProcessQuad(QuadView quad, TextureAtlasSprite sprite, BlockAndTintGetter blockView, BlockState state, BlockPos pos, ProcessingDataProvider dataProvider) {
        String blockEntityName;
        Biome biome;
        if (this.matchTilesSet != null && !this.matchTilesSet.contains(sprite.m_118413_())) {
            return false;
        }
        if (this.heightPredicate != null && !this.heightPredicate.test(pos.m_123342_())) {
            return false;
        }
        if (this.faces != null) {
            Direction face = quad.lightFace();
            if (state.m_61138_((Property)BlockStateProperties.f_61365_)) {
                Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_);
                if (axis == Direction.Axis.X) {
                    face = face.m_175362_(Direction.Axis.Z);
                } else if (axis == Direction.Axis.Z) {
                    face = face.m_175364_(Direction.Axis.X);
                }
            }
            if (!this.faces.contains(face)) {
                return false;
            }
        }
        if (!(this.biomePredicate == null || (biome = dataProvider.getData(ProcessingDataKeys.BIOME_CACHE_KEY).get(blockView, pos)) != null && this.biomePredicate.test(biome))) {
            return false;
        }
        return this.blockEntityNamePredicate == null || (blockEntityName = dataProvider.getData(ProcessingDataKeys.BLOCK_ENTITY_NAME_CACHE_KEY).get(blockView, pos)) != null && this.blockEntityNamePredicate.test(blockEntityName);
    }

    public static BaseProcessingPredicate fromProperties(BaseCTMProperties properties) {
        return new BaseProcessingPredicate(properties.getMatchTilesSet(), properties.getFaces(), properties.getBiomePredicate(), properties.getHeightPredicate(), properties.getBlockEntityNamePredicate());
    }

    public static class BiomeCache {
        protected Biome biome;
        protected boolean invalid = true;

        @Nullable
        public Biome get(BlockAndTintGetter blockView, BlockPos pos) {
            if (this.invalid) {
                this.biome = BiomeRetriever.getBiome(blockView, pos);
                this.invalid = false;
            }
            return this.biome;
        }

        public void reset() {
            this.invalid = true;
        }
    }

    public static class BlockEntityNameCache {
        protected String blockEntityName;
        protected boolean invalid = true;

        @Nullable
        public String get(BlockAndTintGetter blockView, BlockPos pos) {
            if (this.invalid) {
                Nameable nameable;
                BlockEntity blockEntity = blockView.m_7702_(pos);
                this.blockEntityName = blockEntity instanceof Nameable ? ((nameable = (Nameable)blockEntity).m_8077_() ? nameable.m_7770_().getString() : null) : null;
                this.invalid = false;
            }
            return this.blockEntityName;
        }

        public void reset() {
            this.invalid = true;
        }
    }
}

