/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.processor;

import java.util.List;
import java.util.function.Function;
import me.pepperbell.continuity.api.client.QuadProcessor;
import me.pepperbell.continuity.api.client.QuadProcessorFactory;
import me.pepperbell.continuity.client.ContinuityClient;
import me.pepperbell.continuity.client.properties.BaseCTMProperties;
import me.pepperbell.continuity.client.util.TextureUtil;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;

public abstract class AbstractQuadProcessorFactory<T extends BaseCTMProperties>
implements QuadProcessorFactory<T> {
    @Override
    public QuadProcessor createProcessor(T properties, Function<Material, TextureAtlasSprite> textureGetter) {
        int i;
        int provided;
        int textureAmount = this.getTextureAmount(properties);
        List<Material> spriteIds = ((BaseCTMProperties)properties).getSpriteIds();
        int max = provided = spriteIds.size();
        if (provided > textureAmount) {
            ContinuityClient.LOGGER.warn("Method '" + ((BaseCTMProperties)properties).getMethod() + "' requires " + textureAmount + " tiles but " + provided + " were provided in file '" + ((BaseCTMProperties)properties).getId() + "' in pack '" + ((BaseCTMProperties)properties).getPackName() + "'");
            max = textureAmount;
        }
        TextureAtlasSprite[] sprites = new TextureAtlasSprite[textureAmount];
        TextureAtlasSprite missingSprite = textureGetter.apply(TextureUtil.MISSING_SPRITE_ID);
        boolean supportsNullSprites = this.supportsNullSprites(properties);
        for (i = 0; i < max; ++i) {
            Material spriteId = spriteIds.get(i);
            TextureAtlasSprite sprite = spriteId.equals((Object)BaseCTMProperties.SPECIAL_SKIP_SPRITE_ID) ? missingSprite : (spriteId.equals((Object)BaseCTMProperties.SPECIAL_DEFAULT_SPRITE_ID) ? (supportsNullSprites ? null : missingSprite) : textureGetter.apply(spriteId));
            sprites[i] = sprite;
        }
        if (provided < textureAmount) {
            ContinuityClient.LOGGER.error("Method '" + ((BaseCTMProperties)properties).getMethod() + "' requires " + textureAmount + " tiles but only " + provided + " were provided in file '" + ((BaseCTMProperties)properties).getId() + "' in pack '" + ((BaseCTMProperties)properties).getPackName() + "'");
            for (i = provided; i < textureAmount; ++i) {
                sprites[i] = missingSprite;
            }
        }
        return this.createProcessor(properties, sprites);
    }

    public abstract QuadProcessor createProcessor(T var1, TextureAtlasSprite[] var2);

    public abstract int getTextureAmount(T var1);

    public boolean supportsNullSprites(T properties) {
        return true;
    }
}

