/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client;

import java.io.IOException;
import java.nio.file.Path;
import me.pepperbell.continuity.api.client.CTMLoader;
import me.pepperbell.continuity.api.client.CTMLoaderRegistry;
import me.pepperbell.continuity.api.client.CTMProperties;
import me.pepperbell.continuity.api.client.CTMPropertiesFactory;
import me.pepperbell.continuity.api.client.QuadProcessorFactory;
import me.pepperbell.continuity.client.processor.CompactCTMQuadProcessor;
import me.pepperbell.continuity.client.processor.HorizontalQuadProcessor;
import me.pepperbell.continuity.client.processor.HorizontalVerticalQuadProcessor;
import me.pepperbell.continuity.client.processor.ProcessingDataKeys;
import me.pepperbell.continuity.client.processor.TopQuadProcessor;
import me.pepperbell.continuity.client.processor.VerticalHorizontalQuadProcessor;
import me.pepperbell.continuity.client.processor.VerticalQuadProcessor;
import me.pepperbell.continuity.client.processor.overlay.SimpleOverlayQuadProcessor;
import me.pepperbell.continuity.client.processor.overlay.StandardOverlayQuadProcessor;
import me.pepperbell.continuity.client.processor.simple.CTMSpriteProvider;
import me.pepperbell.continuity.client.processor.simple.FixedSpriteProvider;
import me.pepperbell.continuity.client.processor.simple.RandomSpriteProvider;
import me.pepperbell.continuity.client.processor.simple.RepeatSpriteProvider;
import me.pepperbell.continuity.client.processor.simple.SimpleQuadProcessor;
import me.pepperbell.continuity.client.properties.BaseCTMProperties;
import me.pepperbell.continuity.client.properties.CompactConnectingCTMProperties;
import me.pepperbell.continuity.client.properties.PropertiesParsingHelper;
import me.pepperbell.continuity.client.properties.RandomCTMProperties;
import me.pepperbell.continuity.client.properties.RepeatCTMProperties;
import me.pepperbell.continuity.client.properties.StandardConnectingCTMProperties;
import me.pepperbell.continuity.client.properties.TileAmountValidator;
import me.pepperbell.continuity.client.properties.overlay.BaseOverlayCTMProperties;
import me.pepperbell.continuity.client.properties.overlay.RandomOverlayCTMProperties;
import me.pepperbell.continuity.client.properties.overlay.RepeatOverlayCTMProperties;
import me.pepperbell.continuity.client.properties.overlay.StandardConnectingOverlayCTMProperties;
import me.pepperbell.continuity.client.properties.overlay.StandardOverlayCTMProperties;
import me.pepperbell.continuity.client.resource.CustomBlockLayers;
import me.pepperbell.continuity.client.util.RenderUtil;
import me.pepperbell.continuity.client.util.biome.BiomeHolderManager;
import me.pepperbell.continuity.client.util.biome.BiomeRetriever;
import me.pepperbell.continuity.impl.client.ProcessingDataKeyRegistryImpl;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.resource.PathPackResources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="connectedness")
public class ContinuityClient {
    public static final String ID = "connectedness";
    public static final String NAME = "Connectedness";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Connectedness");

    public ContinuityClient() {
        ProcessingDataKeyRegistryImpl.INSTANCE.init();
        BiomeHolderManager.init();
        BiomeRetriever.init();
        ProcessingDataKeys.init();
        RenderUtil.ReloadListener.init();
        CustomBlockLayers.ReloadListener.init();
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        CTMLoaderRegistry registry = CTMLoaderRegistry.get();
        CTMLoader<BaseCTMProperties> loader = ContinuityClient.createLoader(StandardConnectingCTMProperties::new, new TileAmountValidator.AtLeast(47), new SimpleQuadProcessor.Factory<StandardConnectingCTMProperties>(new CTMSpriteProvider.Factory(true)));
        registry.registerLoader("ctm", loader);
        registry.registerLoader("glass", loader);
        loader = ContinuityClient.createLoader(CompactConnectingCTMProperties::new, new TileAmountValidator.AtLeast(5), new CompactCTMQuadProcessor.Factory());
        registry.registerLoader("ctm_compact", loader);
        loader = ContinuityClient.createLoader(StandardConnectingCTMProperties::new, new TileAmountValidator.Exactly(4), new HorizontalQuadProcessor.Factory());
        registry.registerLoader("horizontal", loader);
        registry.registerLoader("bookshelf", loader);
        loader = ContinuityClient.createLoader(StandardConnectingCTMProperties::new, new TileAmountValidator.Exactly(4), new VerticalQuadProcessor.Factory());
        registry.registerLoader("vertical", loader);
        loader = ContinuityClient.createLoader(StandardConnectingCTMProperties::new, new TileAmountValidator.Exactly(7), new HorizontalVerticalQuadProcessor.Factory());
        registry.registerLoader("horizontal+vertical", loader);
        registry.registerLoader("h+v", loader);
        loader = ContinuityClient.createLoader(StandardConnectingCTMProperties::new, new TileAmountValidator.Exactly(7), new VerticalHorizontalQuadProcessor.Factory());
        registry.registerLoader("vertical+horizontal", loader);
        registry.registerLoader("v+h", loader);
        loader = ContinuityClient.createLoader(StandardConnectingCTMProperties::new, new TileAmountValidator.Exactly(1), new TopQuadProcessor.Factory());
        registry.registerLoader("top", loader);
        loader = ContinuityClient.createLoader(RandomCTMProperties::new, new SimpleQuadProcessor.Factory<RandomCTMProperties>(new RandomSpriteProvider.Factory()));
        registry.registerLoader("random", loader);
        loader = ContinuityClient.createLoader(RepeatCTMProperties::new, new RepeatCTMProperties.Validator(), new SimpleQuadProcessor.Factory<RepeatCTMProperties>(new RepeatSpriteProvider.Factory()));
        registry.registerLoader("repeat", loader);
        loader = ContinuityClient.createLoader(BaseCTMProperties::new, new TileAmountValidator.Exactly(1), new SimpleQuadProcessor.Factory<BaseCTMProperties>(new FixedSpriteProvider.Factory()));
        registry.registerLoader("fixed", loader);
        loader = ContinuityClient.createLoader(StandardOverlayCTMProperties::new, new TileAmountValidator.AtLeast(17), new StandardOverlayQuadProcessor.Factory());
        registry.registerLoader("overlay", loader);
        loader = ContinuityClient.createLoader(StandardConnectingOverlayCTMProperties::new, new TileAmountValidator.AtLeast(47), new SimpleOverlayQuadProcessor.Factory<StandardConnectingCTMProperties>(new CTMSpriteProvider.Factory(false)));
        registry.registerLoader("overlay_ctm", loader);
        loader = ContinuityClient.createLoader(RandomOverlayCTMProperties::new, new SimpleOverlayQuadProcessor.Factory<RandomCTMProperties>(new RandomSpriteProvider.Factory()));
        registry.registerLoader("overlay_random", loader);
        loader = ContinuityClient.createLoader(RepeatOverlayCTMProperties::new, new RepeatCTMProperties.Validator(), new SimpleOverlayQuadProcessor.Factory<RepeatCTMProperties>(new RepeatSpriteProvider.Factory()));
        registry.registerLoader("overlay_repeat", loader);
        loader = ContinuityClient.createLoader(BaseOverlayCTMProperties::new, new TileAmountValidator.Exactly(1), new SimpleOverlayQuadProcessor.Factory<BaseCTMProperties>(new FixedSpriteProvider.Factory()));
        registry.registerLoader("overlay_fixed", loader);
    }

    private static <T extends BaseCTMProperties> CTMLoader<T> createLoader(CTMPropertiesFactory<T> propertiesFactory, TileAmountValidator<T> validator, QuadProcessorFactory<T> processorFactory) {
        return CTMLoader.of(ContinuityClient.wrapWithOptifineOnlyCheck(TileAmountValidator.wrapFactory(BaseCTMProperties.wrapFactory(propertiesFactory), validator)), processorFactory);
    }

    private static <T extends BaseCTMProperties> CTMLoader<T> createLoader(CTMPropertiesFactory<T> propertiesFactory, QuadProcessorFactory<T> processorFactory) {
        return CTMLoader.of(ContinuityClient.wrapWithOptifineOnlyCheck(BaseCTMProperties.wrapFactory(propertiesFactory)), processorFactory);
    }

    private static <T extends CTMProperties> CTMPropertiesFactory<T> wrapWithOptifineOnlyCheck(CTMPropertiesFactory<T> factory) {
        return (properties, id, packName, packPriority, method) -> {
            if (PropertiesParsingHelper.parseOptifineOnly(properties, id)) {
                return null;
            }
            return factory.createProperties(properties, id, packName, packPriority, method);
        };
    }

    public static ResourceLocation asId(String path) {
        return new ResourceLocation(ID, path);
    }

    @SubscribeEvent
    public void addDefaultPack(AddPackFindersEvent event) {
        try {
            if (event.getPackType() == PackType.CLIENT_RESOURCES) {
                Path resourcePath = ModList.get().getModFileById(ID).getFile().findResource(new String[]{"resourcepacks/default"});
                PathPackResources pack = new PathPackResources(ModList.get().getModFileById(ID).getFile().getFileName() + ":" + resourcePath, resourcePath);
                PackMetadataSection metadataSection = (PackMetadataSection)pack.m_5550_((MetadataSectionSerializer)PackMetadataSection.f_10366_);
                if (metadataSection != null) {
                    event.addRepositorySource((packConsumer, packConstructor) -> packConsumer.accept(packConstructor.create("builtin/default_ctm_resources", (Component)Component.m_237113_((String)"Default CTM"), false, () -> pack, metadataSection, Pack.Position.TOP, PackSource.f_10528_, false)));
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @SubscribeEvent
    public void addGlassPack(AddPackFindersEvent event) {
        try {
            if (event.getPackType() == PackType.CLIENT_RESOURCES) {
                Path resourcePath = ModList.get().getModFileById(ID).getFile().findResource(new String[]{"resourcepacks/glass_pane_culling_fix"});
                PathPackResources pack = new PathPackResources(ModList.get().getModFileById(ID).getFile().getFileName() + ":" + resourcePath, resourcePath);
                PackMetadataSection metadataSection = (PackMetadataSection)pack.m_5550_((MetadataSectionSerializer)PackMetadataSection.f_10366_);
                if (metadataSection != null) {
                    event.addRepositorySource((packConsumer, packConstructor) -> packConsumer.accept(packConstructor.create("builtin/glass_pane_fix_resources", (Component)Component.m_237113_((String)"Glass pane culling fix"), false, () -> pack, metadataSection, Pack.Position.TOP, PackSource.f_10528_, false)));
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

