/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_forge.fakeplayer;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.natamus.collective_common_forge.fakeplayer.FakePlayer;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;

public class FakePlayerFactory {
    private static final GameProfile MINECRAFT = new GameProfile(UUID.fromString("41C82C87-7AfB-4024-BA57-13D2C99CAE77"), "[Minecraft]");
    private static final Map<GameProfile, FakePlayer> fakePlayers = Maps.newHashMap();
    private static WeakReference<FakePlayer> MINECRAFT_PLAYER = null;

    public static FakePlayer getMinecraft(ServerLevel world) {
        FakePlayer ret;
        FakePlayer fakePlayer = ret = MINECRAFT_PLAYER != null ? (FakePlayer)((Object)MINECRAFT_PLAYER.get()) : null;
        if (ret == null) {
            ret = FakePlayerFactory.get(world, MINECRAFT);
            MINECRAFT_PLAYER = new WeakReference<FakePlayer>(ret);
        }
        return ret;
    }

    public static FakePlayer get(ServerLevel serverLevel, GameProfile gameProfile) {
        if (!fakePlayers.containsKey(gameProfile)) {
            FakePlayer fakePlayer = new FakePlayer(serverLevel.m_7654_(), serverLevel, gameProfile, null);
            fakePlayers.put(gameProfile, fakePlayer);
        }
        return fakePlayers.get(gameProfile);
    }

    public static void unloadWorld(ServerLevel world) {
        FakePlayer mc;
        fakePlayers.entrySet().removeIf(entry -> ((FakePlayer)((Object)((Object)entry.getValue()))).m_20193_() == world);
        if (MINECRAFT_PLAYER != null && MINECRAFT_PLAYER.get() != null && ((FakePlayer)((Object)MINECRAFT_PLAYER.get())).m_20193_() == world && (mc = (FakePlayer)((Object)MINECRAFT_PLAYER.get())) != null && mc.m_20193_() == world) {
            MINECRAFT_PLAYER = null;
        }
    }
}

