/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.clayworks.core.data.server;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.teamabnormals.blueprint.common.block.VerticalSlabBlock;
import com.teamabnormals.clayworks.common.block.KilnBlock;
import com.teamabnormals.clayworks.core.registry.ClayworksBlocks;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.registries.ForgeRegistries;

public class ClayworksLootTableProvider
extends LootTableProvider {
    private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> tables = ImmutableList.of((Object)Pair.of(ClayworksBlockLoot::new, (Object)LootContextParamSets.f_81421_));

    public ClayworksLootTableProvider(DataGenerator generator) {
        super(generator);
    }

    public List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return this.tables;
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext context) {
    }

    private static class ClayworksBlockLoot
    extends BlockLoot {
        private ClayworksBlockLoot() {
        }

        public void addTables() {
            ClayworksBlocks.HELPER.getDeferredRegister().getEntries().forEach(registryObject -> {
                Block block = (Block)registryObject.get();
                if (block instanceof KilnBlock) {
                    this.m_124175_(block, x$0 -> BlockLoot.m_124292_((Block)x$0));
                } else if (block instanceof SlabBlock) {
                    this.m_124175_(block, x$0 -> BlockLoot.m_124290_((Block)x$0));
                } else if (block instanceof VerticalSlabBlock) {
                    this.m_124175_(block, ClayworksBlockLoot::createVerticalSlabItemTable);
                } else {
                    this.m_124288_(block);
                }
            });
        }

        protected static LootTable.Builder createVerticalSlabItemTable(Block block) {
            return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)ClayworksBlockLoot.m_236221_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)VerticalSlabBlock.TYPE, (Comparable)VerticalSlabBlock.VerticalSlabType.DOUBLE)))))));
        }

        public Iterable<Block> getKnownBlocks() {
            return ForgeRegistries.BLOCKS.getValues().stream().filter(block -> ForgeRegistries.BLOCKS.getKey(block).m_135827_().equals("clayworks")).collect(Collectors.toSet());
        }
    }
}

