/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.network.packet;

import io.github.mortuusars.chalk.Chalk;
import io.github.mortuusars.chalk.items.ChalkBoxItem;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public record ServerboundOpenChalkBoxPacket(int slotID) {
    public static ServerboundOpenChalkBoxPacket fromBuffer(FriendlyByteBuf buffer) {
        return new ServerboundOpenChalkBoxPacket(buffer.readInt());
    }

    public void toBuffer(FriendlyByteBuf buffer) {
        buffer.writeInt(this.slotID);
    }

    public boolean handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        @Nullable ServerPlayer player = context.getSender();
        if (player == null) {
            Chalk.LOGGER.error("ServerboundOpenChalkBoxPacket cannot be handled: player was null.");
            return false;
        }
        ItemStack chalkBox = player.m_150109_().m_8020_(this.slotID);
        if (chalkBox.m_41619_() || !(chalkBox.m_41720_() instanceof ChalkBoxItem)) {
            Chalk.LOGGER.error("ServerboundOpenChalkBoxPacket cannot be handled: wrong item in slot. [" + chalkBox + "]");
            return false;
        }
        ChalkBoxItem.openGUI((Player)player, chalkBox);
        return true;
    }
}

