/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.common.headshot;

import com.mrcrayfish.guns.common.headshot.BasicHeadshotBox;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RotatedHeadshotBox<T extends LivingEntity>
extends BasicHeadshotBox<T> {
    protected double headZOffset;
    protected boolean rotatePitch;
    protected boolean rotateYaw;

    public RotatedHeadshotBox(double headSize, double headYOffset, double headZOffset, boolean rotatePitch, boolean rotateYaw) {
        super(headSize, headSize, headYOffset);
        this.headZOffset = headZOffset;
        this.rotatePitch = rotatePitch;
        this.rotateYaw = rotateYaw;
    }

    public RotatedHeadshotBox(double headWidth, double headHeight, double headYOffset, double headZOffset, boolean rotatePitch, boolean rotateYaw) {
        super(headWidth, headHeight, headYOffset);
        this.headZOffset = headZOffset;
        this.rotatePitch = rotatePitch;
        this.rotateYaw = rotateYaw;
    }

    @Override
    @Nullable
    public AABB getHeadshotBox(T entity) {
        AABB headBox = super.getHeadshotBox(entity);
        if (headBox != null) {
            headBox = headBox.m_82383_(Vec3.m_82498_((float)(this.rotatePitch ? entity.m_146909_() : 0.0f), (float)(this.rotateYaw ? ((LivingEntity)entity).f_20883_ : 0.0f)).m_82541_().m_82490_(this.headZOffset * 0.0625));
            return headBox;
        }
        return null;
    }
}

