/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media.items;

import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.common.ContainerHeldItem;
import dan200.computercraft.shared.network.container.HeldItemContainerData;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ItemPrintout
extends Item {
    private static final String NBT_TITLE = "Title";
    private static final String NBT_PAGES = "Pages";
    private static final String NBT_LINE_TEXT = "Text";
    private static final String NBT_LINE_COLOUR = "Color";
    public static final int LINES_PER_PAGE = 21;
    public static final int LINE_MAX_LENGTH = 25;
    public static final int MAX_PAGES = 16;
    private final Type type;

    public ItemPrintout(Item.Properties settings, Type type) {
        super(settings);
        this.type = type;
    }

    public void m_7373_(@Nonnull ItemStack stack, Level world, @Nonnull List<Component> list, @Nonnull TooltipFlag options) {
        String title = ItemPrintout.getTitle(stack);
        if (title != null && !title.isEmpty()) {
            list.add((Component)Component.m_237113_((String)title));
        }
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, @Nonnull Player player, @Nonnull InteractionHand hand) {
        if (!world.f_46443_) {
            new HeldItemContainerData(hand).open(player, new ContainerHeldItem.Factory((MenuType<ContainerHeldItem>)((MenuType)Registry.ModContainers.PRINTOUT.get()), player.m_21120_(hand), hand));
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.m_21120_(hand));
    }

    @Nonnull
    private ItemStack createFromTitleAndText(String title, String[] text, String[] colours) {
        int i;
        CompoundTag tag;
        ItemStack stack = new ItemStack((ItemLike)this);
        if (title != null) {
            stack.m_41784_().m_128359_(NBT_TITLE, title);
        }
        if (text != null) {
            tag = stack.m_41784_();
            tag.m_128405_(NBT_PAGES, text.length / 21);
            for (i = 0; i < text.length; ++i) {
                if (text[i] == null) continue;
                tag.m_128359_(NBT_LINE_TEXT + i, text[i]);
            }
        }
        if (colours != null) {
            tag = stack.m_41784_();
            for (i = 0; i < colours.length; ++i) {
                if (colours[i] == null) continue;
                tag.m_128359_(NBT_LINE_COLOUR + i, colours[i]);
            }
        }
        return stack;
    }

    @Nonnull
    public static ItemStack createSingleFromTitleAndText(String title, String[] text, String[] colours) {
        return ((ItemPrintout)((Object)Registry.ModItems.PRINTED_PAGE.get())).createFromTitleAndText(title, text, colours);
    }

    @Nonnull
    public static ItemStack createMultipleFromTitleAndText(String title, String[] text, String[] colours) {
        return ((ItemPrintout)((Object)Registry.ModItems.PRINTED_PAGES.get())).createFromTitleAndText(title, text, colours);
    }

    @Nonnull
    public static ItemStack createBookFromTitleAndText(String title, String[] text, String[] colours) {
        return ((ItemPrintout)((Object)Registry.ModItems.PRINTED_BOOK.get())).createFromTitleAndText(title, text, colours);
    }

    public Type getType() {
        return this.type;
    }

    public static String getTitle(@Nonnull ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128441_(NBT_TITLE) ? nbt.m_128461_(NBT_TITLE) : null;
    }

    public static int getPageCount(@Nonnull ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128441_(NBT_PAGES) ? nbt.m_128451_(NBT_PAGES) : 1;
    }

    public static String[] getText(@Nonnull ItemStack stack) {
        return ItemPrintout.getLines(stack, NBT_LINE_TEXT);
    }

    public static String[] getColours(@Nonnull ItemStack stack) {
        return ItemPrintout.getLines(stack, NBT_LINE_COLOUR);
    }

    private static String[] getLines(@Nonnull ItemStack stack, String prefix) {
        CompoundTag nbt = stack.m_41783_();
        int numLines = ItemPrintout.getPageCount(stack) * 21;
        String[] lines = new String[numLines];
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = nbt != null ? nbt.m_128461_(prefix + i) : "";
        }
        return lines;
    }

    public static enum Type {
        PAGE,
        PAGES,
        BOOK;

    }
}

