/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.impl;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleRefuelHandler;
import dan200.computercraft.api.turtle.event.TurtleRefuelEvent;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public final class TurtleRefuelHandlers {
    private static final List<TurtleRefuelHandler> handlers = new CopyOnWriteArrayList<TurtleRefuelHandler>();

    private TurtleRefuelHandlers() {
    }

    public static synchronized void register(TurtleRefuelHandler handler) {
        Objects.requireNonNull(handler, "handler cannot be null");
        handlers.add(handler);
    }

    public static OptionalInt refuel(ITurtleAccess turtle, ItemStack stack, int slot, int limit) {
        for (TurtleRefuelHandler handler : handlers) {
            OptionalInt fuel = handler.refuel(turtle, stack, slot, limit);
            if (!fuel.isPresent()) continue;
            int refuelled = fuel.getAsInt();
            if (refuelled < 0) {
                throw new IllegalStateException(handler + " returned a negative value");
            }
            if (limit == 0 && refuelled != 0) {
                throw new IllegalStateException(handler + " refuelled despite given a limit of 0");
            }
            return fuel;
        }
        return OptionalInt.empty();
    }

    static {
        handlers.add((turtle, stack, slot, limit) -> {
            TurtleRefuelEvent event = new TurtleRefuelEvent(turtle, stack);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.getHandler() == null) {
                return OptionalInt.empty();
            }
            if (limit == 0) {
                return OptionalInt.of(0);
            }
            return OptionalInt.of(event.getHandler().refuel(turtle, stack, slot, limit));
        });
    }
}

