/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.internal.cobalt.lib.platform;

import cc.tweaked.internal.cobalt.lib.platform.ResourceManipulator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileResourceManipulator
implements ResourceManipulator {
    @Override
    public InputStream findResource(String filename) {
        File f = new File(filename);
        if (!f.exists()) {
            Class<?> c = this.getClass();
            return c.getResourceAsStream(filename.startsWith("/") ? filename : "/" + filename);
        }
        try {
            return new FileInputStream(f);
        }
        catch (IOException ioe) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(String command) {
        Runtime r = Runtime.getRuntime();
        Process p = r.exec(command);
        try {
            p.waitFor();
            int n = p.exitValue();
            p.destroy();
            return n;
        }
        catch (Throwable throwable) {
            try {
                p.destroy();
                throw throwable;
            }
            catch (IOException ioe) {
                return 1;
            }
            catch (InterruptedException e) {
                return -2;
            }
            catch (Throwable t) {
                return -3;
            }
        }
    }

    @Override
    public void rename(String from, String to) throws IOException {
        File f = new File(from);
        if (!f.exists()) {
            throw new IOException("No such file or directory");
        }
        if (!f.renameTo(new File(to))) {
            throw new IOException("Failed to rename");
        }
    }

    @Override
    public void remove(String file) throws IOException {
        File f = new File(file);
        if (!f.exists()) {
            throw new IOException("No such file or directory");
        }
        if (!f.delete()) {
            throw new IOException("Failed to delete");
        }
    }

    @Override
    public String tmpName() throws IOException {
        File f = File.createTempFile(".luaj", "tmp");
        f.deleteOnExit();
        return f.getName();
    }
}

