/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.impl.fluid;

import earth.terrarium.botarium.common.fluid.base.BotariumFluidBlock;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.impl.AutoSerializable;
import earth.terrarium.botarium.impl.fluid.ForgeFluidHolder;
import earth.terrarium.botarium.util.Serializable;
import earth.terrarium.botarium.util.Updatable;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ForgeFluidContainer(BotariumFluidBlock<?> fluidGetter, BlockEntity entity) implements ICapabilityProvider
{
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
        Object container = this.fluidGetter.getFluidContainer(this.entity.m_58904_(), this.entity.m_58899_(), this.entity.m_58900_(), this.entity, arg);
        return capability == ForgeCapabilities.FLUID_HANDLER && container != null ? LazyOptional.of(() -> new ForgeFluidHandler<FluidContainer>((FluidContainer)container)).cast() : LazyOptional.empty();
    }

    public record ForgeFluidHandler<T extends FluidContainer & Updatable>(T container) implements IFluidHandler,
    AutoSerializable
    {
        public int getTanks() {
            return this.container.getSize();
        }

        @NotNull
        public FluidStack getFluidInTank(int i) {
            return new ForgeFluidHolder((FluidHolder)this.container.getFluids().get((int)i)).fluidStack;
        }

        public int getTankCapacity(int i) {
            return (int)this.container.getTankCapacity(i);
        }

        public boolean isFluidValid(int i, @NotNull FluidStack fluidStack) {
            return this.container.isFluidValid(i, new ForgeFluidHolder(fluidStack));
        }

        public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
            int i = (int)this.container.insertFluid(new ForgeFluidHolder(fluidStack), fluidAction.simulate());
            if (i > 0 && fluidAction.execute()) {
                ((Updatable)this.container).update();
            }
            return i;
        }

        @NotNull
        public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
            FluidStack fluidStack1 = new ForgeFluidHolder(this.container.extractFluid(new ForgeFluidHolder(fluidStack), fluidAction.simulate())).getFluidStack();
            if (!fluidStack1.isEmpty() && fluidAction.execute()) {
                ((Updatable)this.container).update();
            }
            return fluidStack1;
        }

        @NotNull
        public FluidStack drain(int i, IFluidHandler.FluidAction fluidAction) {
            FluidHolder holder = this.container.getFluids().stream().filter(Predicate.not(FluidHolder::isEmpty)).findFirst().orElse(FluidHolder.empty());
            if (i <= 0 || holder.isEmpty()) {
                return FluidStack.EMPTY;
            }
            FluidStack fluidStack = new ForgeFluidHolder(this.container.extractFluid(holder, fluidAction.simulate())).getFluidStack();
            if (!fluidStack.isEmpty() && fluidAction.execute()) {
                ((Updatable)this.container).update();
            }
            return fluidStack;
        }

        @Override
        public Serializable getSerializable() {
            return this.container;
        }
    }
}

