/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile;

import com.legacy.blue_skies.entities.util.base.SkiesMonsterEntity;
import com.legacy.blue_skies.registries.SkiesSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PolargeistEntity
extends SkiesMonsterEntity {
    private static final EntityDataAccessor<Boolean> STANDING = SynchedEntityData.m_135353_(PolargeistEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float standTicks;
    private float prevStandTicks;

    public PolargeistEntity(EntityType<? extends PolargeistEntity> type, Level world) {
        super(type, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.7f, true){

            protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
                double d0 = this.m_6639_(enemy);
                if (distToEnemySqr <= d0 && this.m_25564_()) {
                    this.m_25563_();
                    this.f_25540_.m_7327_((Entity)enemy);
                    PolargeistEntity.this.setStanding(false);
                } else if (distToEnemySqr <= d0 * 2.0) {
                    if (this.m_25564_()) {
                        PolargeistEntity.this.setStanding(false);
                        this.m_25563_();
                    }
                    if (this.m_25565_() <= 10) {
                        PolargeistEntity.this.setStanding(true);
                    }
                } else {
                    this.m_25563_();
                    PolargeistEntity.this.setStanding(false);
                }
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 26.0).m_22268_(Attributes.f_22279_, (double)0.23f).m_22268_(Attributes.f_22281_, 4.5);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STANDING, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
    }

    public void m_20258_(CompoundTag compound) {
        super.m_20258_(compound);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!(this.m_6084_() && this.m_5448_() != null || !this.isStanding() || this.f_19853_.f_46443_)) {
            this.setStanding(false);
        }
        if (this.f_19853_.f_46443_) {
            if (this.standTicks != this.prevStandTicks) {
                this.m_6210_();
            }
            this.prevStandTicks = this.standTicks;
            this.standTicks = this.isStanding() ? Mth.m_14036_((float)(this.standTicks + 1.0f), (float)0.0f, (float)6.0f) : Mth.m_14036_((float)(this.standTicks - 1.0f), (float)0.0f, (float)6.0f);
        }
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        if (this.standTicks > 0.0f) {
            float f = this.standTicks / 6.0f;
            float f1 = 1.0f + f;
            return super.m_6972_(poseIn).m_20390_(1.0f, f1);
        }
        return super.m_6972_(poseIn);
    }

    public boolean isStanding() {
        return (Boolean)this.f_19804_.m_135370_(STANDING);
    }

    public void setStanding(boolean standing) {
        this.f_19804_.m_135381_(STANDING, (Object)standing);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getStandingAnimationScale(float p_189795_1_) {
        return Mth.m_14179_((float)p_189795_1_, (float)this.prevStandTicks, (float)this.standTicks) / 6.0f;
    }

    protected SoundEvent m_7515_() {
        return SkiesSounds.ENTITY_POLARGEIST_IDLE;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SkiesSounds.ENTITY_POLARGEIST_HURT;
    }

    protected SoundEvent m_5592_() {
        return SkiesSounds.ENTITY_POLARGEIST_DEATH;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12284_, 0.15f, 1.0f);
    }

    protected float m_6121_() {
        return 1.0f;
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return 1.2f;
    }

    public boolean m_7327_(Entity entityIn) {
        this.m_5496_(SkiesSounds.ENTITY_POLARGEIST_ATTACK, this.m_6121_(), this.m_6100_());
        return super.m_7327_(entityIn);
    }

    public boolean m_5545_(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        boolean randomBoolean = this.f_19853_.m_46471_() ? true : this.f_19796_.m_188499_();
        return randomBoolean && super.m_5545_(worldIn, spawnReasonIn);
    }

    @Override
    public float m_5610_(BlockPos pos, LevelReader worldIn) {
        return 0.0f;
    }

    public int m_5792_() {
        return 1;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }
}

