/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.natural;

import com.legacy.blue_skies.blocks.natural.FruitBlock;
import com.legacy.blue_skies.blocks.natural.SkyLeavesBlock;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;

public class HangingFruitLeavesBlock
extends SkyLeavesBlock
implements BonemealableBlock {
    public static final BooleanProperty CAN_GROW = BooleanProperty.m_61465_((String)"mature");
    private final Supplier<FruitBlock> fruit;

    public HangingFruitLeavesBlock(Supplier<FruitBlock> fruit) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_));
        this.fruit = fruit;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)CAN_GROW, (Comparable)Boolean.valueOf(false)));
    }

    public FruitBlock getFruit() {
        return this.fruit.get();
    }

    public boolean m_6724_(BlockState state) {
        return (Boolean)state.m_61143_((Property)f_54419_) == false || (Boolean)state.m_61143_((Property)CAN_GROW) != false;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (this.ableToGrow(state, (BlockGetter)level, pos) && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (rand.m_188501_() < 0.2f && !this.getFruit().isOvercrowded(level, pos) ? 1 : 0) != 0)) {
            this.grow(level, pos);
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
        super.m_213898_(state, level, pos, rand);
    }

    public boolean ableToGrow(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)CAN_GROW) != false && level.m_8055_(pos.m_7495_()).m_60795_();
    }

    public void grow(ServerLevel level, BlockPos pos) {
        level.m_46597_(pos.m_7495_(), this.getFruit().m_49966_());
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{CAN_GROW});
    }

    public boolean m_7370_(BlockGetter level, BlockPos pos, BlockState state, boolean isClient) {
        return this.ableToGrow(state, level, pos);
    }

    public boolean m_214167_(Level level, RandomSource rand, BlockPos pos, BlockState state) {
        return rand.m_188501_() < 0.75f;
    }

    public void m_214148_(ServerLevel level, RandomSource rand, BlockPos pos, BlockState state) {
        this.grow(level, pos);
    }
}

