/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks;

import com.google.common.collect.ImmutableList;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.data.objects.tags.SkiesStructureTags;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesDimensions;
import com.legacy.blue_skies.registries.SkiesParticles;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.LogicUtil;
import com.legacy.structure_gel.api.block.GelPortalBlock;
import com.legacy.structure_gel.api.dimension.portal.GelTeleporter;
import com.legacy.structure_gel.api.structure.StructureAccessHelper;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.BlockUtil;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SkyPortalBlock
extends GelPortalBlock {
    public static final List<Block> ALLOWED_INSIDE_BLOCKS = ImmutableList.of((Object)Blocks.f_50083_, (Object)SkiesBlocks.blue_fire, (Object)SkiesBlocks.black_fire, (Object)SkiesBlocks.upsidedown_blue_fire, (Object)SkiesBlocks.upsidedown_black_fire);
    private final boolean isEverbright;

    public SkyPortalBlock(Supplier<ResourceKey<Level>> startingDimensionIn, Supplier<ResourceKey<Level>> endpointDimensionIn, Supplier<PoiType> portalPOI, Supplier<BlockState> frameBlockIn, boolean isEverbright) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50142_).lootFrom(() -> Blocks.f_50016_), (serverLevel, portal) -> new Teleporter((ServerLevel)serverLevel, startingDimensionIn, endpointDimensionIn, portalPOI, () -> portal, frameBlockIn));
        this.isEverbright = isEverbright;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (rand.m_188503_(190) == 0) {
            if (this == SkiesBlocks.everdawn_portal) {
                worldIn.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SkiesSounds.BLOCK_EVERDAWN_PORTAL, SoundSource.BLOCKS, 0.3f, 1.0f, false);
            } else {
                worldIn.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SkiesSounds.BLOCK_EVERBRIGHT_PORTAL, SoundSource.BLOCKS, 0.4f, rand.m_188501_() * 0.4f + 0.8f, false);
            }
        }
        for (int i = 0; i < 2; ++i) {
            double x = LogicUtil.plusOrMinus((double)pos.m_123341_() + 0.5, 0.45, rand);
            double y = LogicUtil.plusOrMinus((double)pos.m_123342_() + 0.5, 0.45, rand);
            double z = LogicUtil.plusOrMinus((double)pos.m_123343_() + 0.5, 0.45, rand);
            double dx = LogicUtil.plusOrMinus(0.06, rand);
            double dy = this.isEverbright ? -1.0E-4 : 1.0E-4;
            double dz = LogicUtil.plusOrMinus(0.001, rand);
            if (stateIn.m_61143_((Property)f_54904_) == Direction.Axis.X) {
                dx = LogicUtil.plusOrMinus(0.001, rand);
                dz = LogicUtil.plusOrMinus(0.06, rand);
                z = (double)pos.m_123343_() + 0.5;
            } else {
                x = (double)pos.m_123341_() + 0.5;
            }
            worldIn.m_7106_((ParticleOptions)(this.isEverbright ? SkiesParticles.EVERBRIGHT_PORTAL : SkiesParticles.EVERDAWN_PORTAL), x, y, z, dx, dy, dz);
        }
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        int z;
        int x;
        int y;
        BlockState frameBlock = (BlockState)this.getTeleporter(null).getFrameBlock().get();
        for (y = -1; y <= 3; ++y) {
            if (placer.m_6350_() == Direction.NORTH || placer.m_6350_() == Direction.SOUTH) {
                for (x = -1; x <= 2; ++x) {
                    worldIn.m_7731_(pos.m_7918_(x, y, 0), frameBlock, 18);
                }
                continue;
            }
            for (z = -1; z <= 2; ++z) {
                worldIn.m_7731_(pos.m_7918_(0, y, z), frameBlock, 18);
            }
        }
        for (y = 0; y <= 2; ++y) {
            if (placer.m_6350_() == Direction.NORTH || placer.m_6350_() == Direction.SOUTH) {
                for (x = 0; x <= 1; ++x) {
                    worldIn.m_7731_(pos.m_7918_(x, y, 0), (BlockState)this.m_49966_().m_61124_((Property)f_54904_, (Comparable)Direction.Axis.X), 18);
                }
                continue;
            }
            for (z = 0; z <= 1; ++z) {
                worldIn.m_7731_(pos.m_7918_(0, y, z), (BlockState)this.m_49966_().m_61124_((Property)f_54904_, (Comparable)Direction.Axis.Z), 18);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public SoundInstance getTriggerSound() {
        if (this.isEverbright) {
            return SimpleSoundInstance.m_119766_((SoundEvent)SkiesSounds.BLOCK_EVERBRIGHT_PORTAL_TRIGGER, (float)(new Random().nextFloat() * 0.2f + 0.9f), (float)0.4f);
        }
        return SimpleSoundInstance.m_119766_((SoundEvent)SkiesSounds.BLOCK_EVERDAWN_PORTAL_TRIGGER, (float)(new Random().nextFloat() * 0.2f + 0.9f), (float)0.35f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public SoundInstance getTravelSound() {
        if (this.isEverbright) {
            return SimpleSoundInstance.m_119766_((SoundEvent)SkiesSounds.BLOCK_EVERBRIGHT_PORTAL_TRAVEL, (float)(new Random().nextFloat() * 0.4f + 0.8f), (float)1.0f);
        }
        return SimpleSoundInstance.m_119766_((SoundEvent)SkiesSounds.BLOCK_EVERDAWN_PORTAL_TRAVEL, (float)(new Random().nextFloat() * 0.2f + 0.9f), (float)1.0f);
    }

    private static final class Teleporter
    extends GelTeleporter {
        public Teleporter(ServerLevel world, Supplier<ResourceKey<Level>> dimension1, Supplier<ResourceKey<Level>> dimension2, Supplier<PoiType> portalPOI, Supplier<GelPortalBlock> portalBlock, Supplier<BlockState> frameBlock) {
            super(world, dimension1, dimension2, portalPOI, portalBlock, frameBlock, Teleporter::makeNew);
        }

        public Optional<BlockUtil.FoundRectangle> findPortalAround(BlockPos startPos, boolean toNether) {
            Optional result = super.findPortalAround(startPos, toNether);
            if (result.isPresent()) {
                return result;
            }
            return super.findPortalAround(Teleporter.shiftPosition(this, startPos), toNether);
        }

        public static Optional<BlockUtil.FoundRectangle> makeNew(GelTeleporter teleporter, BlockPos startPos, Direction.Axis enterAxis) {
            return GelTeleporter.createAndFindPortalSurface((GelTeleporter)teleporter, (BlockPos)Teleporter.shiftPosition(teleporter, startPos), (Direction.Axis)enterAxis);
        }

        private static BlockPos shiftPosition(GelTeleporter teleporter, BlockPos startPos) {
            BlockPos newPos = startPos;
            ResourceKey destWorldKey = teleporter.getLevel().m_46472_();
            ResourceLocation destWorldLocation = destWorldKey.m_135782_();
            if (destWorldLocation.equals((Object)SkiesDimensions.EVERBRIGHT_ID) || destWorldLocation.equals((Object)SkiesDimensions.EVERDAWN_ID)) {
                boolean shiftPortal;
                ServerLevel destWorld = teleporter.getLevel().m_7654_().m_129880_(destWorldKey);
                int moves = 0;
                do {
                    shiftPortal = false;
                    if (StructureAccessHelper.hasStructureChunkInRange((ChunkGenerator)destWorld.m_7726_().m_8481_(), (RandomState)destWorld.m_7726_().m_214994_(), SkiesStructureTags.DUNGEONS, (RegistryAccess)destWorld.m_5962_(), (long)destWorld.m_7328_(), (ChunkPos)new ChunkPos(newPos), (int)1)) {
                        shiftPortal = true;
                        newPos = newPos.m_122013_(64);
                        ++moves;
                        break;
                    }
                    if (moves <= 10) continue;
                    BlueSkies.LOGGER.info("Hit the portal position distance shifting limit.");
                    break;
                } while (shiftPortal);
            }
            return newPos;
        }
    }
}

