/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui_hud.widget;

import io.github.thecsdev.betterstats.client.gui_hud.widget.BSHudStatWidget;
import io.github.thecsdev.betterstats.util.ItemStatEnum;
import io.github.thecsdev.betterstats.util.StatUtils;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TContextMenuPanel;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.StatsCounter;
import net.minecraft.world.item.Item;

public class BSHudStatWidget_Item
extends BSHudStatWidget {
    public final Item item;
    protected BSHudStatWidget.LabelEntry lblStatEntry;
    protected ItemStatEnum shownStat;

    public BSHudStatWidget_Item(int x, int y, StatsCounter statHandler, Item item) {
        super(x, y, statHandler);
        this.item = Objects.requireNonNull(item, "item must not be null.");
        this.shownStat = ItemStatEnum.MINED;
    }

    public void tick() {
        this.lblStatEntry.setText(this.createText());
    }

    @Override
    public void onInit() {
        this.addItemEntry(this.item);
        this.lblStatEntry = new BSHudStatWidget.LabelEntry(null);
    }

    public Component createText() {
        StatUtils.StatUtilsItemStat stat = new StatUtils.StatUtilsItemStat(this.statHandler, this.item);
        Object txt = "";
        switch (this.shownStat) {
            case MINED: {
                txt = stat.sMined + " " + TextUtils.translatable((String)"stat_type.minecraft.mined", (Object[])new Object[0]).getString();
                break;
            }
            case CRAFTED: {
                txt = stat.sCrafted + " " + TextUtils.translatable((String)"stat_type.minecraft.crafted", (Object[])new Object[0]).getString();
                break;
            }
            case USED: {
                txt = stat.sUsed + " " + TextUtils.translatable((String)"stat_type.minecraft.used", (Object[])new Object[0]).getString();
                break;
            }
            case BROKEN: {
                txt = stat.sBroken + " " + TextUtils.translatable((String)"stat_type.minecraft.broken", (Object[])new Object[0]).getString();
                break;
            }
            case PICKED_UP: {
                txt = stat.sPickedUp + " " + TextUtils.translatable((String)"stat_type.minecraft.picked_up", (Object[])new Object[0]).getString();
                break;
            }
            case DROPPED: {
                txt = stat.sDropped + " " + TextUtils.translatable((String)"stat_type.minecraft.dropped", (Object[])new Object[0]).getString();
                break;
            }
            default: {
                txt = "null";
            }
        }
        return TextUtils.literal((String)txt);
    }

    @Override
    protected void onContextMenu(TContextMenuPanel contextMenu) {
        for (ItemStatEnum itemStat : ItemStatEnum.values()) {
            contextMenu.addButton(itemStat.getIText(), btn -> {
                this.shownStat = itemStat;
                this.tick();
            });
        }
        super.onContextMenu(contextMenu);
    }
}

