/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.panel.stats;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.thecsdev.betterstats.client.gui.panel.BSPanel;
import io.github.thecsdev.betterstats.client.gui.widget.BSScrollBarWidget;
import io.github.thecsdev.betterstats.util.StatUtils;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TLabelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TPanelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.util.FocusOrigin;
import io.github.thecsdev.tcdcommons.api.client.gui.util.GuiUtils;
import io.github.thecsdev.tcdcommons.api.client.gui.util.HorizontalAlignment;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.awt.Color;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.StatsCounter;

public abstract class BSStatPanel
extends BSPanel {
    public static final int COLOR_NORMAL_HOVERED = 0x50FFFFFF;
    public static final int COLOR_NORMAL_FOCUSED = -5570561;
    public static final int COLOR_GOLD_FOCUSED = Color.YELLOW.getRGB();
    protected final BSScrollBarWidget scroll_this = new BSScrollBarWidget(this.getTpeEndX(), this.getTpeY(), 8, this.getTpeHeight(), this);

    public BSStatPanel(TPanelElement parentToFill) {
        this(parentToFill.getTpeX(), parentToFill.getTpeY(), parentToFill.getTpeWidth(), parentToFill.getTpeHeight());
        parentToFill.addTChild((TElement)this, false);
    }

    public BSStatPanel(int x, int y, int width, int height) {
        super(x, y, width - 8, height);
        this.setScrollPadding(10);
        this.setSmoothScroll(true);
    }

    public final BSScrollBarWidget getVerticalScrollBar() {
        return this.scroll_this;
    }

    public void setPosition(int x, int y, int flags) {
        super.setPosition(x, y, flags);
        this.scroll_this.setPosition(this.getTpeEndX(), this.getTpeY(), false);
    }

    public void onParentChanged() {
        super.onParentChanged();
        if (this.scroll_this.getTParent() != null && this.scroll_this.getTParent() != this.getTParent()) {
            this.scroll_this.getTParent().removeTChild((TElement)this.scroll_this);
        }
        if (this.getTParent() != null) {
            this.getTParent().addTChild((TElement)this.scroll_this, false);
            this.scroll_this.refreshKnobSize();
        }
    }

    public int getStatOutlineColor() {
        return 1;
    }

    public abstract void init(StatsCounter var1, Predicate<StatUtils.StatUtilsStat> var2);

    protected TLabelElement init_groupLabel(Component groupName) {
        int x = this.getTpeX() + this.getScrollPadding();
        int y = this.getTpeY() + this.getScrollPadding();
        TElement lastChild = this.getLastTChild(false);
        if (lastChild != null) {
            y = lastChild.getTpeEndY() + 10;
        }
        if (groupName == null) {
            groupName = TextUtils.literal((String)"*");
        }
        int lblW = this.getTpeWidth() - this.getScrollPadding() * 2;
        TLabelElement label = new TLabelElement(x, y, lblW, 20);
        label.setText(groupName);
        label.setColor(Color.yellow.getRGB(), Color.orange.getRGB());
        this.addTChild((TElement)label, false);
        return label;
    }

    protected TLabelElement init_noResults() {
        int sp = this.getScrollPadding();
        TLabelElement lbl = new TLabelElement(sp, sp, this.getTpeWidth() - sp * 2, this.getTpeHeight() - sp * 2);
        lbl.setHorizontalAlignment(HorizontalAlignment.CENTER);
        lbl.setText((Component)TextUtils.translatable((String)"betterstats.gui.no_stats_yet", (Object[])new Object[0]));
        this.addTChild((TElement)lbl);
        return lbl;
    }

    public Predicate<StatUtils.StatUtilsStat> getStatPredicate() {
        return stat -> true;
    }

    public void render(PoseStack matrices, int mouseX, int mouseY, float deltaTime) {
        this.renderSmoothScroll(deltaTime);
    }

    @Override
    public void postRender(PoseStack matrices, int mouseX, int mouseY, float deltaTime) {
    }

    protected abstract class BSStatWidget
    extends TElement {
        public BSStatWidget(int x, int y, int width, int height) {
            super(x, y, width, height);
        }

        public boolean canChangeFocus(FocusOrigin focusOrigin, boolean gainingFocus) {
            return true;
        }

        public abstract void updateTooltip();

        protected void renderBackground(PoseStack matrices, int mouseX, int mouseY, float deltaTime) {
            BSStatWidget.m_93172_((PoseStack)matrices, (int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)GuiUtils.applyAlpha((int)0x50000000, (float)this.getAlpha()));
        }

        public void render(PoseStack matrices, int mouseX, int mouseY, float deltaTime) {
            this.renderBackground(matrices, mouseX, mouseY, deltaTime);
        }

        public void postRender(PoseStack matrices, int mouseX, int mouseY, float deltaTime) {
            if (this.isFocused()) {
                this.drawOutline(matrices, -5570561);
            } else if (this.isHovered()) {
                this.drawOutline(matrices, 0x50FFFFFF);
            }
        }

        public boolean mousePressed(int mouseX, int mouseY, int button) {
            if (button == 1) {
                this.showContextMenu(mouseX, mouseY);
                return true;
            }
            if (!this.isFocused() || this.screen == null) {
                return true;
            }
            this.screen.setFocusedTChild(null);
            return false;
        }
    }
}

