/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.data.server.modifiers;

import com.mojang.datafixers.util.Pair;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBiomes;
import com.teamabnormals.blueprint.common.world.modification.ModdedBiomeSliceProvider;
import com.teamabnormals.blueprint.core.registry.BlueprintBiomes;
import com.teamabnormals.blueprint.core.util.BiomeUtil;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.dimension.LevelStem;

public final class AtmosphericModdedBiomeSliceProvider
extends ModdedBiomeSliceProvider {
    public AtmosphericModdedBiomeSliceProvider(DataGenerator dataGenerator) {
        super(dataGenerator, "atmospheric");
    }

    protected void registerSlices() {
        ArrayList entries = new ArrayList();
        new AtmosphericBiomeBuilder().addBiomes(entries::add);
        this.registerSlice("main", 7, (BiomeUtil.ModdedBiomeProvider)new BiomeUtil.MultiNoiseModdedBiomeProvider(new Climate.ParameterList(entries)), new ResourceLocation[]{LevelStem.f_63971_.m_135782_()});
    }

    private static final class AtmosphericBiomeBuilder {
        private final Climate.Parameter FULL_RANGE = Climate.Parameter.m_186822_((float)-1.0f, (float)1.0f);
        private final Climate.Parameter[] temperatures = new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.45f), Climate.Parameter.m_186822_((float)-0.45f, (float)-0.15f), Climate.Parameter.m_186822_((float)-0.15f, (float)0.2f), Climate.Parameter.m_186822_((float)0.2f, (float)0.55f), Climate.Parameter.m_186822_((float)0.55f, (float)1.0f)};
        private final Climate.Parameter[] humidities = new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.35f), Climate.Parameter.m_186822_((float)-0.35f, (float)-0.1f), Climate.Parameter.m_186822_((float)-0.1f, (float)0.1f), Climate.Parameter.m_186822_((float)0.1f, (float)0.3f), Climate.Parameter.m_186822_((float)0.3f, (float)1.0f)};
        private final Climate.Parameter[] erosions = new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.78f), Climate.Parameter.m_186822_((float)-0.78f, (float)-0.375f), Climate.Parameter.m_186822_((float)-0.375f, (float)-0.2225f), Climate.Parameter.m_186822_((float)-0.2225f, (float)0.05f), Climate.Parameter.m_186822_((float)0.05f, (float)0.45f), Climate.Parameter.m_186822_((float)0.45f, (float)0.55f), Climate.Parameter.m_186822_((float)0.55f, (float)1.0f)};
        private final Climate.Parameter coastContinentalness = Climate.Parameter.m_186822_((float)-0.19f, (float)-0.11f);
        private final Climate.Parameter inlandContinentalness = Climate.Parameter.m_186822_((float)-0.11f, (float)0.55f);
        private final Climate.Parameter nearInlandContinentalness = Climate.Parameter.m_186822_((float)-0.11f, (float)0.03f);
        private final Climate.Parameter midInlandContinentalness = Climate.Parameter.m_186822_((float)0.03f, (float)0.3f);
        private final Climate.Parameter farInlandContinentalness = Climate.Parameter.m_186822_((float)0.3f, (float)1.0f);
        private final ResourceKey<Biome> VANILLA = BlueprintBiomes.ORIGINAL_SOURCE_MARKER.getKey();
        private final ResourceKey<Biome>[][] MIDDLE_BIOMES = new ResourceKey[][]{{AtmosphericBiomes.SNOWY_SCRUBLAND.getKey(), this.VANILLA, this.VANILLA, AtmosphericBiomes.KOUSA_JUNGLE.getKey(), this.VANILLA}, {this.VANILLA, this.VANILLA, this.VANILLA, this.VANILLA, AtmosphericBiomes.ASPEN_PARKLAND.getKey()}, {this.VANILLA, this.VANILLA, this.VANILLA, AtmosphericBiomes.LAUREL_FOREST.getKey(), AtmosphericBiomes.ASPEN_PARKLAND.getKey()}, {this.VANILLA, this.VANILLA, this.VANILLA, AtmosphericBiomes.RAINFOREST.getKey(), AtmosphericBiomes.RAINFOREST.getKey()}, {AtmosphericBiomes.SCRUBLAND.getKey(), AtmosphericBiomes.SCRUBLAND.getKey(), AtmosphericBiomes.SCRUBLAND.getKey(), AtmosphericBiomes.DUNES.getKey(), AtmosphericBiomes.FLOURISHING_DUNES.getKey()}};
        private final ResourceKey<Biome>[][] MIDDLE_BIOMES_VARIANT = new ResourceKey[][]{{this.VANILLA, null, this.VANILLA, null, null}, {null, null, null, null, this.VANILLA}, {this.VANILLA, null, null, this.VANILLA, null}, {null, null, this.VANILLA, null, null}, {null, null, null, null, null}};
        private final ResourceKey<Biome>[][] PLATEAU_BIOMES = new ResourceKey[][]{{AtmosphericBiomes.SNOWY_SCRUBLAND.getKey(), this.VANILLA, AtmosphericBiomes.KOUSA_JUNGLE.getKey(), AtmosphericBiomes.KOUSA_JUNGLE.getKey(), AtmosphericBiomes.KOUSA_JUNGLE.getKey()}, {this.VANILLA, this.VANILLA, this.VANILLA, this.VANILLA, AtmosphericBiomes.ASPEN_PARKLAND.getKey()}, {this.VANILLA, this.VANILLA, AtmosphericBiomes.LAUREL_FOREST.getKey(), AtmosphericBiomes.LAUREL_FOREST.getKey(), AtmosphericBiomes.ASPEN_PARKLAND.getKey()}, {this.VANILLA, this.VANILLA, this.VANILLA, AtmosphericBiomes.RAINFOREST.getKey(), AtmosphericBiomes.RAINFOREST.getKey()}, {AtmosphericBiomes.SCRUBLAND.getKey(), AtmosphericBiomes.SCRUBLAND.getKey(), AtmosphericBiomes.ROCKY_DUNES.getKey(), AtmosphericBiomes.ROCKY_DUNES.getKey(), AtmosphericBiomes.ROCKY_DUNES.getKey()}};
        private final ResourceKey<Biome>[][] PLATEAU_BIOMES_VARIANT = new ResourceKey[][]{{this.VANILLA, null, null, null, null}, {null, null, this.VANILLA, null, this.VANILLA}, {null, null, this.VANILLA, this.VANILLA, null}, {null, null, null, null, AtmosphericBiomes.SPARSE_RAINFOREST.getKey()}, {AtmosphericBiomes.SCRUBLAND.getKey(), AtmosphericBiomes.SCRUBLAND.getKey(), AtmosphericBiomes.PETRIFIED_DUNES.getKey(), null, null}};
        private final ResourceKey<Biome>[][] SHATTERED_BIOMES = new ResourceKey[][]{{this.VANILLA, this.VANILLA, this.VANILLA, this.VANILLA, this.VANILLA}, {this.VANILLA, this.VANILLA, this.VANILLA, this.VANILLA, this.VANILLA}, {this.VANILLA, this.VANILLA, this.VANILLA, this.VANILLA, this.VANILLA}, {null, null, null, AtmosphericBiomes.RAINFOREST.getKey(), AtmosphericBiomes.RAINFOREST.getKey()}, {null, null, null, null, null}};

        private AtmosphericBiomeBuilder() {
        }

        private void addBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumer) {
            this.addOffCoastBiomes(consumer);
            this.addInlandBiomes(consumer);
            this.addUndergroundBiomes(consumer);
        }

        private void addOffCoastBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumer) {
            this.addSurfaceBiome(consumer, this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186822_((float)-1.2f, (float)-0.35f), this.FULL_RANGE, this.FULL_RANGE, 0.0f, this.VANILLA);
            this.addSurfaceBiome(consumer, Climate.Parameter.m_186822_((float)-1.0f, (float)0.2f), this.FULL_RANGE, Climate.Parameter.m_186822_((float)-0.35f, (float)-0.19f), this.FULL_RANGE, this.FULL_RANGE, 0.0f, this.VANILLA);
            this.addSurfaceBiome(consumer, this.temperatures[3], Climate.Parameter.m_186822_((float)0.1f, (float)1.0f), Climate.Parameter.m_186822_((float)-0.35f, (float)-0.19f), this.FULL_RANGE, this.FULL_RANGE, 0.0f, (ResourceKey<Biome>)AtmosphericBiomes.RAINFOREST_BASIN.getKey());
            this.addSurfaceBiome(consumer, this.temperatures[4], Climate.Parameter.m_186822_((float)0.1f, (float)1.0f), Climate.Parameter.m_186822_((float)-0.35f, (float)-0.19f), this.FULL_RANGE, this.FULL_RANGE, 0.0f, this.VANILLA);
        }

        private void addInlandBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumer) {
            this.addMidSlice(consumer, Climate.Parameter.m_186822_((float)-1.0f, (float)-0.93333334f));
            this.addHighSlice(consumer, Climate.Parameter.m_186822_((float)-0.93333334f, (float)-0.7666667f));
            this.addPeaks(consumer, Climate.Parameter.m_186822_((float)-0.7666667f, (float)-0.56666666f));
            this.addHighSlice(consumer, Climate.Parameter.m_186822_((float)-0.56666666f, (float)-0.4f));
            this.addMidSlice(consumer, Climate.Parameter.m_186822_((float)-0.4f, (float)-0.26666668f));
            this.addLowSlice(consumer, Climate.Parameter.m_186822_((float)-0.26666668f, (float)-0.05f));
            this.addValleys(consumer, Climate.Parameter.m_186822_((float)-0.05f, (float)0.05f));
            this.addLowSlice(consumer, Climate.Parameter.m_186822_((float)0.05f, (float)0.26666668f));
            this.addMidSlice(consumer, Climate.Parameter.m_186822_((float)0.26666668f, (float)0.4f));
            this.addHighSlice(consumer, Climate.Parameter.m_186822_((float)0.4f, (float)0.56666666f));
            this.addPeaks(consumer, Climate.Parameter.m_186822_((float)0.56666666f, (float)0.7666667f));
            this.addHighSlice(consumer, Climate.Parameter.m_186822_((float)0.7666667f, (float)0.93333334f));
            this.addMidSlice(consumer, Climate.Parameter.m_186822_((float)0.93333334f, (float)1.0f));
        }

        private void addPeaks(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumer, Climate.Parameter weirdness) {
            for (int i = 0; i < this.temperatures.length; ++i) {
                Climate.Parameter climate$parameter = this.temperatures[i];
                for (int j = 0; j < this.humidities.length; ++j) {
                    Climate.Parameter climate$parameter1 = this.humidities[j];
                    ResourceKey<Biome> resourcekey = this.pickMiddleBiome(i, j, weirdness);
                    ResourceKey<Biome> resourcekey1 = this.pickMiddleBiomeOrDunesIfHot(i, j, weirdness);
                    ResourceKey<Biome> resourcekey2 = this.pickMiddleBiomeOrDunesIfHotOrSlopeIfCold(i, j, weirdness);
                    ResourceKey<Biome> resourcekey3 = this.pickPlateauBiome(i, j, weirdness);
                    ResourceKey<Biome> resourcekey4 = this.pickShatteredBiome(i, j, weirdness);
                    ResourceKey<Biome> resourcekey5 = this.maybePickWindsweptRainforestBiome(i, j, weirdness, resourcekey4);
                    ResourceKey<Biome> resourcekey6 = this.pickPeakBiome(i, j, weirdness);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], weirdness, 0.0f, resourcekey6);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[1], weirdness, 0.0f, resourcekey2);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[1], weirdness, 0.0f, resourcekey6);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), weirdness, 0.0f, resourcekey);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[2], weirdness, 0.0f, resourcekey3);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, this.midInlandContinentalness, this.erosions[3], weirdness, 0.0f, resourcekey1);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, this.farInlandContinentalness, this.erosions[3], weirdness, 0.0f, resourcekey3);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, resourcekey);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[5], weirdness, 0.0f, resourcekey5);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, resourcekey4);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, resourcekey);
                }
            }
        }

        private void addHighSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumer, Climate.Parameter weirdness) {
            for (int i = 0; i < this.temperatures.length; ++i) {
                Climate.Parameter climate$parameter = this.temperatures[i];
                for (int j = 0; j < this.humidities.length; ++j) {
                    Climate.Parameter climate$parameter1 = this.humidities[j];
                    ResourceKey<Biome> resourcekey = this.pickMiddleBiome(i, j, weirdness);
                    ResourceKey<Biome> resourcekey1 = this.pickMiddleBiomeOrDunesIfHot(i, j, weirdness);
                    ResourceKey<Biome> resourcekey2 = this.pickMiddleBiomeOrDunesIfHotOrSlopeIfCold(i, j, weirdness);
                    ResourceKey<Biome> resourcekey3 = this.pickPlateauBiome(i, j, weirdness);
                    ResourceKey<Biome> resourcekey4 = this.pickShatteredBiome(i, j, weirdness);
                    ResourceKey<Biome> resourcekey5 = this.maybePickWindsweptRainforestBiome(i, j, weirdness, resourcekey);
                    ResourceKey<Biome> resourcekey6 = this.pickSlopeBiome(i, j, weirdness);
                    ResourceKey<Biome> resourcekey7 = this.pickPeakBiome(i, j, weirdness);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, resourcekey);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, this.nearInlandContinentalness, this.erosions[0], weirdness, 0.0f, resourcekey6);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], weirdness, 0.0f, resourcekey7);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, this.nearInlandContinentalness, this.erosions[1], weirdness, 0.0f, resourcekey2);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[1], weirdness, 0.0f, resourcekey6);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), weirdness, 0.0f, resourcekey);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[2], weirdness, 0.0f, resourcekey3);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, this.midInlandContinentalness, this.erosions[3], weirdness, 0.0f, resourcekey1);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, this.farInlandContinentalness, this.erosions[3], weirdness, 0.0f, resourcekey3);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, resourcekey);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[5], weirdness, 0.0f, resourcekey5);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, resourcekey4);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, resourcekey);
                }
            }
        }

        private void addMidSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumer, Climate.Parameter weirdness) {
            this.addSurfaceBiome(consumer, this.FULL_RANGE, this.FULL_RANGE, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[2]), weirdness, 0.0f, this.VANILLA);
            this.addSurfaceBiome(consumer, Climate.Parameter.m_186822_((float)-1.0f, (float)0.2f), this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, this.VANILLA);
            this.addSurfaceBiome(consumer, Climate.Parameter.m_186822_((float)0.2f, (float)0.6f), Climate.Parameter.m_186822_((float)0.1f, (float)1.0f), Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, (ResourceKey<Biome>)AtmosphericBiomes.RAINFOREST_BASIN.getKey());
            this.addSurfaceBiome(consumer, Climate.Parameter.m_186822_((float)0.6f, (float)1.0f), this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, this.VANILLA);
            for (int i = 0; i < this.temperatures.length; ++i) {
                Climate.Parameter climate$parameter = this.temperatures[i];
                for (int j = 0; j < this.humidities.length; ++j) {
                    Climate.Parameter climate$parameter1 = this.humidities[j];
                    ResourceKey<Biome> resourcekey = this.pickMiddleBiome(i, j, weirdness);
                    ResourceKey<Biome> resourcekey1 = this.pickMiddleBiomeOrDunesIfHot(i, j, weirdness);
                    ResourceKey<Biome> resourcekey2 = this.pickMiddleBiomeOrDunesIfHotOrSlopeIfCold(i, j, weirdness);
                    ResourceKey<Biome> resourcekey3 = this.pickShatteredBiome(i, j, weirdness);
                    ResourceKey<Biome> resourcekey4 = this.pickPlateauBiome(i, j, weirdness);
                    ResourceKey<Biome> resourcekey5 = this.pickBeachBiome(i, j, weirdness);
                    ResourceKey<Biome> resourcekey6 = this.maybePickWindsweptRainforestBiome(i, j, weirdness, resourcekey);
                    ResourceKey<Biome> resourcekey7 = this.pickShatteredCoastBiome(i, j, weirdness);
                    ResourceKey<Biome> resourcekey8 = this.pickSlopeBiome(i, j, weirdness);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], weirdness, 0.0f, resourcekey8);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.midInlandContinentalness), this.erosions[1], weirdness, 0.0f, resourcekey2);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, this.farInlandContinentalness, this.erosions[1], weirdness, 0.0f, i == 0 ? resourcekey8 : resourcekey4);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, this.nearInlandContinentalness, this.erosions[2], weirdness, 0.0f, resourcekey);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, this.midInlandContinentalness, this.erosions[2], weirdness, 0.0f, resourcekey1);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, this.farInlandContinentalness, this.erosions[2], weirdness, 0.0f, resourcekey4);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[3], weirdness, 0.0f, resourcekey);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[3], weirdness, 0.0f, resourcekey1);
                    if (weirdness.f_186814_() < 0L) {
                        this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, this.coastContinentalness, this.erosions[4], weirdness, 0.0f, resourcekey5);
                        this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, resourcekey);
                    } else {
                        this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, resourcekey);
                    }
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, this.coastContinentalness, this.erosions[5], weirdness, 0.0f, resourcekey7);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, this.nearInlandContinentalness, this.erosions[5], weirdness, 0.0f, resourcekey6);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, resourcekey3);
                    if (weirdness.f_186814_() < 0L) {
                        this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, resourcekey5);
                    } else {
                        this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, resourcekey);
                    }
                    if (i != 0) continue;
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, resourcekey);
                }
            }
        }

        private void addLowSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumer, Climate.Parameter weirdness) {
            this.addSurfaceBiome(consumer, this.FULL_RANGE, this.FULL_RANGE, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[2]), weirdness, 0.0f, this.VANILLA);
            this.addSurfaceBiome(consumer, Climate.Parameter.m_186822_((float)-1.0f, (float)0.2f), this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, this.VANILLA);
            this.addSurfaceBiome(consumer, Climate.Parameter.m_186822_((float)0.2f, (float)0.6f), Climate.Parameter.m_186822_((float)0.1f, (float)1.0f), Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, (ResourceKey<Biome>)AtmosphericBiomes.RAINFOREST_BASIN.getKey());
            this.addSurfaceBiome(consumer, Climate.Parameter.m_186822_((float)0.6f, (float)1.0f), this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, this.VANILLA);
            for (int i = 0; i < this.temperatures.length; ++i) {
                Climate.Parameter climate$parameter = this.temperatures[i];
                for (int j = 0; j < this.humidities.length; ++j) {
                    Climate.Parameter climate$parameter1 = this.humidities[j];
                    ResourceKey<Biome> resourcekey = this.pickMiddleBiome(i, j, weirdness);
                    ResourceKey<Biome> resourcekey1 = this.pickMiddleBiomeOrDunesIfHot(i, j, weirdness);
                    ResourceKey<Biome> resourcekey2 = this.pickMiddleBiomeOrDunesIfHotOrSlopeIfCold(i, j, weirdness);
                    ResourceKey<Biome> resourcekey3 = this.pickBeachBiome(i, j, weirdness);
                    ResourceKey<Biome> resourcekey4 = this.maybePickWindsweptRainforestBiome(i, j, weirdness, resourcekey);
                    ResourceKey<Biome> resourcekey5 = this.pickShatteredCoastBiome(i, j, weirdness);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, resourcekey1);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, resourcekey2);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), weirdness, 0.0f, resourcekey);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), weirdness, 0.0f, resourcekey1);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[3], (Climate.Parameter)this.erosions[4]), weirdness, 0.0f, resourcekey3);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, resourcekey);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, this.coastContinentalness, this.erosions[5], weirdness, 0.0f, resourcekey5);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, this.nearInlandContinentalness, this.erosions[5], weirdness, 0.0f, resourcekey4);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, resourcekey);
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, resourcekey3);
                    if (i != 0) continue;
                    this.addSurfaceBiome(consumer, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, resourcekey);
                }
            }
        }

        private void addValleys(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumer, Climate.Parameter weirdness) {
            this.addRiverBiomes(consumer, Climate.Parameter.m_186822_((float)-1.0f, (float)0.2f), this.FULL_RANGE, weirdness, this.VANILLA);
            this.addRiverBiomes(consumer, Climate.Parameter.m_186822_((float)0.2f, (float)0.6f), Climate.Parameter.m_186822_((float)0.1f, (float)1.0f), weirdness, (ResourceKey<Biome>)AtmosphericBiomes.RAINFOREST_BASIN.getKey());
            this.addRiverBiomes(consumer, Climate.Parameter.m_186822_((float)0.6f, (float)1.0f), this.FULL_RANGE, weirdness, this.VANILLA);
            for (int temperatureIndex = 0; temperatureIndex < this.temperatures.length; ++temperatureIndex) {
                Climate.Parameter temperature = this.temperatures[temperatureIndex];
                for (int humidityIndex = 0; humidityIndex < this.humidities.length; ++humidityIndex) {
                    Climate.Parameter humidity = this.humidities[humidityIndex];
                    ResourceKey<Biome> resourcekey = this.pickMiddleBiomeOrDunesIfHot(temperatureIndex, humidityIndex, weirdness);
                    this.addSurfaceBiome(consumer, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, resourcekey);
                }
            }
        }

        private void addRiverBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumer, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter weirdness, ResourceKey<Biome> biome) {
            this.addSurfaceBiome(consumer, temperature, humidity, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, weirdness.f_186814_() < 0L ? this.VANILLA : biome);
            this.addSurfaceBiome(consumer, temperature, humidity, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, biome);
            this.addSurfaceBiome(consumer, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[5]), weirdness, 0.0f, biome);
            this.addSurfaceBiome(consumer, temperature, humidity, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, biome);
            this.addSurfaceBiome(consumer, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.inlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, biome);
        }

        private void addUndergroundBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumer) {
            this.addUndergroundBiome(consumer, this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186822_((float)0.8f, (float)1.0f), this.FULL_RANGE, this.FULL_RANGE, 0.0f, this.VANILLA);
            this.addUndergroundBiome(consumer, this.FULL_RANGE, Climate.Parameter.m_186822_((float)0.7f, (float)1.0f), this.FULL_RANGE, this.FULL_RANGE, this.FULL_RANGE, 0.0f, this.VANILLA);
        }

        private ResourceKey<Biome> pickMiddleBiome(int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
            if (weirdness.f_186814_() < 0L) {
                return this.MIDDLE_BIOMES[temperatureIndex][humidityIndex];
            }
            ResourceKey<Biome> resourcekey = this.MIDDLE_BIOMES_VARIANT[temperatureIndex][humidityIndex];
            return resourcekey == null ? this.MIDDLE_BIOMES[temperatureIndex][humidityIndex] : resourcekey;
        }

        private ResourceKey<Biome> pickMiddleBiomeOrDunesIfHot(int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
            return temperatureIndex == 4 ? this.pickDuneBiome(humidityIndex, weirdness) : this.pickMiddleBiome(temperatureIndex, humidityIndex, weirdness);
        }

        private ResourceKey<Biome> pickMiddleBiomeOrDunesIfHotOrSlopeIfCold(int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
            return temperatureIndex == 0 ? this.pickSlopeBiome(temperatureIndex, humidityIndex, weirdness) : this.pickMiddleBiomeOrDunesIfHot(temperatureIndex, humidityIndex, weirdness);
        }

        private ResourceKey<Biome> maybePickWindsweptRainforestBiome(int temperatureIndex, int humidityIndex, Climate.Parameter weirdness, ResourceKey<Biome> biome) {
            if (weirdness.f_186814_() >= 0L) {
                if (temperatureIndex == 3 && humidityIndex > 1) {
                    return AtmosphericBiomes.RAINFOREST.getKey();
                }
                if (temperatureIndex > 1 && humidityIndex < 4) {
                    return this.VANILLA;
                }
            }
            return biome;
        }

        private ResourceKey<Biome> pickShatteredCoastBiome(int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
            ResourceKey<Biome> resourcekey = weirdness.f_186814_() >= 0L ? this.pickMiddleBiome(temperatureIndex, humidityIndex, weirdness) : this.pickBeachBiome(temperatureIndex, humidityIndex, weirdness);
            return this.maybePickWindsweptRainforestBiome(temperatureIndex, humidityIndex, weirdness, resourcekey);
        }

        private ResourceKey<Biome> pickBeachBiome(int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
            if (temperatureIndex == 0) {
                return this.VANILLA;
            }
            if (temperatureIndex == 3 && humidityIndex > 2) {
                return weirdness.f_186814_() >= 0L ? AtmosphericBiomes.RAINFOREST_BASIN.getKey() : AtmosphericBiomes.SPARSE_RAINFOREST_BASIN.getKey();
            }
            return this.VANILLA;
        }

        private ResourceKey<Biome> pickDuneBiome(int humidityIndex, Climate.Parameter weirdness) {
            if (humidityIndex < 1) {
                return weirdness.f_186814_() < 0L ? AtmosphericBiomes.PETRIFIED_DUNES.getKey() : AtmosphericBiomes.ROCKY_DUNES.getKey();
            }
            if (humidityIndex < 3) {
                return AtmosphericBiomes.DUNES.getKey();
            }
            return humidityIndex < 4 ? AtmosphericBiomes.FLOURISHING_DUNES.getKey() : AtmosphericBiomes.SPINY_THICKET.getKey();
        }

        private ResourceKey<Biome> pickPlateauBiome(int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
            if (weirdness.f_186814_() < 0L) {
                return this.PLATEAU_BIOMES[temperatureIndex][humidityIndex];
            }
            ResourceKey<Biome> resourcekey = this.PLATEAU_BIOMES_VARIANT[temperatureIndex][humidityIndex];
            return resourcekey == null ? this.PLATEAU_BIOMES[temperatureIndex][humidityIndex] : resourcekey;
        }

        private ResourceKey<Biome> pickPeakBiome(int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
            if (temperatureIndex <= 2) {
                return this.VANILLA;
            }
            if (temperatureIndex == 3) {
                return this.VANILLA;
            }
            return humidityIndex < 2 && weirdness.f_186814_() < 0L ? AtmosphericBiomes.PETRIFIED_DUNES.getKey() : AtmosphericBiomes.ROCKY_DUNES.getKey();
        }

        private ResourceKey<Biome> pickSlopeBiome(int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
            if (temperatureIndex >= 3) {
                return this.pickPlateauBiome(temperatureIndex, humidityIndex, weirdness);
            }
            return this.VANILLA;
        }

        private ResourceKey<Biome> pickShatteredBiome(int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
            ResourceKey<Biome> resourcekey = this.SHATTERED_BIOMES[temperatureIndex][humidityIndex];
            return resourcekey == null ? this.pickMiddleBiome(temperatureIndex, humidityIndex, weirdness) : resourcekey;
        }

        private void addSurfaceBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumer, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter p_187184_, Climate.Parameter p_187185_, Climate.Parameter p_187186_, float p_187187_, ResourceKey<Biome> p_187188_) {
            consumer.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)p_187184_, (Climate.Parameter)p_187185_, (Climate.Parameter)Climate.Parameter.m_186820_((float)0.0f), (Climate.Parameter)p_187186_, (float)p_187187_), p_187188_));
            consumer.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)p_187184_, (Climate.Parameter)p_187185_, (Climate.Parameter)Climate.Parameter.m_186820_((float)1.0f), (Climate.Parameter)p_187186_, (float)p_187187_), p_187188_));
        }

        private void addUndergroundBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumer, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter p_187204_, Climate.Parameter p_187205_, Climate.Parameter p_187206_, float p_187207_, ResourceKey<Biome> p_187208_) {
            consumer.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)p_187204_, (Climate.Parameter)p_187205_, (Climate.Parameter)Climate.Parameter.m_186822_((float)0.2f, (float)0.9f), (Climate.Parameter)p_187206_, (float)p_187207_), p_187208_));
        }
    }
}

