/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.blueprint.common.levelgen.feature.BlueprintTreeFeature;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class LaurelTreeFeature
extends BlueprintTreeFeature {
    public LaurelTreeFeature(Codec<TreeConfiguration> config) {
        super(config);
    }

    public void doPlace(FeaturePlaceContext<TreeConfiguration> context) {
        TreeConfiguration config = (TreeConfiguration)context.m_159778_();
        RandomSource random = context.m_225041_();
        BlockPos origin = context.m_159777_();
        int trunkHeight = config.f_68190_.m_226153_(random);
        for (int y = 0; y < trunkHeight; ++y) {
            this.addLog(origin.m_6630_(y));
        }
        Direction.Axis axis = Direction.Plane.HORIZONTAL.m_235692_(random);
        Direction.Plane.HORIZONTAL.m_122557_().filter(direction -> direction.m_122434_() == axis).forEach(direction -> this.createBranch(origin.m_6630_(trunkHeight), (Direction)direction, random));
    }

    public BlockState getSapling() {
        return ((Block)AtmosphericBlocks.LAUREL_SAPLING.get()).m_49966_();
    }

    private void createBranch(BlockPos pos, Direction direction, RandomSource random) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        mutablePos.m_122190_((Vec3i)pos.m_121945_(direction));
        int firstHeight = 1 + random.m_188503_(2);
        mutablePos.m_122190_((Vec3i)mutablePos.m_6625_(random.m_188503_(2)));
        for (int i = 0; i < firstHeight; ++i) {
            this.addLog(mutablePos.m_6630_(i));
        }
        int secondHeight = 1 + random.m_188503_(2);
        mutablePos.m_122190_((Vec3i)mutablePos.m_121945_(direction).m_6630_(firstHeight - random.m_188503_(2)));
        for (int i = 0; i < secondHeight; ++i) {
            this.addLog(mutablePos.m_6630_(i));
        }
        mutablePos.m_122190_((Vec3i)mutablePos.m_6630_(secondHeight - 1));
        this.createLeafChunk((BlockPos)mutablePos, direction, random);
    }

    public void createLeafChunk(BlockPos pos, Direction direction, RandomSource random) {
        this.createLeafLayer(pos.m_7494_(), false, random);
        this.createLeafLayer(pos, true, random);
        this.createLeafLayer(pos.m_7495_(), false, random);
        this.createVines(pos.m_7495_().m_7949_(), direction, random);
    }

    private void createLeafLayer(BlockPos pos, boolean square, RandomSource random) {
        int leafSize = 1;
        for (int i = -leafSize; i <= leafSize; ++i) {
            for (int k = -leafSize; k <= leafSize; ++k) {
                if (square) {
                    this.addFoliage(pos.m_7918_(i, 0, k));
                    continue;
                }
                if (Math.abs(i) != leafSize || Math.abs(k) != leafSize) {
                    this.addFoliage(pos.m_7918_(i, 0, k));
                    continue;
                }
                if (random.m_188503_(4) != 0) continue;
                this.addFoliage(pos.m_7918_(i, 0, k));
            }
        }
    }

    private void createVines(BlockPos pos, Direction direction, RandomSource random) {
        HashSet vinePositions = Sets.newHashSet();
        int vineCount = 2 + random.m_188503_(2) + random.m_188503_(2);
        int placedVines = 0;
        while (placedVines < vineCount) {
            BlockPos.MutableBlockPos vinePos = new BlockPos.MutableBlockPos();
            vinePos.m_122190_((Vec3i)pos);
            if (random.m_188503_(5) < 3) {
                vinePos.m_122190_((Vec3i)vinePos.m_121945_(direction));
            }
            if (random.m_188503_(5) < 4) {
                vinePos.m_122190_((Vec3i)(random.m_188499_() ? vinePos.m_121945_(direction.m_122427_()) : vinePos.m_121945_(direction.m_122428_())));
            }
            boolean canGen = pos.m_123341_() != vinePos.m_123341_() || pos.m_123343_() != vinePos.m_123343_();
            for (Direction vineDirection : Direction.values()) {
                if (!vinePositions.contains(vinePos.m_121945_(vineDirection))) continue;
                canGen = false;
            }
            if (!canGen) continue;
            int length = 2 + random.m_188503_(2);
            for (int i = 0; i < length; ++i) {
                this.addFoliage(vinePos.m_6625_(i));
            }
            ++placedVines;
            vinePositions.add(vinePos);
        }
    }
}

