/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.entity.ai.goal;

import com.teamabnormals.atmospheric.common.entity.Cochineal;
import java.util.EnumSet;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;

public class CochinealPanicGoal
extends Goal {
    private final Cochineal cochineal;
    private int idleTime;
    private int fleeTime;
    private float direction;

    public CochinealPanicGoal(Cochineal cochineal) {
        this.cochineal = cochineal;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return !this.cochineal.isInFluidType() && this.shouldPanic();
    }

    public boolean m_8045_() {
        return !this.cochineal.isInFluidType() && --this.fleeTime > 0;
    }

    public void m_8056_() {
        this.idleTime = 0;
        this.fleeTime = this.m_183277_(240);
        this.direction = this.cochineal.m_217043_().m_188501_() * ((float)Math.PI * 2);
        this.cochineal.setJumpingQuickly(true);
        this.cochineal.detachFromCactus();
    }

    public void m_8041_() {
        this.cochineal.setJumpingQuickly(false);
    }

    public void m_8037_() {
        if (this.cochineal.canLeap()) {
            Cochineal.CochinealMoveControl control = (Cochineal.CochinealMoveControl)this.cochineal.m_21566_();
            Vec3 vec3 = this.cochineal.m_20182_().m_82549_(new Vec3(Math.sin(this.direction) * 32.0, 0.0, Math.cos(this.direction) * 32.0));
            for (int i = 0; i < 3; ++i) {
                Vec3 vec31 = DefaultRandomPos.m_148412_((PathfinderMob)this.cochineal, (int)14, (int)7, (Vec3)vec3, (double)1.5707963267948966);
                if (vec31 == null) continue;
                vec31.m_82520_(0.5, 0.0, 0.5);
                if (!control.canReach(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_)) continue;
                control.leapTo(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_);
                this.idleTime = 0;
                return;
            }
            if (++this.idleTime > this.m_183277_(40)) {
                this.direction = this.cochineal.m_217043_().m_188501_() * ((float)Math.PI * 2);
                this.idleTime = 0;
            }
        }
    }

    private boolean shouldPanic() {
        return this.cochineal.m_21188_() != null || this.cochineal.m_203117_() || this.cochineal.m_6060_();
    }
}

