/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import com.teamabnormals.atmospheric.client.model.DragonFruitModel;
import com.teamabnormals.atmospheric.client.renderer.entity.layers.FloweringDragonFruitLayer;
import com.teamabnormals.atmospheric.common.entity.projectile.DragonFruit;
import com.teamabnormals.atmospheric.core.other.AtmosphericModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DragonFruitRenderer<T extends DragonFruit>
extends EntityRenderer<T>
implements RenderLayerParent<T, DragonFruitModel<T>> {
    private static final ResourceLocation DRAGON_FRUIT = new ResourceLocation("atmospheric", "textures/block/dragon_fruit.png");
    private static final ResourceLocation DRAGON_FRUIT_FLOWERING = new ResourceLocation("atmospheric", "textures/block/flowering_dragon_fruit.png");
    private static final ResourceLocation ENDER_DRAGON_FRUIT = new ResourceLocation("atmospheric", "textures/block/ender_dragon_fruit.png");
    private static final ResourceLocation ENDER_DRAGON_FRUIT_FLOWERING = new ResourceLocation("atmospheric", "textures/block/flowering_ender_dragon_fruit.png");
    private final DragonFruitModel<T> model;
    protected final RenderLayer<T, DragonFruitModel<T>> layer = new FloweringDragonFruitLayer(this);

    public DragonFruitRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new DragonFruitModel(context.m_174023_(AtmosphericModelLayers.DRAGON_FRUIT));
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - entity.m_146908_()));
        this.getModel().setupAnim(entity, partialTicks, 0.0f, (float)((DragonFruit)((Object)entity)).f_19797_ + partialTicks, 0.0f, 0.0f);
        poseStack.m_85849_();
        VertexConsumer vertexConsumer = buffer.m_6299_(this.model.m_103119_(this.getTextureLocation(entity)));
        this.getModel().m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        this.layer.m_6494_(poseStack, buffer, packedLight, entity, 0.0f, 0.0f, partialTicks, 0.0f, 0.0f, 0.0f);
        super.m_7392_(entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public DragonFruitModel<T> getModel() {
        return this.model;
    }

    public ResourceLocation getTextureLocation(T fruit) {
        return ((DragonFruit)((Object)fruit)).isEnder() ? (((DragonFruit)((Object)fruit)).isFlowering() ? ENDER_DRAGON_FRUIT_FLOWERING : ENDER_DRAGON_FRUIT) : (((DragonFruit)((Object)fruit)).isFlowering() ? DRAGON_FRUIT_FLOWERING : DRAGON_FRUIT);
    }
}

