/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.art_of_forging.effects;

import net.acetheeldritchking.art_of_forging.effects.gui.EffectGuiStats;
import net.acetheeldritchking.art_of_forging.effects.potion.PotionEffects;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import se.mickelus.tetra.blocks.workbench.gui.WorkbenchStatsGui;
import se.mickelus.tetra.gui.stats.StatsHelper;
import se.mickelus.tetra.gui.stats.bar.GuiStatBar;
import se.mickelus.tetra.gui.stats.bar.GuiStatBase;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;
import se.mickelus.tetra.gui.stats.getter.ITooltipGetter;
import se.mickelus.tetra.gui.stats.getter.LabelGetterBasic;
import se.mickelus.tetra.gui.stats.getter.StatFormat;
import se.mickelus.tetra.gui.stats.getter.StatGetterEffectEfficiency;
import se.mickelus.tetra.gui.stats.getter.StatGetterEffectLevel;
import se.mickelus.tetra.gui.stats.getter.TooltipGetterMultiValue;
import se.mickelus.tetra.items.modular.ModularItem;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloStatsGui;

public class DisorientingEffect {
    @OnlyIn(value=Dist.CLIENT)
    public static void init() {
        StatGetterEffectLevel effectStatGetter = new StatGetterEffectLevel(EffectGuiStats.disorientingEffect, 1.0);
        GuiStatBar effectBar = new GuiStatBar(0, 0, 59, "art_of_forging.effect.disorienting.name", 0.0, 30.0, false, (IStatGetter)effectStatGetter, LabelGetterBasic.integerLabel, (ITooltipGetter)new TooltipGetterMultiValue("art_of_forging.effect.disorienting.tooltip", StatsHelper.withStats((IStatGetter[])new IStatGetter[]{effectStatGetter, new StatGetterEffectEfficiency(EffectGuiStats.disorientingEffect, 1.0)}), StatsHelper.withFormat((StatFormat[])new StatFormat[]{StatFormat.noDecimal, StatFormat.noDecimal})));
        WorkbenchStatsGui.addBar((GuiStatBase)effectBar);
        HoloStatsGui.addBar((GuiStatBase)effectBar);
    }

    @SubscribeEvent
    public void onLivingAttackEvent(LivingDamageEvent event) {
        LivingEntity attacker;
        ItemStack heldStack;
        Item item;
        LivingEntity target = event.getEntity();
        Entity attackingEntity = event.getSource().m_7639_();
        if (attackingEntity instanceof LivingEntity && (item = (heldStack = (attacker = (LivingEntity)attackingEntity).m_21205_()).m_41720_()) instanceof ModularItem) {
            ModularItem item2 = (ModularItem)item;
            int level = item2.getEffectLevel(heldStack, EffectGuiStats.disorientingEffect);
            int eff = (int)item2.getEffectEfficiency(heldStack, EffectGuiStats.disorientingEffect);
            if (level > 0 && !MobType.f_21641_.equals(target.m_6336_()) && (float)eff > target.m_217043_().m_188501_() * 100.0f) {
                if (target instanceof Player) {
                    this.applyEffects(level, 5, target);
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 5, level, true, true, true));
                } else if (target instanceof Creeper) {
                    Creeper creeper = (Creeper)target;
                    this.applyEffects(level, 5, (LivingEntity)creeper);
                    creeper.m_7292_(new MobEffectInstance((MobEffect)PotionEffects.DEFUSE_CREEPER.get(), 5, 2, false, false, false));
                } else {
                    this.applyEffects(level, 5, target);
                }
            }
        }
    }

    private void applyEffects(int level, int duration, LivingEntity target) {
        target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, duration * 20, level - 1, true, true, true));
        target.m_7292_(new MobEffectInstance(MobEffects.f_19613_, duration * 20, level - 1, true, true, true));
    }
}

