/*
 * Decompiled with CFR 0.152.
 */
package com.min01.archaeology.block;

import com.min01.archaeology.blockentity.BrushableBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrushableBlock
extends BaseEntityBlock
implements Fallable {
    public static final IntegerProperty DUSTED = IntegerProperty.m_61631_((String)"dusted", (int)0, (int)3);
    public static final int TICK_DELAY = 2;
    private final Block turnsInto;
    private final SoundEvent brushSound;
    private final SoundEvent brushCompletedSound;

    public BrushableBlock(Block turnsInto, BlockBehaviour.Properties properties, SoundEvent brushSound, SoundEvent brushCompletedSound) {
        super(properties);
        this.turnsInto = turnsInto;
        this.brushSound = brushSound;
        this.brushCompletedSound = brushCompletedSound;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DUSTED, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DUSTED});
    }

    @NotNull
    public PushReaction m_5537_(@NotNull BlockState state) {
        return PushReaction.DESTROY;
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_6807_(@NotNull BlockState state, Level level, @NotNull BlockPos position, @NotNull BlockState oldState, boolean isMoving) {
        level.m_186460_(position, (Block)this, 2);
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, LevelAccessor level, @NotNull BlockPos currentPosition, @NotNull BlockPos neighborPosition) {
        level.m_186460_(currentPosition, (Block)this, 2);
        return super.m_7417_(state, direction, neighborState, level, currentPosition, neighborPosition);
    }

    public void m_213897_(@NotNull BlockState state, ServerLevel serverLevel, @NotNull BlockPos position, @NotNull RandomSource random) {
        BlockEntity blockEntity = serverLevel.m_7702_(position);
        if (blockEntity instanceof BrushableBlockEntity) {
            BrushableBlockEntity brushableblockentity = (BrushableBlockEntity)blockEntity;
            brushableblockentity.checkReset();
        }
        if (FallingBlock.m_53241_((BlockState)serverLevel.m_8055_(position.m_7495_())) && position.m_123342_() >= serverLevel.m_141937_()) {
            FallingBlockEntity fallingblockentity = FallingBlockEntity.m_201971_((Level)serverLevel, (BlockPos)position, (BlockState)state);
            fallingblockentity.f_31943_ = false;
        }
    }

    public void m_142525_(Level level, @NotNull BlockPos position, FallingBlockEntity fallingBlock) {
        Vec3 center = fallingBlock.m_20191_().m_82399_();
        level.m_46796_(2001, new BlockPos(center), Block.m_49956_((BlockState)fallingBlock.m_31980_()));
        level.m_220400_((Entity)fallingBlock, GameEvent.f_157794_, center);
    }

    public void m_214162_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos position, RandomSource random) {
        if (random.m_188503_(16) == 0 && FallingBlock.m_53241_((BlockState)level.m_8055_(position.m_7495_()))) {
            double x = (double)position.m_123341_() + random.m_188500_();
            double y = (double)position.m_123342_() - 0.05;
            double z = (double)position.m_123343_() + random.m_188500_();
            level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, state), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos position, @NotNull BlockState state) {
        return new BrushableBlockEntity(position, state);
    }

    public Block getTurnsInto() {
        return this.turnsInto;
    }

    public SoundEvent getBrushSound() {
        return this.brushSound;
    }

    public SoundEvent getBrushCompletedSound() {
        return this.brushCompletedSound;
    }
}

