/*
 * Decompiled with CFR 0.152.
 */
package com.min01.archaeology.blockentity;

import com.min01.archaeology.block.BrushableBlock;
import com.min01.archaeology.blockentity.BrushableBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class BrushableBlockRenderer
implements BlockEntityRenderer<BrushableBlockEntity> {
    private final ItemRenderer itemRenderer;

    public BrushableBlockRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.m_234447_();
    }

    public void render(BrushableBlockEntity brushableBlock, float partialTick, @NotNull PoseStack pose, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay) {
        ItemStack stack;
        Direction direction;
        int dusted;
        if (brushableBlock.m_58904_() != null && (dusted = ((Integer)brushableBlock.m_58900_().m_61143_((Property)BrushableBlock.DUSTED)).intValue()) > 0 && (direction = brushableBlock.getHitDirection()) != null && !(stack = brushableBlock.getItem()).m_41619_()) {
            pose.m_85836_();
            pose.m_85837_(0.0, 0.5, 0.0);
            float[] translations = this.translations(direction, dusted);
            pose.m_85837_((double)translations[0], (double)translations[1], (double)translations[2]);
            pose.m_85845_(Vector3f.f_122225_.m_122240_(75.0f));
            boolean flag = direction == Direction.EAST || direction == Direction.WEST;
            pose.m_85845_(Vector3f.f_122225_.m_122240_((float)((flag ? 90 : 0) + 11)));
            pose.m_85841_(0.5f, 0.5f, 0.5f);
            int combinedLight = LevelRenderer.m_109537_((BlockAndTintGetter)brushableBlock.m_58904_(), (BlockState)brushableBlock.m_58900_(), (BlockPos)brushableBlock.m_58899_().m_121945_(direction));
            this.itemRenderer.m_174242_(null, stack, ItemTransforms.TransformType.FIXED, false, pose, buffer, brushableBlock.m_58904_(), combinedLight, OverlayTexture.f_118083_, 0);
            pose.m_85849_();
        }
    }

    private float[] translations(Direction direction, int dusted) {
        float[] translations = new float[]{0.5f, 0.0f, 0.5f};
        float f = (float)dusted / 10.0f * 0.75f;
        switch (direction) {
            case EAST: {
                translations[0] = 0.73f + f;
                break;
            }
            case WEST: {
                translations[0] = 0.25f - f;
                break;
            }
            case UP: {
                translations[1] = 0.25f + f;
                break;
            }
            case DOWN: {
                translations[1] = -0.23f - f;
                break;
            }
            case NORTH: {
                translations[2] = 0.25f - f;
                break;
            }
            case SOUTH: {
                translations[2] = 0.73f + f;
            }
        }
        return translations;
    }
}

