/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.mixin;

import com.infamous.all_bark_all_bite.common.entity.wolf.WolfHooks;
import com.infamous.all_bark_all_bite.common.util.ai.GenericAi;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Mob.class})
public abstract class MobMixin
extends LivingEntity {
    protected MobMixin(EntityType<? extends LivingEntity> type, Level level) {
        super(type, level);
    }

    @Inject(method={"wantsToPickUp"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleWantsToPickUp(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        if (this.m_6095_() == EntityType.f_20499_) {
            cir.setReturnValue((Object)WolfHooks.wolfWantsToPickUp(stack, (Mob)this));
        }
    }

    @Inject(method={"canPickUpLoot"}, at={@At(value="RETURN")}, cancellable=true)
    private void handleCanPickUpLoot(CallbackInfoReturnable<Boolean> cir) {
        if (this.m_6095_() == EntityType.f_20499_) {
            cir.setReturnValue((Object)(!GenericAi.isOnPickupCooldown(this) ? 1 : 0));
        }
    }

    @Inject(method={"canTakeItem"}, at={@At(value="RETURN")}, cancellable=true)
    private void handleCanTakeItem(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        if (this.m_6095_() == EntityType.f_20499_) {
            cir.setReturnValue((Object)WolfHooks.canWolfTakeItem(stack, (Mob)this, (Boolean)cir.getReturnValue()));
        }
    }

    @Inject(method={"canHoldItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleCanHoldItem(ItemStack itemStack, CallbackInfoReturnable<Boolean> cir) {
        Mob mob;
        if (this.m_6095_() == EntityType.f_20499_ && (mob = (Mob)this) instanceof Animal) {
            Animal animal = (Animal)mob;
            cir.setReturnValue((Object)WolfHooks.canWolfHoldItem(itemStack, animal));
        }
    }

    @Inject(method={"pickUpItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void handlePickUpItem(ItemEntity itemEntity, CallbackInfo ci) {
        if (this.m_6095_() == EntityType.f_20499_) {
            ci.cancel();
            WolfHooks.onWolfPickUpItem((Mob)this, itemEntity);
        }
    }
}

