/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.data;

import com.infamous.all_bark_all_bite.common.registry.ABABSoundEvents;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.SoundDefinition;
import net.minecraftforge.common.data.SoundDefinitionsProvider;
import org.jetbrains.annotations.NotNull;

public class ABABSoundDefinitionsProvider
extends SoundDefinitionsProvider {
    private static final ResourceLocation WHISTLE_LOCATION = new ResourceLocation("all_bark_all_bite", "whistle");
    private static final double SEMITONE_MULTIPLIER = 1.06;

    public ABABSoundDefinitionsProvider(DataGenerator generator, ExistingFileHelper helper) {
        super(generator, "all_bark_all_bite", helper);
    }

    public static ABABSoundDefinitionsProvider create(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        return new ABABSoundDefinitionsProvider(generator, existingFileHelper);
    }

    public void registerSounds() {
        this.add((SoundEvent)ABABSoundEvents.ATTACK_WHISTLE.get(), ABABSoundDefinitionsProvider.defineWhistle(-3));
        this.add((SoundEvent)ABABSoundEvents.COME_WHISTLE.get(), ABABSoundDefinitionsProvider.defineWhistle(-2));
        this.add((SoundEvent)ABABSoundEvents.FOLLOW_WHISTLE.get(), ABABSoundDefinitionsProvider.defineWhistle(-1));
        this.add((SoundEvent)ABABSoundEvents.FREE_WHISTLE.get(), ABABSoundDefinitionsProvider.defineWhistle(0));
        this.add((SoundEvent)ABABSoundEvents.GO_WHISTLE.get(), ABABSoundDefinitionsProvider.defineWhistle(1));
        this.add((SoundEvent)ABABSoundEvents.HEEL_WHISTLE.get(), ABABSoundDefinitionsProvider.defineWhistle(2));
        this.add((SoundEvent)ABABSoundEvents.SIT_WHISTLE.get(), ABABSoundDefinitionsProvider.defineWhistle(3));
    }

    @NotNull
    private static SoundDefinition defineWhistle(int semitones) {
        return SoundDefinition.definition().with(SoundDefinition.Sound.sound((ResourceLocation)WHISTLE_LOCATION, (SoundDefinition.SoundType)SoundDefinition.SoundType.SOUND).volume(0.5).pitch(ABABSoundDefinitionsProvider.shiftPitch(semitones)));
    }

    private static double shiftPitch(int octaves) {
        return Math.pow(1.06, octaves);
    }
}

