/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.data;

import com.infamous.all_bark_all_bite.common.item.AdjustableInstrumentItem;
import com.infamous.all_bark_all_bite.common.item.PetWhistleItem;
import com.infamous.all_bark_all_bite.common.registry.ABABEntityTypes;
import com.infamous.all_bark_all_bite.common.registry.ABABInstruments;
import com.infamous.all_bark_all_bite.common.registry.ABABItems;
import com.infamous.all_bark_all_bite.common.util.InstrumentUtil;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.RegistryObject;

public class ABABLangProvider
extends LanguageProvider {
    public ABABLangProvider(DataGenerator gen) {
        super(gen, "all_bark_all_bite", "en_us");
    }

    public static ABABLangProvider create(DataGenerator gen) {
        return new ABABLangProvider(gen);
    }

    protected void addTranslations() {
        this.add((EntityType)ABABEntityTypes.DOG.get(), "Dog");
        this.add((Item)ABABItems.DOG_SPAWN_EGG.get(), "Dog Spawn Egg");
        this.add((EntityType)ABABEntityTypes.ILLAGER_HOUND.get(), "Scavenger");
        this.add((Item)ABABItems.ILLAGER_HOUND_SPAWN_EGG.get(), "Scavenger Spawn Egg");
        this.add((EntityType)ABABEntityTypes.HOUNDMASTER.get(), "Houndmaster");
        this.add((Item)ABABItems.HOUNDMASTER_SPAWN_EGG.get(), "Houndmaster Spawn Egg");
        this.add((Item)ABABItems.WHISTLE.get(), "Whistle");
        this.addWhistleWithDescription(ABABInstruments.ATTACK_WHISTLE, "Attack", "Pets will attack the targeted entity.");
        this.addWhistleWithDescription(ABABInstruments.COME_WHISTLE, "Come", "Pets will come to your position.");
        this.addWhistleWithDescription(ABABInstruments.FOLLOW_WHISTLE, "Follow", "Pets will follow you loosely.");
        this.addWhistleWithDescription(ABABInstruments.FREE_WHISTLE, "Free", "Pets will wander freely.");
        this.addWhistleWithDescription(ABABInstruments.GO_WHISTLE, "Go", "Pets will go to the targeted position.");
        this.addWhistleWithDescription(ABABInstruments.HEEL_WHISTLE, "Heel", "Pets will follow you closely.");
        this.addWhistleWithDescription(ABABInstruments.SIT_WHISTLE, "Sit", "Pets will sit down.");
        this.add(AdjustableInstrumentItem.SECONDARY_USE_TOOLTIP, "Sneak & Use to Adjust");
        this.add(PetWhistleItem.getBoundToTooltipId(), "Bound to: %s");
        this.add(PetWhistleItem.CONTAINER_TITLE_ID, "Whistle");
        this.add(PetWhistleItem.UNBIND_BUTTON_LABEL_ID, "Unbind");
    }

    private void addWhistleWithDescription(RegistryObject<Instrument> whistle, String id, String description) {
        ResourceLocation location = whistle.getId();
        this.add(InstrumentUtil.makeInstrumentDescriptionId(location), id);
        this.add(InstrumentUtil.makeInstrumentDescription(location), description);
    }
}

