/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.data;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public class ABABBuiltInLootTables {
    private static final Set<ResourceLocation> LOCATIONS = Sets.newHashSet();
    private static final Set<ResourceLocation> IMMUTABLE_LOCATIONS = Collections.unmodifiableSet(LOCATIONS);
    public static final ResourceLocation DOG_DIGGING = ABABBuiltInLootTables.register("gameplay/dog_digging");
    public static final ResourceLocation KENNEL_ILLAGER_HOUND = ABABBuiltInLootTables.register(String.format("chests/kennel/%s", "scavenger"));
    public static final ResourceLocation KENNEL_HOUNDMASTER = ABABBuiltInLootTables.register("chests/kennel/houndmaster");

    private static ResourceLocation register(String path) {
        return ABABBuiltInLootTables.register(new ResourceLocation("all_bark_all_bite", path));
    }

    private static ResourceLocation register(ResourceLocation location) {
        if (LOCATIONS.add(location)) {
            return location;
        }
        throw new IllegalArgumentException(location + " is already a registered built-in loot table");
    }

    public static Set<ResourceLocation> all() {
        return IMMUTABLE_LOCATIONS;
    }
}

