/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.util.ai;

import com.infamous.all_bark_all_bite.common.logic.entity_manager.MultiEntityManager;
import com.infamous.all_bark_all_bite.common.logic.entity_manager.SingleEntityManager;
import com.infamous.all_bark_all_bite.common.registry.ABABMemoryModuleTypes;
import com.infamous.all_bark_all_bite.common.util.ai.AiUtil;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraftforge.event.ForgeEventFactory;

public class PackAi {
    public static boolean hasFollowers(LivingEntity mob) {
        return PackAi.getPackSize(mob) > 0;
    }

    public static int getPackSize(LivingEntity mob) {
        return PackAi.getFollowerManager(mob).get().size();
    }

    public static Optional<MultiEntityManager> getFollowerManager(LivingEntity mob) {
        Brain brain = mob.m_6274_();
        if (!brain.m_21874_((MemoryModuleType)ABABMemoryModuleTypes.FOLLOWERS.get())) {
            brain.m_21879_((MemoryModuleType)ABABMemoryModuleTypes.FOLLOWERS.get(), (Object)new MultiEntityManager(Collections.emptyList()));
        }
        return brain.m_21952_((MemoryModuleType)ABABMemoryModuleTypes.FOLLOWERS.get());
    }

    public static Optional<SingleEntityManager> getLeaderManager(LivingEntity mob) {
        Brain brain = mob.m_6274_();
        if (!brain.m_21874_((MemoryModuleType)ABABMemoryModuleTypes.LEADER.get())) {
            brain.m_21879_((MemoryModuleType)ABABMemoryModuleTypes.LEADER.get(), (Object)new SingleEntityManager());
        }
        return brain.m_21952_((MemoryModuleType)ABABMemoryModuleTypes.LEADER.get());
    }

    public static Optional<UUID> getLeaderUUID(LivingEntity mob) {
        return PackAi.getLeaderManager(mob).get().getEntityUUID();
    }

    public static Optional<LivingEntity> getLeader(LivingEntity mob) {
        return PackAi.getLeaderManager(mob).get().getEntity().filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast);
    }

    public static void stopFollowing(LivingEntity mob, LivingEntity leader) {
        PackAi.removeFollower(leader, mob);
        PackAi.eraseLeader(mob);
    }

    private static void removeFollower(LivingEntity leader, LivingEntity mob) {
        PackAi.getFollowerManager(leader).get().remove((Entity)mob);
    }

    public static void eraseLeader(LivingEntity mob) {
        PackAi.getLeaderManager(mob).get().erase();
    }

    public static boolean isFollower(LivingEntity mob) {
        return PackAi.getLeaderManager(mob).get().hasEntity();
    }

    public static void startFollowing(LivingEntity mob, LivingEntity leader) {
        PackAi.setLeader(mob, leader);
        PackAi.getFollowerManager(leader).get().add((Entity)mob);
    }

    private static void setLeader(LivingEntity mob, LivingEntity leader) {
        PackAi.getLeaderManager(mob).get().set((Entity)leader);
    }

    public static boolean canFollow(LivingEntity mob, LivingEntity other) {
        return AiUtil.isSameTypeAndFriendly(mob, other) && (PackAi.isJoinableLeader(other) || PackAi.isLoner(other));
    }

    public static boolean isJoinableLeader(LivingEntity mob) {
        return PackAi.hasFollowers(mob) && PackAi.getPackSize(mob) < PackAi.getMaxPackSize(mob);
    }

    public static boolean canLead(LivingEntity leader, LivingEntity other) {
        return AiUtil.isSameTypeAndFriendly(leader, other) && PackAi.isLoner(other);
    }

    public static void pathToLeader(LivingEntity mob, float speedModifier, int closeEnough) {
        PackAi.getLeader(mob).ifPresent(leader -> AiUtil.setWalkAndLookTargetMemories(mob, (Entity)leader, speedModifier, closeEnough));
    }

    public static int getMaxPackSize(LivingEntity wolf) {
        int n;
        if (wolf instanceof Mob) {
            Mob mob = (Mob)wolf;
            n = ForgeEventFactory.getMaxSpawnPackSize((Mob)mob);
        } else {
            n = 1;
        }
        return n;
    }

    public static boolean canAddToFollowers(LivingEntity leader, LivingEntity other) {
        return PackAi.isJoinableLeader(leader) && PackAi.canLead(leader, other);
    }

    public static boolean isLoner(LivingEntity mob) {
        return !PackAi.isFollower(mob) && !PackAi.hasFollowers(mob);
    }
}

