/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.util.ai;

import com.infamous.all_bark_all_bite.common.util.ai.GenericAi;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;

public class AngerAi {
    public static Optional<LivingEntity> getAngerTarget(LivingEntity livingEntity) {
        return BehaviorUtils.m_22610_((LivingEntity)livingEntity, (MemoryModuleType)MemoryModuleType.f_26334_);
    }

    public static int getAngryAtTime(LivingEntity livingEntity) {
        return (int)livingEntity.m_6274_().m_147341_(MemoryModuleType.f_26334_);
    }

    public static void maybeRetaliate(LivingEntity victim, List<? extends LivingEntity> toAlert, LivingEntity attacker, UniformInt angerTime, double tooFar) {
        if (Sensor.m_182377_((LivingEntity)victim, (LivingEntity)attacker) && !BehaviorUtils.m_22598_((LivingEntity)victim, (LivingEntity)attacker, (double)tooFar)) {
            int angerTimeInTicks = angerTime.m_214085_(victim.m_217043_());
            if (attacker.m_6095_() == EntityType.f_20532_ && victim.f_19853_.m_46469_().m_46207_(GameRules.f_46127_)) {
                AngerAi.setAngerTargetToNearestTargetablePlayerIfFound(victim, attacker, angerTimeInTicks);
                AngerAi.broadcastUniversalAnger(toAlert, angerTime);
            } else {
                AngerAi.setAngerTarget(victim, attacker, angerTimeInTicks);
                AngerAi.broadcastAngerTarget(toAlert, attacker, angerTime);
            }
        }
    }

    private static void setAngerTargetToNearestTargetablePlayerIfFound(LivingEntity livingEntity, LivingEntity target, int angerTimeInTicks) {
        Optional<Player> optional = GenericAi.getNearestVisibleTargetablePlayer(livingEntity);
        if (optional.isPresent()) {
            AngerAi.setAngerTarget(livingEntity, (LivingEntity)optional.get(), angerTimeInTicks);
        } else {
            AngerAi.setAngerTarget(livingEntity, target, angerTimeInTicks);
        }
    }

    public static void setAngerTarget(LivingEntity livingEntity, LivingEntity target, int angerTimeInTicks) {
        if (Sensor.m_182377_((LivingEntity)livingEntity, (LivingEntity)target)) {
            Brain brain = livingEntity.m_6274_();
            brain.m_21936_(MemoryModuleType.f_26326_);
            brain.m_21882_(MemoryModuleType.f_26334_, (Object)target.m_20148_(), (long)angerTimeInTicks);
            if (livingEntity instanceof NeutralMob) {
                NeutralMob neutralMob = (NeutralMob)livingEntity;
                neutralMob.m_6710_(target);
                neutralMob.m_6925_(target.m_20148_());
                neutralMob.m_7870_(angerTimeInTicks);
            }
            if (target.m_6095_() == EntityType.f_20532_ && livingEntity.f_19853_.m_46469_().m_46207_(GameRules.f_46127_)) {
                brain.m_21882_(MemoryModuleType.f_26335_, (Object)true, (long)angerTimeInTicks);
            }
        }
    }

    private static void broadcastUniversalAnger(List<? extends LivingEntity> alertables, UniformInt angerTime) {
        alertables.forEach(adult -> GenericAi.getNearestVisibleTargetablePlayer(adult).ifPresent(p -> AngerAi.setAngerTarget(adult, (LivingEntity)p, angerTime.m_214085_(p.m_217043_()))));
    }

    public static void broadcastAngerTarget(List<? extends LivingEntity> alertables, LivingEntity target, UniformInt angerTime) {
        alertables.forEach(alertable -> AngerAi.setAngerTargetIfCloserThanCurrent(alertable, target, angerTime.m_214085_(alertable.m_217043_())));
    }

    public static void setAngerTargetIfCloserThanCurrent(LivingEntity mob, LivingEntity target, int angerTimeInTicks) {
        Optional<LivingEntity> optional = AngerAi.getAngerTarget(mob);
        LivingEntity livingentity = BehaviorUtils.m_22625_((LivingEntity)mob, optional, (LivingEntity)target);
        if (optional.isEmpty() || optional.get() != livingentity) {
            AngerAi.setAngerTarget(mob, livingentity, angerTimeInTicks);
        }
    }

    public static boolean hasAngryAt(LivingEntity entity) {
        return entity.m_6274_().m_21874_(MemoryModuleType.f_26334_);
    }
}

