/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.util;

import com.google.common.collect.Maps;
import com.infamous.all_bark_all_bite.AllBarkAllBite;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.jetbrains.annotations.Nullable;

public class ReflectionUtil {
    private static final Map<String, Field> CACHED_FIELDS = Maps.newHashMap();
    private static final Map<String, Method> CACHED_METHODS = Maps.newHashMap();

    @Nullable
    public static <T> T callMethod(String methodName, Object obj, Object ... args) {
        return ReflectionUtil.callMethod(methodName, obj.getClass(), obj, args);
    }

    @Nullable
    public static <T> T callMethod(String methodName, Class<?> targetClass, Object obj, Object ... args) {
        Method method = CACHED_METHODS.computeIfAbsent(methodName, k -> {
            Class[] argClasses = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argClasses[i] = args[i].getClass();
            }
            return ObfuscationReflectionHelper.findMethod((Class)targetClass, (String)methodName, (Class[])argClasses);
        });
        try {
            return (T)method.invoke(obj, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            AllBarkAllBite.LOGGER.error("Reflection error for method name {} called on {} given {}", new Object[]{methodName, obj, Arrays.toString(args)});
            return null;
        }
    }

    public static void setField(String fieldName, Class<?> targetClass, Object obj, Object value) {
        Field field = CACHED_FIELDS.computeIfAbsent(fieldName, k -> ObfuscationReflectionHelper.findField((Class)targetClass, (String)fieldName));
        try {
            field.set(obj, value);
        }
        catch (IllegalAccessException e) {
            AllBarkAllBite.LOGGER.error("Reflection error for field name {} modified on {} given {}", new Object[]{fieldName, obj, value});
        }
    }

    @Nullable
    public static <T> T getField(String fieldName, Class<?> targetClass, Object obj) {
        Field field = CACHED_FIELDS.computeIfAbsent(fieldName, k -> ObfuscationReflectionHelper.findField((Class)targetClass, (String)fieldName));
        try {
            return (T)field.get(obj);
        }
        catch (IllegalAccessException e) {
            AllBarkAllBite.LOGGER.error("Reflection error for field named {} retrieved on {}", (Object)fieldName, obj);
            return null;
        }
    }
}

