/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.util;

import com.google.common.collect.Iterables;
import com.infamous.all_bark_all_bite.AllBarkAllBite;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class MiscUtil {
    public static <T> T getRandomObject(Collection<T> from, RandomSource randomSource) {
        int index = randomSource.m_188503_(from.size());
        return (T)Iterables.get(from, (int)index);
    }

    public static ItemStack removeOneItemFromItemEntity(ItemEntity itemEntity) {
        ItemStack stack = itemEntity.m_32055_();
        ItemStack singleton = stack.m_41620_(1);
        if (stack.m_41619_()) {
            itemEntity.m_146870_();
        } else {
            itemEntity.m_32045_(stack);
        }
        return singleton;
    }

    public static void addParticlesAroundSelf(LivingEntity livingEntity, ParticleOptions particleOptions, int numParticles, double speedMultiplier, double widthScale, double yOffset) {
        for (int i = 0; i < numParticles; ++i) {
            RandomSource random = livingEntity.m_217043_();
            double xSpeed = random.m_188583_() * speedMultiplier;
            double ySpeed = random.m_188583_() * speedMultiplier;
            double zSpeed = random.m_188583_() * speedMultiplier;
            livingEntity.f_19853_.m_7106_(particleOptions, livingEntity.m_20208_(widthScale), livingEntity.m_20187_() + yOffset, livingEntity.m_20262_(widthScale), xSpeed, ySpeed, zSpeed);
        }
    }

    public static void addParticlesAroundSelf(LivingEntity livingEntity, ParticleOptions particleOptions, int numParticles, double xSpeed, double ySpeed, double zSpeed, double widthScale, double yOffset) {
        for (int i = 0; i < numParticles; ++i) {
            livingEntity.f_19853_.m_7106_(particleOptions, livingEntity.m_20208_(widthScale), livingEntity.m_20187_() + yOffset, livingEntity.m_20262_(widthScale), xSpeed, ySpeed, zSpeed);
        }
    }

    public static void sendParticlesAroundSelf(ServerLevel serverLevel, LivingEntity livingEntity, ParticleOptions particleOptions, double yOffset, int numParticles, double speedMultiplier) {
        serverLevel.m_8767_(particleOptions, livingEntity.m_20185_(), livingEntity.m_20186_() + yOffset, livingEntity.m_20189_(), numParticles, 0.0, 0.0, 0.0, speedMultiplier);
    }

    public static boolean oneInChance(RandomSource randomSource, int chance) {
        return randomSource.m_188503_(chance) == 0;
    }

    public static <T extends Entity> Optional<T> createEntity(@NotNull EntityType<T> entityType, ServerLevel level) {
        Entity entity = entityType.m_20615_((Level)level);
        if (entity == null) {
            AllBarkAllBite.LOGGER.warn("Unable to create a new {} in level {}!", (Object)EntityType.m_20613_(entityType), (Object)level);
            return Optional.empty();
        }
        return Optional.of(entity);
    }

    public static int seconds(double seconds) {
        return (int)(seconds * 20.0);
    }

    public static void tellServer(ServerLevel serverLevel, Runnable runnable) {
        MinecraftServer server = serverLevel.m_7654_();
        server.m_6937_((Runnable)new TickTask(server.m_129921_(), runnable));
    }

    public static String getPngPath(String path) {
        return String.format("%s.png", path);
    }

    public static String getEntityTexturePath(String entityPath, String texturePath) {
        return String.format("textures/entity/%s", MiscUtil.getPngPath(String.format("%s/%s", entityPath, texturePath)));
    }
}

