/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.util;

import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.ItemStack;

public class InstrumentUtil {
    public static final String INSTRUMENT_TAG = "instrument";

    public static Optional<Holder<Instrument>> getInstrumentHolder(ResourceLocation location) {
        return Registry.f_235738_.m_203636_(ResourceKey.m_135785_((ResourceKey)Registry.f_235737_, (ResourceLocation)location));
    }

    public static void setSoundVariantId(ItemStack stack, Holder<Instrument> instrument) {
        InstrumentUtil.setSoundVariantId(stack, InstrumentUtil.getInstrumentLocation(instrument));
    }

    public static ResourceLocation getInstrumentLocation(Holder<Instrument> instrument) {
        return ((ResourceKey)instrument.m_203543_().orElseThrow(() -> new IllegalStateException("Invalid instrument"))).m_135782_();
    }

    public static void setSoundVariantId(ItemStack itemStack, ResourceLocation location) {
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128359_(INSTRUMENT_TAG, location.toString());
    }

    public static MutableComponent getInstrumentTooltip(Holder<Instrument> instrument) {
        return Component.m_237115_((String)InstrumentUtil.makeInstrumentDescriptionId(InstrumentUtil.getInstrumentLocation(instrument)));
    }

    public static MutableComponent getInstrumentDescriptionTooltip(Holder<Instrument> instrument) {
        return Component.m_237115_((String)InstrumentUtil.makeInstrumentDescription(InstrumentUtil.getInstrumentLocation(instrument)));
    }

    public static String makeInstrumentDescriptionId(ResourceLocation location) {
        return Util.m_137492_((String)INSTRUMENT_TAG, (ResourceLocation)location);
    }

    public static String makeInstrumentDescription(ResourceLocation location) {
        return InstrumentUtil.makeInstrumentDescriptionId(location) + ".description";
    }
}

