/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.sensor.vibration;

import com.google.common.collect.ImmutableSet;
import com.infamous.all_bark_all_bite.common.sensor.vibration.EntityVibrationListener;
import com.infamous.all_bark_all_bite.common.sensor.vibration.EntityVibrationListenerConfig;
import com.infamous.all_bark_all_bite.common.util.MiscUtil;
import com.infamous.all_bark_all_bite.common.util.ai.BrainUtil;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class VibrationSensor<E extends LivingEntity, VLC extends EntityVibrationListenerConfig<E>>
extends Sensor<E> {
    protected final EntityVibrationListenerConfig.Constructor<E, VLC> listenerConfigFactory;
    protected final MemoryModuleType<EntityVibrationListener<E, VLC>> listenerMemory;
    private DynamicGameEventListener<EntityVibrationListener<E, VLC>> dynamicVibrationListener;
    private final int defaultListenerRange;

    public VibrationSensor(EntityVibrationListenerConfig.Constructor<E, VLC> listenerConfigFactory, MemoryModuleType<EntityVibrationListener<E, VLC>> listenerMemory, int defaultListenerRange) {
        super(1);
        this.listenerConfigFactory = listenerConfigFactory;
        this.listenerMemory = listenerMemory;
        this.defaultListenerRange = defaultListenerRange;
    }

    protected void m_5578_(ServerLevel level, E mob) {
        ((EntityVibrationListener)this.getDynamicVibrationListener(mob).m_223616_()).m_157898_((Level)level);
    }

    protected DynamicGameEventListener<EntityVibrationListener<E, VLC>> getDynamicVibrationListener(E mob) {
        if (this.dynamicVibrationListener == null) {
            EntityVibrationListener<E, VLC> listener = this.getListener(mob);
            this.dynamicVibrationListener = new DynamicGameEventListener(listener);
        }
        return this.dynamicVibrationListener;
    }

    private DynamicGameEventListener<?> getDynamicVibrationListenerUnchecked(LivingEntity le) {
        return this.getDynamicVibrationListener(le);
    }

    protected EntityVibrationListener<E, VLC> getListener(E mob) {
        Brain brain = mob.m_6274_();
        EntityVibrationListener listener = brain.m_21952_(this.listenerMemory).orElseGet(() -> this.createDefaultListener(mob));
        ((EntityVibrationListenerConfig)listener.getConfig()).setEntity(mob);
        brain.m_21879_(this.listenerMemory, (Object)listener);
        return listener;
    }

    protected EntityVibrationListener<E, VLC> createDefaultListener(E mob) {
        EntityPositionSource positionSource = new EntityPositionSource(mob, mob.m_20192_());
        VLC listenerConfig = this.listenerConfigFactory.create();
        return new EntityVibrationListener((PositionSource)positionSource, this.getDefaultListenerRange(), listenerConfig, null, 0.0f, 0);
    }

    protected int getDefaultListenerRange() {
        return this.defaultListenerRange;
    }

    public Set<MemoryModuleType<?>> m_7163_() {
        return ImmutableSet.of(this.listenerMemory);
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="all_bark_all_bite")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        static void onEntityJoinLevel(EntityJoinLevelEvent event) {
            Level level = event.getLevel();
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            Entity entity = event.getEntity();
            MiscUtil.tellServer(serverLevel, () -> EventHandler.updateVibrationListener(entity, serverLevel, DynamicGameEventListener::m_223617_));
        }

        private static void updateVibrationListener(Entity entity, ServerLevel serverLevel, BiConsumer<DynamicGameEventListener<?>, ServerLevel> callback) {
            if (entity instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)entity;
                Brain brain = le.m_6274_();
                BrainUtil.getSensors(brain).values().forEach(sensor -> {
                    if (sensor instanceof VibrationSensor) {
                        VibrationSensor vibrationSensor = (VibrationSensor)((Object)sensor);
                        callback.accept(vibrationSensor.getDynamicVibrationListenerUnchecked(le), serverLevel);
                    }
                });
            }
        }

        @SubscribeEvent
        static void onEntitySectionChange(EntityEvent.EnteringSection event) {
            Level level = event.getEntity().m_9236_();
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            EventHandler.updateVibrationListener(event.getEntity(), serverLevel, DynamicGameEventListener::m_223641_);
        }

        @SubscribeEvent
        static void onEntityLeaveLevel(EntityLeaveLevelEvent event) {
            Level level = event.getLevel();
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            EventHandler.updateVibrationListener(event.getEntity(), serverLevel, DynamicGameEventListener::m_223634_);
        }
    }
}

