/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.sensor;

import com.google.common.collect.ImmutableSet;
import com.infamous.all_bark_all_bite.common.ABABTags;
import com.infamous.all_bark_all_bite.common.entity.SharedWolfAi;
import com.infamous.all_bark_all_bite.common.entity.wolf.WolfAi;
import com.infamous.all_bark_all_bite.common.registry.ABABMemoryModuleTypes;
import com.infamous.all_bark_all_bite.common.util.ai.AiUtil;
import com.infamous.all_bark_all_bite.config.ABABConfig;
import java.util.Optional;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;

public class WolfSpecificSensor
extends Sensor<Wolf> {
    public Set<MemoryModuleType<?>> m_7163_() {
        return ImmutableSet.of((Object)MemoryModuleType.f_148205_, (Object)((MemoryModuleType)ABABMemoryModuleTypes.NEAREST_VISIBLE_DISLIKED.get()), (Object)((MemoryModuleType)ABABMemoryModuleTypes.NEAREST_VISIBLE_HUNTABLE.get()), (Object)((MemoryModuleType)ABABMemoryModuleTypes.NEAREST_TARGETABLE_PLAYER_NOT_SNEAKING.get()), (Object)MemoryModuleType.f_148194_);
    }

    protected void doTick(ServerLevel level, Wolf wolf) {
        Brain brain = wolf.m_6274_();
        Optional<Object> nearestPlayerNotSneaking = Optional.empty();
        Optional<Object> nearestDisliked = Optional.empty();
        Optional<Object> nearestVisibleHuntable = Optional.empty();
        Optional<Object> nearestAttackable = Optional.empty();
        NearestVisibleLivingEntities nvle = brain.m_21952_(MemoryModuleType.f_148205_).orElse(NearestVisibleLivingEntities.m_186106_());
        for (LivingEntity livingEntity : nvle.m_186123_(le -> true)) {
            Player player;
            if (nearestPlayerNotSneaking.isEmpty() && livingEntity instanceof Player && WolfAi.isTargetablePlayerNotSneaking(wolf, player = (Player)livingEntity)) {
                nearestPlayerNotSneaking = Optional.of(player);
                continue;
            }
            if (nearestDisliked.isEmpty() && WolfAi.isDisliked(livingEntity)) {
                nearestDisliked = Optional.of(livingEntity);
                continue;
            }
            if (nearestVisibleHuntable.isEmpty() && WolfSpecificSensor.isHuntable(wolf, livingEntity)) {
                nearestVisibleHuntable = Optional.of(livingEntity);
                continue;
            }
            if (!nearestAttackable.isEmpty() || !WolfSpecificSensor.isAttackable(wolf, livingEntity)) continue;
            nearestAttackable = Optional.of(livingEntity);
        }
        brain.m_21886_((MemoryModuleType)ABABMemoryModuleTypes.NEAREST_TARGETABLE_PLAYER_NOT_SNEAKING.get(), nearestPlayerNotSneaking);
        brain.m_21886_((MemoryModuleType)ABABMemoryModuleTypes.NEAREST_VISIBLE_DISLIKED.get(), nearestDisliked);
        brain.m_21886_((MemoryModuleType)ABABMemoryModuleTypes.NEAREST_VISIBLE_HUNTABLE.get(), nearestVisibleHuntable);
        brain.m_21886_(MemoryModuleType.f_148194_, nearestAttackable);
    }

    private static boolean isAttackable(Wolf wolf, LivingEntity livingEntity) {
        return livingEntity.m_6095_().m_204039_(ABABTags.WOLF_ALWAYS_HOSTILES) && AiUtil.isClose((Mob)wolf, livingEntity, (Integer)ABABConfig.wolfTargetDetectionDistance.get()) && AiUtil.isAttackable((Mob)wolf, livingEntity, true) && SharedWolfAi.wantsToAttack(wolf, livingEntity);
    }

    private static boolean isHuntable(Wolf wolf, LivingEntity livingEntity) {
        return livingEntity.m_6095_().m_204039_(ABABTags.WOLF_HUNT_TARGETS) && AiUtil.isClose((Mob)wolf, livingEntity, (Integer)ABABConfig.wolfTargetDetectionDistance.get()) && AiUtil.isAttackable((Mob)wolf, livingEntity, true) && SharedWolfAi.wantsToAttack(wolf, livingEntity);
    }
}

