/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.logic.entity_manager;

import com.google.common.collect.Streams;
import com.infamous.all_bark_all_bite.common.logic.entity_manager.TickableEntityManager;
import com.infamous.all_bark_all_bite.common.util.MiscUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;

public class MultiEntityManager
implements TickableEntityManager {
    private static final int CONVERSION_DELAY = MiscUtil.seconds(2.0);
    private int conversionDelay = Mth.m_216287_((RandomSource)RandomSource.m_216327_(), (int)0, (int)CONVERSION_DELAY);
    private final Set<Entity> entities = new HashSet<Entity>();
    private final Set<UUID> entityUuids;

    public static Codec<MultiEntityManager> codec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_216157_.listOf().fieldOf("uuids").orElse(Collections.emptyList()).forGetter(MultiEntityManager::createEntityUuids)).apply((Applicative)instance, MultiEntityManager::new));
    }

    public MultiEntityManager(List<UUID> entityUuids) {
        this.entityUuids = new HashSet<UUID>(entityUuids.size());
        this.entityUuids.addAll(entityUuids);
    }

    private List<UUID> createEntityUuids() {
        return Streams.concat((Stream[])new Stream[]{this.entities.stream().map(Entity::m_20148_), this.entityUuids.stream()}).collect(Collectors.toList());
    }

    @Override
    public void tick(ServerLevel level, Predicate<Entity> isValid, Consumer<Entity> onInvalid) {
        --this.conversionDelay;
        if (this.conversionDelay <= 0) {
            this.convertFromUuids(level);
            this.conversionDelay = CONVERSION_DELAY;
        }
        Iterator<Entity> entityIterator = this.entities.iterator();
        while (entityIterator.hasNext()) {
            Entity entity = entityIterator.next();
            Entity.RemovalReason removalReason = entity.m_146911_();
            boolean isRemoved = removalReason != null;
            boolean valid = isValid.test(entity);
            if (valid && !isRemoved) continue;
            if (!valid) {
                onInvalid.accept(entity);
            }
            entityIterator.remove();
            if (!isRemoved) continue;
            switch (removalReason) {
                case CHANGED_DIMENSION: 
                case UNLOADED_TO_CHUNK: 
                case UNLOADED_WITH_PLAYER: {
                    this.entityUuids.add(entity.m_20148_());
                }
            }
        }
    }

    private void convertFromUuids(ServerLevel level) {
        Iterator<UUID> uuidIterator = this.entityUuids.iterator();
        while (uuidIterator.hasNext()) {
            UUID uuid = uuidIterator.next();
            Entity entity = level.m_8791_(uuid);
            if (entity == null) continue;
            this.entities.add(entity);
            uuidIterator.remove();
        }
    }

    public Stream<Entity> stream() {
        return this.entities.stream();
    }

    public int size() {
        return this.entities.size() + this.entityUuids.size();
    }

    public void add(Entity entity) {
        boolean untracked;
        boolean bl = untracked = !this.entities.contains(entity);
        if (untracked) {
            this.entityUuids.remove(entity.m_20148_());
            this.entities.add(entity);
        }
    }

    public void remove(Entity entity) {
        this.entities.remove(entity);
        this.entityUuids.remove(entity.m_20148_());
    }
}

