/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.item;

import com.infamous.all_bark_all_bite.common.item.AdjustableInstrumentItem;
import com.infamous.all_bark_all_bite.common.logic.PetManagement;
import com.infamous.all_bark_all_bite.common.logic.entity_manager.MultiEntityManager;
import com.infamous.all_bark_all_bite.common.registry.ABABInstruments;
import com.infamous.all_bark_all_bite.common.registry.ABABItems;
import com.infamous.all_bark_all_bite.common.util.PetUtil;
import com.infamous.all_bark_all_bite.common.util.ai.AiUtil;
import com.infamous.all_bark_all_bite.common.util.ai.CommandAi;
import com.infamous.all_bark_all_bite.config.ABABConfig;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class PetWhistleItem
extends AdjustableInstrumentItem {
    private static final String BOUND_TO_TAG = "BoundTo";
    private static final String NAME_TAG = "Name";
    private static final String UUID_TAG = "UUID";
    public static final String CONTAINER_TITLE_ID = String.format("container.%s.%s", "all_bark_all_bite", "whistle");
    public static final String UNBIND_BUTTON_LABEL_ID = String.format("container.%s.%s.%s", "all_bark_all_bite", "whistle", "unbind");

    public PetWhistleItem(Item.Properties properties, TagKey<Instrument> instruments) {
        super(properties, instruments);
    }

    public static boolean interactWithPet(ItemStack stack, Player player, Entity target, InteractionHand hand) {
        if (PetWhistleItem.isOwnedBy(target, (Entity)player)) {
            CompoundTag boundToTag = stack.m_41698_(BOUND_TO_TAG);
            boundToTag.m_128359_(NAME_TAG, target.m_7755_().getString());
            boundToTag.m_128362_(UUID_TAG, target.m_20148_());
            stack.m_41700_(BOUND_TO_TAG, (Tag)boundToTag);
            player.m_21008_(hand, stack);
            player.m_36335_().m_41524_(stack.m_41720_(), 20);
            return true;
        }
        return false;
    }

    public static void unbind(ItemStack stack) {
        stack.m_41749_(BOUND_TO_TAG);
    }

    private static boolean isOwnedBy(Entity target, Entity owner) {
        return PetUtil.getOwnerUUID(target).filter(uuid -> uuid.equals(owner.m_20148_())).isPresent();
    }

    @Nullable
    private static UUID getPetUUID(ItemStack stack) {
        CompoundTag petTag = PetWhistleItem.getBoundTo(stack);
        if (petTag != null) {
            return petTag.m_128342_(UUID_TAG);
        }
        return null;
    }

    @Nullable
    public static CompoundTag getBoundTo(ItemStack stack) {
        return stack.m_41737_(BOUND_TO_TAG);
    }

    public static void onItemUseStart(LivingEntity user, ItemStack useItem, ServerLevel serverLevel) {
        Optional<Holder<Instrument>> instrumentHolder = ((AdjustableInstrumentItem)((Object)ABABItems.WHISTLE.get())).m_220134_(useItem);
        if (instrumentHolder.isPresent()) {
            Instrument instrument = (Instrument)instrumentHolder.get().m_203334_();
            MultiEntityManager petManager = PetManagement.getPetManager((ResourceKey<Level>)user.m_9236_().m_46472_(), user.m_20148_());
            UUID petUUID = PetWhistleItem.getPetUUID(useItem);
            if (instrument == ABABInstruments.ATTACK_WHISTLE.get()) {
                AiUtil.getTargetedEntity((Entity)user, (Integer)ABABConfig.whistleAttackMaxDistance.get()).filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast).ifPresent(target -> PetWhistleItem.commandPet(petManager, dog -> CommandAi.commandAttack(dog, target, user), petUUID));
            } else if (instrument == ABABInstruments.COME_WHISTLE.get()) {
                PetWhistleItem.commandPet(petManager, pet -> CommandAi.commandCome(pet, user, serverLevel), petUUID);
            } else if (instrument == ABABInstruments.FOLLOW_WHISTLE.get()) {
                PetWhistleItem.commandPet(petManager, pet -> CommandAi.commandFollow(pet, user), petUUID);
            } else if (instrument == ABABInstruments.FREE_WHISTLE.get()) {
                PetWhistleItem.commandPet(petManager, pet -> CommandAi.commandFree(pet, user), petUUID);
            } else if (instrument == ABABInstruments.GO_WHISTLE.get()) {
                HitResult hitResult = AiUtil.getHitResult((Entity)user, (Integer)ABABConfig.whistleGoMaxDistance.get());
                if (hitResult.m_6662_() != HitResult.Type.MISS) {
                    PetWhistleItem.commandPet(petManager, pet -> CommandAi.commandGo(pet, user, hitResult), petUUID);
                }
            } else if (instrument == ABABInstruments.HEEL_WHISTLE.get()) {
                PetWhistleItem.commandPet(petManager, pet -> CommandAi.commandHeel(pet, user), petUUID);
            } else if (instrument == ABABInstruments.SIT_WHISTLE.get()) {
                PetWhistleItem.commandPet(petManager, pet -> CommandAi.commandSit(pet, user), petUUID);
            }
        }
    }

    private static void commandPet(MultiEntityManager petManager, Consumer<PathfinderMob> command, @Nullable UUID petUUID) {
        petManager.stream().forEach(pet -> {
            if (pet instanceof PathfinderMob) {
                PathfinderMob mob = (PathfinderMob)pet;
                if (petUUID == null || pet.m_20148_().equals(petUUID)) {
                    command.accept(mob);
                }
            }
        });
    }

    @Override
    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, level, components, tooltipFlag);
        CompoundTag petTag = PetWhistleItem.getBoundTo(itemStack);
        if (petTag != null) {
            MutableComponent boundTooltip = Component.m_237110_((String)PetWhistleItem.getBoundToTooltipId(), (Object[])new Object[]{petTag.m_128461_(NAME_TAG)});
            components.add((Component)boundTooltip.m_130940_(ChatFormatting.GRAY));
        }
    }

    public static String getBoundToTooltipId() {
        return PetWhistleItem.getWhistleAdditionalInfoTooltipId("bound_to");
    }

    private static String getWhistleAdditionalInfoTooltipId(String additionalInfo) {
        return ((AdjustableInstrumentItem)((Object)ABABItems.WHISTLE.get())).m_5524_() + "." + additionalInfo;
    }
}

