/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.item;

import com.infamous.all_bark_all_bite.common.network.ABABNetwork;
import com.infamous.all_bark_all_bite.common.network.ClientboundOpenWhistleScreenPacket;
import com.infamous.all_bark_all_bite.common.util.InstrumentUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AdjustableInstrumentItem
extends InstrumentItem {
    private static final ResourceLocation ADJUSTABLE_INSTRUMENT = new ResourceLocation("all_bark_all_bite", "adjustable_instrument");
    public static final String SECONDARY_USE_TOOLTIP = String.format("%s.%s", Util.m_137492_((String)"item", (ResourceLocation)ADJUSTABLE_INSTRUMENT), "secondary_use");
    private final TagKey<Instrument> instruments;

    public AdjustableInstrumentItem(Item.Properties properties, TagKey<Instrument> instruments) {
        super(properties, instruments);
        this.instruments = instruments;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, level, components, tooltipFlag);
        MutableComponent secondaryUseTooltip = Component.m_237115_((String)SECONDARY_USE_TOOLTIP);
        components.add((Component)secondaryUseTooltip.m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemInHand = player.m_21120_(hand);
        if (player.m_36341_()) {
            ABABNetwork.syncToPlayer(player, new ClientboundOpenWhistleScreenPacket(hand));
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)itemInHand, (boolean)level.m_5776_());
        }
        return super.m_7203_(level, player, hand);
    }

    public Optional<Holder<Instrument>> m_220134_(ItemStack itemStack) {
        ResourceLocation location;
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null && (location = ResourceLocation.m_135820_((String)tag.m_128461_("instrument"))) != null) {
            return InstrumentUtil.getInstrumentHolder(location);
        }
        Iterator<Holder<Instrument>> iterator = this.getInstruments().iterator();
        return iterator.hasNext() ? Optional.of(iterator.next()) : Optional.empty();
    }

    public Iterable<Holder<Instrument>> getInstruments() {
        return Registry.f_235738_.m_206058_(this.instruments);
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> itemStacks) {
        if (this.m_220152_(tab)) {
            for (Holder<Instrument> instrument : this.getInstruments()) {
                ItemStack itemStack = AdjustableInstrumentItem.m_220107_((Item)this, instrument);
                itemStacks.add((Object)itemStack);
            }
        }
    }
}

