/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.entity.wolf;

import com.infamous.all_bark_all_bite.common.entity.SharedWolfAi;
import com.infamous.all_bark_all_bite.common.entity.wolf.WolfAi;
import com.infamous.all_bark_all_bite.common.entity.wolf.WolfBrain;
import com.infamous.all_bark_all_bite.common.registry.ABABMemoryModuleTypes;
import com.infamous.all_bark_all_bite.common.util.DebugUtil;
import com.infamous.all_bark_all_bite.common.util.EntityDimensionsUtil;
import com.infamous.all_bark_all_bite.common.util.ai.BrainUtil;
import com.infamous.all_bark_all_bite.common.util.ai.TrustAi;
import com.infamous.all_bark_all_bite.config.ABABConfig;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;

public class WolfHooks {
    public static void onWolfJoinLevel(Wolf wolf, boolean loadedFromDisk) {
        wolf.f_21345_.m_148096_();
        wolf.f_21346_.m_148096_();
        WolfBrain.makeBrain(BrainUtil.getTypedBrain(wolf));
        wolf.m_21573_().m_7008_(true);
        if (!loadedFromDisk) {
            WolfAi.initMemories(wolf, wolf.m_217043_());
            wolf.m_21553_(true);
        }
    }

    public static void onWolfUpdate(Wolf wolf, ServerLevel level) {
        level.m_46473_().m_6180_("wolfBrain");
        BrainUtil.getTypedBrain(wolf).m_21865_(level, (LivingEntity)wolf);
        level.m_46473_().m_7238_();
        DebugUtil.sendEntityBrain((LivingEntity)wolf, level, (MemoryModuleType)ABABMemoryModuleTypes.FOLLOW_TRIGGER_DISTANCE.get(), (MemoryModuleType)ABABMemoryModuleTypes.HUNT_TARGET.get(), (MemoryModuleType)ABABMemoryModuleTypes.IS_ALERT.get(), (MemoryModuleType)ABABMemoryModuleTypes.IS_FOLLOWING.get(), (MemoryModuleType)ABABMemoryModuleTypes.IS_ORDERED_TO_FOLLOW.get(), (MemoryModuleType)ABABMemoryModuleTypes.IS_ORDERED_TO_SIT.get(), (MemoryModuleType)ABABMemoryModuleTypes.IS_SHELTERED.get(), MemoryModuleType.f_148196_, (MemoryModuleType)ABABMemoryModuleTypes.TRUST.get());
    }

    public static void onWolfPupSpawn(Wolf pup, @Nullable Player bredByPlayer) {
        if (bredByPlayer != null) {
            TrustAi.setTrust((LivingEntity)pup, (Integer)ABABConfig.wolfStartingTrust.get());
            TrustAi.setLikedPlayer((LivingEntity)pup, (LivingEntity)bredByPlayer);
        }
    }

    public static void onWolfJump(LivingEntity entity) {
        entity.f_19853_.m_7605_((Entity)entity, (byte)1);
    }

    public static Brain.Provider<Wolf> getWolfBrainProvider() {
        return Brain.m_21923_(WolfAi.MEMORY_TYPES, WolfAi.SENSOR_TYPES);
    }

    public static EntityDimensions onWolfSize(Entity entity, EntityDimensions originalSize) {
        originalSize = EntityDimensionsUtil.resetIfSleeping(entity, originalSize);
        originalSize = EntityDimensionsUtil.unfixIfNeeded(originalSize);
        EntityDimensions resize = originalSize.m_20388_(((Double)ABABConfig.wolfHitboxSizeScale.get()).floatValue());
        resize = EntityDimensionsUtil.resizeForLongJumpIfNeeded(entity, resize, 0.7f);
        return resize;
    }

    public static boolean wolfWantsToPickUp(ItemStack stack, Mob wolf) {
        return ForgeEventFactory.getMobGriefingEvent((Level)wolf.f_19853_, (Entity)wolf) && wolf.m_21531_() && SharedWolfAi.isAbleToPickUp(wolf, stack);
    }

    public static boolean canWolfTakeItem(ItemStack stack, Mob wolf, boolean canMobTakeItem) {
        EquipmentSlot slot = Mob.m_147233_((ItemStack)stack);
        if (!wolf.m_6844_(slot).m_41619_()) {
            return false;
        }
        return slot == EquipmentSlot.MAINHAND && canMobTakeItem;
    }

    public static boolean canWolfHoldItem(ItemStack itemStack, Animal wolf) {
        ItemStack itemInMouth = wolf.m_21205_();
        return itemInMouth.m_41619_() || wolf.m_6898_(itemStack) && !wolf.m_6898_(itemInMouth);
    }

    public static void onWolfPickUpItem(Mob wolf, ItemEntity itemEntity) {
        wolf.m_21053_(itemEntity);
        SharedWolfAi.pickUpAndHoldItem(wolf, itemEntity);
    }

    public static SoundEvent getWolfEatingSound() {
        return SoundEvents.f_11947_;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canWolfMate(Wolf wolf, Animal partner) {
        if (partner == wolf) return false;
        if (!(partner instanceof Wolf)) return false;
        Wolf mate = (Wolf)partner;
        if (!SharedWolfAi.canMove(wolf)) return false;
        if (!SharedWolfAi.canMove(mate)) return false;
        if (!wolf.m_27593_()) return false;
        if (!mate.m_27593_()) return false;
        return true;
    }

    @Nullable
    public static SoundEvent getWolfAmbientSound(Wolf wolf) {
        return wolf.f_19853_.f_46443_ ? null : (SoundEvent)WolfAi.getSoundForCurrentActivity(wolf).orElse(null);
    }
}

