/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.entity.illager_hound;

import com.infamous.all_bark_all_bite.common.entity.EntityAnimationController;
import com.infamous.all_bark_all_bite.common.entity.OwnableMob;
import com.infamous.all_bark_all_bite.common.entity.SharedWolfAi;
import com.infamous.all_bark_all_bite.common.entity.illager_hound.IllagerHoundAi;
import com.infamous.all_bark_all_bite.common.util.DebugUtil;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class IllagerHound
extends Monster
implements OwnableMob {
    private static final EntityDataAccessor<Optional<UUID>> DATA_OWNERUUID_ID = SynchedEntityData.m_135353_(IllagerHound.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> DATA_OWNERID_ID = SynchedEntityData.m_135353_(IllagerHound.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final EntityAnimationController<IllagerHound> animationController;
    @Nullable
    private LivingEntity cachedOwner;

    public IllagerHound(EntityType<? extends IllagerHound> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 5;
        this.animationController = new EntityAnimationController<IllagerHound>(this, (EntityDataAccessor<Pose>)Entity.f_19806_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.3);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_OWNERUUID_ID, Optional.empty());
        this.f_19804_.m_135372_(DATA_OWNERID_ID, (Object)0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        this.writeOwnerNBT(tag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.readOwnerNBT(tag);
    }

    public boolean m_6779_(LivingEntity target) {
        return !this.isOwnedBy(target) && super.m_6779_(target);
    }

    public Team m_5647_() {
        return this.getOwnerTeam().orElse(super.m_5647_());
    }

    public boolean m_7307_(Entity other) {
        return this.isOwnerAlliedTo(other) || super.m_7307_(other);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected Brain.Provider<IllagerHound> m_5490_() {
        return Brain.m_21923_(IllagerHoundAi.MEMORY_TYPES, IllagerHoundAi.SENSOR_TYPES);
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        Brain brain = this.m_5490_().m_22073_(dynamic);
        IllagerHoundAi.makeBrain((Brain<IllagerHound>)brain);
        return brain;
    }

    public Brain<IllagerHound> m_6274_() {
        return super.m_6274_();
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        super.m_7350_(entityDataAccessor);
        if (this.animationController != null) {
            this.animationController.onSyncedDataUpdatedAnimations(entityDataAccessor);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.animationController.tickAnimations();
    }

    public void m_8107_() {
        super.m_8107_();
        this.animationController.aiStepAnimations();
    }

    protected void m_6135_() {
        super.m_6135_();
        if (!this.f_19853_.f_46443_) {
            this.f_19853_.m_7605_((Entity)this, (byte)1);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        amount = SharedWolfAi.maybeReduceDamage(amount, source);
        return super.m_6469_(source, amount);
    }

    public boolean m_7327_(Entity target) {
        this.f_19853_.m_7605_((Entity)this, (byte)4);
        return super.m_7327_(target);
    }

    public void m_7822_(byte id) {
        this.animationController.handleEntityEventAnimation(id);
        super.m_7822_(id);
    }

    protected void m_8024_() {
        this.f_19853_.m_46473_().m_6180_("houndBrain");
        this.m_6274_().m_21865_((ServerLevel)this.f_19853_, (LivingEntity)this);
        this.f_19853_.m_46473_().m_7238_();
        this.f_19853_.m_46473_().m_6180_("houndActivityUpdate");
        IllagerHoundAi.updateActivity(this);
        this.f_19853_.m_46473_().m_7238_();
        super.m_8024_();
    }

    protected void m_8025_() {
        super.m_8025_();
        DebugPackets.m_133695_((LivingEntity)this);
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            DebugUtil.sendEntityBrain((LivingEntity)this, serverLevel, MemoryModuleType.f_26349_);
        }
    }

    protected SoundEvent m_7515_() {
        if (this.f_19853_.f_46443_) {
            return null;
        }
        return this.f_20939_.m_21874_(MemoryModuleType.f_26372_) ? SoundEvents.f_12619_ : SoundEvents.f_12617_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12621_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12618_;
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_(SoundEvents.f_12624_, 0.15f, 1.0f);
    }

    public boolean m_6573_(Player player) {
        return !this.m_5912_() && !this.m_21523_();
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return dimensions.f_20378_ * 0.8f;
    }

    public float m_6121_() {
        return 0.4f;
    }

    public int m_5792_() {
        return 8;
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    @Nullable
    public ItemStack m_142340_() {
        return ForgeSpawnEggItem.fromEntityType((EntityType)this.m_6095_()).m_7968_();
    }

    protected void playAngrySound() {
        this.m_5496_(SoundEvents.f_12619_, this.m_6121_(), this.m_6100_());
    }

    @Nullable
    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(DATA_OWNERUUID_ID)).orElse(null);
    }

    @Override
    public void setOwnerUUID(@Nullable UUID ownerUUID) {
        this.f_19804_.m_135381_(DATA_OWNERUUID_ID, Optional.ofNullable(ownerUUID));
    }

    @Override
    public int getOwnerId() {
        return (Integer)this.f_19804_.m_135370_(DATA_OWNERID_ID);
    }

    @Override
    public void setOwnerId(int ownerId) {
        this.f_19804_.m_135381_(DATA_OWNERID_ID, (Object)ownerId);
    }

    @Override
    public void setCachedOwner(@Nullable LivingEntity cachedOwner) {
        this.cachedOwner = cachedOwner;
    }

    @Override
    @Nullable
    public LivingEntity getCachedOwner() {
        return this.cachedOwner;
    }
}

