/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.entity.houndmaster;

import com.google.common.collect.Maps;
import com.infamous.all_bark_all_bite.common.entity.houndmaster.HoundmasterAnimationController;
import com.infamous.all_bark_all_bite.common.entity.illager_hound.IllagerHound;
import com.infamous.all_bark_all_bite.common.logic.PetManagement;
import com.infamous.all_bark_all_bite.common.registry.ABABEntityTypes;
import com.infamous.all_bark_all_bite.common.registry.ABABInstruments;
import com.infamous.all_bark_all_bite.common.registry.ABABSoundEvents;
import com.infamous.all_bark_all_bite.common.util.MiscUtil;
import com.infamous.all_bark_all_bite.common.util.ai.AiUtil;
import com.infamous.all_bark_all_bite.config.ABABConfig;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeSpawnEggItem;
import org.jetbrains.annotations.Nullable;

public class Houndmaster
extends AbstractIllager
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> DATA_WHISTLING = SynchedEntityData.m_135353_(Houndmaster.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final int MAX_HOUNDS_TO_SUMMON = 3;
    private static final int DEFAULT_WHISTLE_DELAY = MiscUtil.seconds(1.0);
    public final HoundmasterAnimationController animationController;
    private int summonCooldown;
    private List<Entity> knownPetHounds = List.of();

    public Houndmaster(EntityType<? extends Houndmaster> type, Level level) {
        super(type, level);
        this.animationController = new HoundmasterAnimationController(this, DATA_WHISTLING, (EntityDataAccessor<Pose>)f_19806_);
        this.summonCooldown = DEFAULT_WHISTLE_DELAY;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SummonHoundsGoal());
        this.f_21345_.m_25352_(2, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21345_.m_25352_(3, (Goal)new RangedBowAttackGoal((Monster)this, 0.5, 20, 15.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22279_, 0.35);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_WHISTLING, (Object)false);
    }

    public void m_7350_(EntityDataAccessor<?> dataAccessor) {
        super.m_7350_(dataAccessor);
        if (this.animationController != null) {
            this.animationController.onSyncedDataUpdatedAnimations(dataAccessor);
        }
    }

    public boolean m_5886_(ProjectileWeaponItem item) {
        return item instanceof BowItem;
    }

    public void m_8119_() {
        if (this.f_19853_.m_5776_()) {
            this.animationController.tickAnimations();
        }
        super.m_8119_();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.summonCooldown > 0) {
            --this.summonCooldown;
        }
        if (!this.f_19853_.f_46443_ && this.summonCooldown == 0) {
            this.knownPetHounds = PetManagement.getPetManager((ResourceKey<Level>)this.f_19853_.m_46472_(), this.m_20148_()).stream().filter(entity -> entity instanceof IllagerHound).collect(Collectors.toList());
        }
    }

    public AbstractIllager.IllagerArmPose m_6768_() {
        if (this.m_5912_()) {
            if (this.m_21093_(is -> is.m_41720_() instanceof BowItem)) {
                return AbstractIllager.IllagerArmPose.BOW_AND_ARROW;
            }
            return AbstractIllager.IllagerArmPose.ATTACKING;
        }
        return AbstractIllager.IllagerArmPose.NEUTRAL;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag tag) {
        RandomSource randomSource = levelAccessor.m_213780_();
        this.m_213945_(randomSource, difficultyInstance);
        this.m_213946_(randomSource, difficultyInstance);
        return super.m_6518_(levelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, tag);
    }

    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficultyInstance) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
    }

    protected void m_214095_(RandomSource randomSource, float specialMultiplier) {
        ItemStack mainHandItem;
        super.m_214095_(randomSource, specialMultiplier);
        if (MiscUtil.oneInChance(randomSource, 300) && (mainHandItem = this.m_21205_()).m_150930_(Items.f_42411_)) {
            Map map = EnchantmentHelper.m_44831_((ItemStack)mainHandItem);
            map.putIfAbsent(Enchantments.f_44989_, 1);
            EnchantmentHelper.m_44865_((Map)map, (ItemStack)mainHandItem);
            this.m_8061_(EquipmentSlot.MAINHAND, mainHandItem);
        }
    }

    public boolean m_7307_(@Nullable Entity other) {
        LivingEntity livingEntity;
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (super.m_7307_(other)) {
            return true;
        }
        if (other instanceof OwnableEntity) {
            OwnableEntity ownable = (OwnableEntity)other;
            return this.m_7307_(ownable.m_21826_());
        }
        if (other instanceof LivingEntity && (livingEntity = (LivingEntity)other).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && other.m_5647_() == null;
        }
        return false;
    }

    public SoundEvent m_7930_() {
        return SoundEvents.f_12308_;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12307_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12309_;
    }

    protected SoundEvent m_7975_(DamageSource p_32654_) {
        return SoundEvents.f_12310_;
    }

    public void m_7895_(int groupsSpawned, boolean b) {
        boolean enchant;
        Raid raid = this.m_37885_();
        boolean bl = enchant = this.f_19796_.m_188501_() <= raid.m_37783_();
        if (enchant) {
            ItemStack bowStack = new ItemStack((ItemLike)Items.f_42411_);
            HashMap map = Maps.newHashMap();
            Enchantment difficultyScaledEnchant = Enchantments.f_44988_;
            if (groupsSpawned > raid.m_37724_(Difficulty.NORMAL)) {
                map.put(difficultyScaledEnchant, 2);
            } else if (groupsSpawned > raid.m_37724_(Difficulty.EASY)) {
                map.put(difficultyScaledEnchant, 1);
            }
            map.put(Enchantments.f_44989_, 1);
            EnchantmentHelper.m_44865_((Map)map, (ItemStack)bowStack);
            this.m_8061_(EquipmentSlot.MAINHAND, bowStack);
        }
    }

    public void m_6504_(LivingEntity target, float power) {
        InteractionHand weaponHoldingHand = ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem);
        ItemStack projectile = this.m_6298_(this.m_21120_(weaponHoldingHand));
        AbstractArrow arrow = ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)projectile, (float)power);
        Item item2 = this.m_21120_(weaponHoldingHand).m_41720_();
        if (item2 instanceof BowItem) {
            BowItem bowItem = (BowItem)item2;
            arrow = bowItem.customArrow(arrow);
        }
        double xDist = target.m_20185_() - this.m_20185_();
        double yDist = target.m_20227_(0.3333333333333333) - arrow.m_20186_();
        double zDist = target.m_20189_() - this.m_20189_();
        double horizontalDist = Math.sqrt(xDist * xDist + zDist * zDist);
        arrow.m_6686_(xDist, yDist + horizontalDist * 0.2, zDist, 1.6f, (float)(14 - this.f_19853_.m_46791_().m_19028_() * 4));
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.f_19853_.m_7967_((Entity)arrow);
    }

    public void setWhistling(boolean whistling) {
        this.f_19804_.m_135381_(DATA_WHISTLING, (Object)whistling);
    }

    public boolean isWhistling() {
        return (Boolean)this.f_19804_.m_135370_(DATA_WHISTLING);
    }

    @Nullable
    public ItemStack m_142340_() {
        return ForgeSpawnEggItem.fromEntityType((EntityType)this.m_6095_()).m_7968_();
    }

    class SummonHoundsGoal
    extends Goal {
        private int houndsToSummon;
        private int whistleTicks;

        SummonHoundsGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return Houndmaster.this.summonCooldown == 0 && Houndmaster.this.knownPetHounds.size() < 3;
        }

        public void m_8056_() {
            this.whistleTicks = this.m_183277_(ABABInstruments.WHISTLE_DURATION);
            this.houndsToSummon = 3 - Houndmaster.this.knownPetHounds.size();
            Houndmaster.this.m_5496_((SoundEvent)ABABSoundEvents.COME_WHISTLE.get(), 1.0f, 1.0f);
            Houndmaster.this.setWhistling(true);
        }

        private AABB getTargetSearchArea(double followRange) {
            return Houndmaster.this.m_20191_().m_82400_(followRange);
        }

        private List<IllagerHound> findNearbyWildHounds() {
            return Houndmaster.this.f_19853_.m_6443_(IllagerHound.class, this.getTargetSearchArea(AiUtil.getFollowRange((LivingEntity)Houndmaster.this)), hound -> hound.m_6084_() && hound.m_21805_() == null);
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.whistleTicks > 0;
        }

        public void m_8037_() {
            --this.whistleTicks;
            if (this.whistleTicks <= 0) {
                List<IllagerHound> nearbyWildHounds = this.findNearbyWildHounds();
                for (IllagerHound wildHound : nearbyWildHounds) {
                    if (this.houndsToSummon <= 0) break;
                    wildHound.setOwner((LivingEntity)Houndmaster.this);
                    --this.houndsToSummon;
                }
                this.summonRemainingHounds();
            }
        }

        private void summonRemainingHounds() {
            ServerLevel serverlevel = (ServerLevel)Houndmaster.this.f_19853_;
            for (int i = 0; i < this.houndsToSummon; ++i) {
                BlockPos blockPos = Houndmaster.this.m_20183_().m_7918_(-2 + Houndmaster.this.f_19796_.m_188503_(5), 0, -2 + Houndmaster.this.f_19796_.m_188503_(5));
                MiscUtil.createEntity((EntityType)ABABEntityTypes.ILLAGER_HOUND.get(), serverlevel).ifPresent(hound -> {
                    hound.m_20035_(blockPos, Houndmaster.this.m_146908_(), 0.0f);
                    hound.m_6518_((ServerLevelAccessor)serverlevel, Houndmaster.this.f_19853_.m_6436_(blockPos), MobSpawnType.MOB_SUMMONED, null, null);
                    hound.setOwner((LivingEntity)Houndmaster.this);
                    serverlevel.m_47205_((Entity)hound);
                });
            }
        }

        public void m_8041_() {
            Houndmaster.this.setWhistling(false);
            Houndmaster.this.summonCooldown = MiscUtil.seconds(((Integer)ABABConfig.houndmasterSummonCooldown.get()).intValue());
        }
    }
}

