/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.entity.dog;

import com.google.common.collect.ImmutableList;
import com.infamous.all_bark_all_bite.common.ABABTags;
import com.infamous.all_bark_all_bite.common.behavior.dig.DigAtLocation;
import com.infamous.all_bark_all_bite.common.behavior.item.GiveItemToTarget;
import com.infamous.all_bark_all_bite.common.behavior.item.StartItemActivityWithItemIfSeen;
import com.infamous.all_bark_all_bite.common.behavior.item.StopItemActivityIfItemTooFarAway;
import com.infamous.all_bark_all_bite.common.behavior.item.StopItemActivityIfTiredOfTryingToReachItem;
import com.infamous.all_bark_all_bite.common.behavior.misc.Eat;
import com.infamous.all_bark_all_bite.common.behavior.misc.HurtByTrigger;
import com.infamous.all_bark_all_bite.common.behavior.misc.PerchAndSearch;
import com.infamous.all_bark_all_bite.common.behavior.misc.PlayTagWithOtherBabies;
import com.infamous.all_bark_all_bite.common.behavior.misc.Sprint;
import com.infamous.all_bark_all_bite.common.behavior.misc.UpdateUnitMemory;
import com.infamous.all_bark_all_bite.common.behavior.pet.Beg;
import com.infamous.all_bark_all_bite.common.behavior.sleep.MoveToNonSkySeeingSpot;
import com.infamous.all_bark_all_bite.common.behavior.sleep.WakeUpTrigger;
import com.infamous.all_bark_all_bite.common.entity.SharedWolfAi;
import com.infamous.all_bark_all_bite.common.entity.SharedWolfBrain;
import com.infamous.all_bark_all_bite.common.entity.dog.Dog;
import com.infamous.all_bark_all_bite.common.entity.dog.DogAi;
import com.infamous.all_bark_all_bite.common.logic.BrainMaker;
import com.infamous.all_bark_all_bite.common.registry.ABABActivities;
import com.infamous.all_bark_all_bite.common.registry.ABABEntityTypes;
import com.infamous.all_bark_all_bite.common.registry.ABABMemoryModuleTypes;
import com.infamous.all_bark_all_bite.common.util.ai.AiUtil;
import com.infamous.all_bark_all_bite.common.util.ai.BrainUtil;
import com.infamous.all_bark_all_bite.common.util.ai.DigAi;
import com.infamous.all_bark_all_bite.common.util.ai.GenericAi;
import com.infamous.all_bark_all_bite.data.ABABBuiltInLootTables;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.InteractWith;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunIf;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StayCloseToTarget;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class DogBrain {
    public static Brain<Dog> makeBrain(Brain<Dog> brain) {
        BrainMaker<Dog> brainMaker = new BrainMaker<Dog>(brain);
        brainMaker.initActivityWithConditions(Activity.f_37984_, SharedWolfBrain.getPanicPackage(), SharedWolfBrain.getPanicConditions());
        brainMaker.initActivityWithConditions((Activity)ABABActivities.SIT.get(), SharedWolfBrain.getSitPackage(DogBrain.createIdleLookBehaviors(), DogBrain.beg()), SharedWolfBrain.getSitConditions());
        brainMaker.initActivityWithMemoryGate(Activity.f_37988_, SharedWolfBrain.getFightPackage(DogBrain::isHuntTarget), MemoryModuleType.f_26372_);
        brainMaker.initActivityWithMemoryGate(Activity.f_37991_, SharedWolfBrain.getAvoidPackage(DogBrain.createIdleMovementBehaviors(), DogBrain.createIdleLookBehaviors()), MemoryModuleType.f_26383_);
        brainMaker.initActivityWithMemoryGate(Activity.f_219853_, DogBrain.getDigPackage(), (MemoryModuleType)ABABMemoryModuleTypes.DIG_LOCATION.get());
        brainMaker.initActivityWithMemoryGate((Activity)ABABActivities.FETCH.get(), DogBrain.getFetchPackage(), (MemoryModuleType)ABABMemoryModuleTypes.FETCHING_ITEM.get());
        brainMaker.initActivityWithConditions((Activity)ABABActivities.FOLLOW.get(), SharedWolfBrain.getFollowPackage(DogBrain.createIdleMovementBehaviors(), DogBrain.beg(), DogBrain.createIdleLookBehaviors()), SharedWolfBrain.getFollowConditions());
        brainMaker.initActivityWithMemoryGate((Activity)ABABActivities.HUNT.get(), SharedWolfBrain.getHuntPackage(), (MemoryModuleType)ABABMemoryModuleTypes.HUNT_TARGET.get());
        brainMaker.initActivityWithConditions(Activity.f_37982_, SharedWolfBrain.getRestPackage(DogBrain.createIdleLookBehaviors(), false), SharedWolfBrain.getRestConditions((MemoryModuleType<Unit>)((MemoryModuleType)ABABMemoryModuleTypes.IS_LEVEL_NIGHT.get())));
        brainMaker.initActivity(Activity.f_37979_, DogBrain.getIdlePackage());
        brainMaker.initCoreActivity(Activity.f_37978_, DogBrain.getCorePackage());
        brainMaker.initCoreActivity((Activity)ABABActivities.COUNT_DOWN.get(), SharedWolfBrain.getCountDownPackage());
        brainMaker.initCoreActivity((Activity)ABABActivities.TARGET.get(), SharedWolfBrain.getTargetPackage(DogBrain::wasHurtBy, DogBrain::canStartHunting));
        brainMaker.initCoreActivity((Activity)ABABActivities.UPDATE.get(), SharedWolfBrain.getUpdatePackage(brainMaker.getActivities(), DogBrain::onActivityChanged));
        return brainMaker.makeBrain(Activity.f_37979_);
    }

    private static Beg<Dog> beg() {
        return new Beg<Dog>(DogAi::isInteresting, Wolf::m_30444_, 8.0f);
    }

    private static boolean isHuntTarget(Dog dog, LivingEntity target) {
        return target.m_6095_().m_204039_(ABABTags.DOG_HUNT_TARGETS);
    }

    private static void wasHurtBy(Dog dog, LivingEntity attacker) {
        AiUtil.eraseMemories((LivingEntity)dog, MemoryModuleType.f_26375_, (MemoryModuleType)ABABMemoryModuleTypes.HUNT_TARGET.get(), (MemoryModuleType)ABABMemoryModuleTypes.FETCHING_ITEM.get(), (MemoryModuleType)ABABMemoryModuleTypes.DIG_LOCATION.get());
        SharedWolfAi.reactToAttack(dog, attacker);
    }

    private static boolean canStartHunting(Dog dog) {
        return !dog.m_21824_() && SharedWolfAi.canStartAttacking(dog);
    }

    private static void onActivityChanged(Dog dog, Pair<Activity, Activity> ignoredActivityChange) {
        DogAi.getSoundForCurrentActivity(dog).ifPresent(se -> AiUtil.playSoundEvent((LivingEntity)dog, se));
    }

    private static ImmutableList<? extends Pair<Integer, ? extends Behavior<? super Dog>>> getCorePackage() {
        return BrainUtil.createPriorityPairs(0, ImmutableList.of(new HurtByTrigger<Dog>(SharedWolfBrain::onHurtBy), new WakeUpTrigger<Dog>(SharedWolfAi::wantsToWakeUp), (Object)new Swim(0.8f), SharedWolfBrain.createAnimalPanic(), (Object)new RunIf(TamableAnimal::m_21824_, new StartItemActivityWithItemIfSeen<Dog>(DogBrain::canFetchItemEntity, (MemoryModuleType<Boolean>)((MemoryModuleType)ABABMemoryModuleTypes.FETCHING_ITEM.get()), (MemoryModuleType<Boolean>)((MemoryModuleType)ABABMemoryModuleTypes.FETCHING_DISABLED.get()), (MemoryModuleType<Boolean>)((MemoryModuleType)ABABMemoryModuleTypes.DISABLE_WALK_TO_FETCH_ITEM.get()))), SharedWolfBrain.createLookAtTargetSink(), SharedWolfBrain.createMoveToTargetSink(), SharedWolfBrain.copyToAvoidTarget((MemoryModuleType<? extends LivingEntity>)((MemoryModuleType)ABABMemoryModuleTypes.NEAREST_VISIBLE_DISLIKED.get())), new UpdateUnitMemory<Dog>(TamableAnimal::m_21827_, (MemoryModuleType<Unit>)((MemoryModuleType)ABABMemoryModuleTypes.IS_ORDERED_TO_SIT.get())), new UpdateUnitMemory<Dog>(SharedWolfAi::hasShelter, (MemoryModuleType<Unit>)((MemoryModuleType)ABABMemoryModuleTypes.IS_SHELTERED.get())), new UpdateUnitMemory<Dog>(SharedWolfAi::isInNightTime, (MemoryModuleType<Unit>)((MemoryModuleType)ABABMemoryModuleTypes.IS_LEVEL_NIGHT.get())), new UpdateUnitMemory<Dog>(DogBrain::isAlert, (MemoryModuleType<Unit>)((MemoryModuleType)ABABMemoryModuleTypes.IS_ALERT.get())), (Object[])new Behavior[]{new UpdateUnitMemory<Dog>(LivingEntity::m_5803_, (MemoryModuleType<Unit>)((MemoryModuleType)ABABMemoryModuleTypes.IS_SLEEPING.get()))}));
    }

    private static boolean isAlert(Dog dog) {
        return SharedWolfAi.alertable(dog, ABABTags.DOG_HUNT_TARGETS, ABABTags.DOG_ALWAYS_HOSTILES, ABABTags.DOG_DISLIKED);
    }

    private static boolean canFetchItemEntity(Dog dog, ItemEntity itemEntity) {
        return Util.m_214614_((Object)itemEntity.m_32057_(), uuid -> uuid.equals(dog.m_21805_())) != null && itemEntity.m_32055_().m_204117_(ABABTags.DOG_FETCHES) && itemEntity.m_19950_((Entity)dog, 16.0);
    }

    private static ImmutableList<? extends Pair<Integer, ? extends Behavior<? super Dog>>> getDigPackage() {
        return BrainUtil.createPriorityPairs(0, ImmutableList.of(new Sprint<Dog>(DogBrain::canSprintWhileDigging), (Object)new StayCloseToTarget(DogBrain::getDigPosition, 0, 1, 1.0f), new DigAtLocation<Dog>(DogBrain::onDigCompleted, 100L)));
    }

    private static boolean canSprintWhileDigging(Dog dog) {
        return SharedWolfAi.canMove(dog) && !dog.m_217003_(Pose.DIGGING);
    }

    private static Optional<PositionTracker> getDigPosition(LivingEntity dog) {
        Brain brain = dog.m_6274_();
        Optional<GlobalPos> digLocation = DigAi.getDigLocation(dog);
        if (digLocation.isPresent()) {
            GlobalPos digPos = digLocation.get();
            Level level = dog.m_9236_();
            if (level.m_46472_() == digPos.m_122640_() && level.m_8055_(digPos.m_122646_().m_7495_()).m_204336_(ABABTags.DOG_CAN_DIG)) {
                return Optional.of(new BlockPosTracker(digPos.m_122646_()));
            }
            brain.m_21936_((MemoryModuleType)ABABMemoryModuleTypes.DIG_LOCATION.get());
        }
        return Optional.empty();
    }

    private static void onDigCompleted(Dog dog) {
        LootTable lootTable = dog.f_19853_.m_7654_().m_129898_().m_79217_(ABABBuiltInLootTables.DOG_DIGGING);
        LootContext.Builder lcb = new LootContext.Builder((ServerLevel)dog.f_19853_).m_78972_(LootContextParams.f_81460_, (Object)dog.m_20182_()).m_78972_(LootContextParams.f_81455_, (Object)dog).m_230911_(dog.m_217043_());
        if (DogAi.canBury(dog.m_21205_())) {
            dog.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        }
        BlockPos digPos = DigAi.getDigLocation((LivingEntity)dog).get().m_122646_();
        boolean pickedUp = false;
        for (ItemStack giftStack : lootTable.m_230922_(lcb.m_78975_(LootContextParamSets.f_81416_))) {
            if (!pickedUp) {
                SharedWolfAi.holdInMouth((Mob)dog, giftStack.m_41620_(1));
                SharedWolfBrain.fetchItem((LivingEntity)dog);
                if (!giftStack.m_41619_()) {
                    AiUtil.dropItemAtPos((LivingEntity)dog, digPos, giftStack);
                }
                pickedUp = true;
                continue;
            }
            AiUtil.dropItemAtPos((LivingEntity)dog, digPos, giftStack);
        }
    }

    private static ImmutableList<? extends Pair<Integer, ? extends Behavior<? super Dog>>> getFetchPackage() {
        return BrainUtil.createPriorityPairs(0, ImmutableList.of(new Sprint<Dog>(SharedWolfAi::canMove), SharedWolfAi.createGoToWantedItem(true), new GiveItemToTarget<Dog>(LivingEntity::m_21205_, AiUtil::getOwner, 2, DogBrain::onItemThrown), (Object)new RunIf(DogBrain::canReturnItemToOwner, SharedWolfAi.createFollowOwner(1.0f), true), new StopItemActivityIfItemTooFarAway<Dog>(DogBrain::isNotHoldingItem, 16, (MemoryModuleType<Boolean>)((MemoryModuleType)ABABMemoryModuleTypes.FETCHING_ITEM.get())), new StopItemActivityIfTiredOfTryingToReachItem<Dog>(DogBrain::isNotHoldingItem, 200, 200, (MemoryModuleType<Boolean>)((MemoryModuleType)ABABMemoryModuleTypes.FETCHING_ITEM.get()), (MemoryModuleType<Integer>)((MemoryModuleType)ABABMemoryModuleTypes.TIME_TRYING_TO_REACH_FETCH_ITEM.get()), (MemoryModuleType<Boolean>)((MemoryModuleType)ABABMemoryModuleTypes.DISABLE_WALK_TO_FETCH_ITEM.get())), (Object)new EraseMemoryIf(DogBrain::wantsToStopFetching, (MemoryModuleType)ABABMemoryModuleTypes.FETCHING_ITEM.get())));
    }

    static void onItemThrown(Dog dog) {
        AiUtil.playSoundEvent((LivingEntity)dog, SoundEvents.f_11952_);
        AiUtil.setItemPickupCooldown((LivingEntity)dog, 60);
    }

    private static boolean canReturnItemToOwner(Dog dog) {
        return dog.m_21824_() && !DogBrain.isNotHoldingItem(dog);
    }

    private static boolean isNotHoldingItem(Dog dog) {
        return dog.m_21205_().m_41619_();
    }

    private static boolean wantsToStopFetching(Dog dog) {
        return !dog.m_21824_() || DogBrain.isNotHoldingItem(dog) && GenericAi.isOnPickupCooldown((LivingEntity)dog);
    }

    private static ImmutableList<? extends Pair<Integer, ? extends Behavior<? super Dog>>> getIdlePackage() {
        return BrainUtil.createPriorityPairs(0, ImmutableList.of(new Sprint<Dog>(SharedWolfAi::canMove, 10), (Object)((Object)new Eat(SharedWolfAi::setAteRecently)), (Object)new FollowTemptation(SharedWolfAi::getSpeedModifierTempted), (Object)SharedWolfBrain.createBreedBehavior((EntityType<? extends Wolf>)((EntityType)ABABEntityTypes.DOG.get())), (Object)new RunIf(livingEntity -> SharedWolfAi.wantsToFindShelter((LivingEntity)livingEntity, false), (Behavior)new MoveToNonSkySeeingSpot(1.0f), true), (Object)new BabyFollowAdult(SharedWolfAi.ADULT_FOLLOW_RANGE, 1.0f), SharedWolfBrain.babySometimesHuntBaby(), (Object)((Object)new PlayTagWithOtherBabies(1.0f, 1.0f)), SharedWolfAi.createGoToWantedItem(false), new PerchAndSearch<Dog>(SharedWolfBrain::canPerch, TamableAnimal::m_21837_), DogBrain.createIdleMovementBehaviors(), DogBrain.beg(), (Object[])new Behavior[]{DogBrain.createIdleLookBehaviors()}));
    }

    private static RunOne<Dog> createIdleLookBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)new SetEntityLookTarget((EntityType)ABABEntityTypes.DOG.get(), 8.0f), (Object)1), (Object)Pair.of((Object)new SetEntityLookTarget(EntityType.f_20532_, 8.0f), (Object)1), (Object)Pair.of((Object)new SetEntityLookTarget(EntityType.f_20492_, 8.0f), (Object)1), (Object)Pair.of((Object)new SetEntityLookTarget(8.0f), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    private static RunOne<Dog> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)new RandomStroll(1.0f), (Object)3), (Object)Pair.of((Object)InteractWith.m_23260_((EntityType)((EntityType)ABABEntityTypes.DOG.get()), (int)8, (MemoryModuleType)MemoryModuleType.f_26374_, (float)1.0f, (int)2), (Object)2), (Object)Pair.of((Object)InteractWith.m_23260_((EntityType)EntityType.f_20532_, (int)8, (MemoryModuleType)MemoryModuleType.f_26374_, (float)1.0f, (int)2), (Object)2), (Object)Pair.of((Object)InteractWith.m_23260_((EntityType)EntityType.f_20492_, (int)8, (MemoryModuleType)MemoryModuleType.f_26374_, (float)1.0f, (int)2), (Object)2), (Object)Pair.of((Object)new RunIf(Predicate.not(GenericAi::seesPlayerHoldingWantedItem), (Behavior)new SetWalkTargetFromLookTarget(1.0f, 3)), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }
}

