/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.entity.dog;

import com.infamous.all_bark_all_bite.common.ABABTags;
import com.infamous.all_bark_all_bite.common.compat.CompatUtil;
import com.infamous.all_bark_all_bite.common.compat.RWCompat;
import com.infamous.all_bark_all_bite.common.entity.AnimalAccess;
import com.infamous.all_bark_all_bite.common.entity.EntityVariant;
import com.infamous.all_bark_all_bite.common.entity.SharedWolfAi;
import com.infamous.all_bark_all_bite.common.entity.VariantMob;
import com.infamous.all_bark_all_bite.common.entity.dog.DogAi;
import com.infamous.all_bark_all_bite.common.entity.dog.DogBrain;
import com.infamous.all_bark_all_bite.common.registry.ABABDogVariants;
import com.infamous.all_bark_all_bite.common.registry.ABABEntityDataSerializers;
import com.infamous.all_bark_all_bite.common.registry.ABABEntityTypes;
import com.infamous.all_bark_all_bite.common.registry.ABABMemoryModuleTypes;
import com.infamous.all_bark_all_bite.common.util.DebugUtil;
import com.infamous.all_bark_all_bite.common.util.MiscUtil;
import com.infamous.all_bark_all_bite.common.util.ai.AiUtil;
import com.infamous.all_bark_all_bite.common.util.ai.DigAi;
import com.infamous.all_bark_all_bite.common.util.ai.GenericAi;
import com.mojang.serialization.Dynamic;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.Nullable;

public class Dog
extends Wolf
implements VariantMob {
    private static final EntityDataAccessor<EntityVariant> DATA_VARIANT_ID = SynchedEntityData.m_135353_(Dog.class, (EntityDataSerializer)((EntityDataSerializer)ABABEntityDataSerializers.DOG_VARIANT.get()));

    public Dog(EntityType<? extends Dog> type, Level level) {
        super(type, level);
        this.m_21553_(true);
        this.m_21573_().m_7008_(true);
    }

    protected void m_8099_() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.3);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)((EntityVariant)ABABDogVariants.BROWN.get()));
    }

    public void m_7350_(EntityDataAccessor<?> dataAccessor) {
        super.m_7350_(dataAccessor);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        this.addVariantSaveData(tag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.readVariantSaveData(tag);
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_12624_, 0.15f, 1.0f);
    }

    protected SoundEvent m_7515_() {
        return this.f_19853_.f_46443_ ? null : (SoundEvent)DogAi.getSoundForCurrentActivity(this).orElse(null);
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12621_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12618_;
    }

    public void m_8107_() {
        super.m_8107_();
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        Optional<InteractionResult> rwResult;
        if (CompatUtil.isRWLoaded() && (rwResult = RWCompat.mobInteract(this, player, hand)).isPresent()) {
            return rwResult.get();
        }
        ItemStack stack = player.m_21120_(hand);
        if (this.f_19853_.f_46443_) {
            boolean canInteract = this.m_21830_((LivingEntity)player) || this.m_21824_() || this.m_6898_(stack) && !this.m_21824_() && !this.m_5912_();
            return canInteract ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        Optional<InteractionResult> mobInteract = DogAi.mobInteract(this, player, hand);
        if (mobInteract.isEmpty()) {
            boolean willNotBreed;
            InteractionResult animalInteractResult = ((AnimalAccess)((Object)this)).animalInteract(player, hand);
            if (animalInteractResult.m_19077_()) {
                this.m_21530_();
            }
            boolean bl = willNotBreed = !animalInteractResult.m_19077_();
            if (willNotBreed && this.m_21830_((LivingEntity)player)) {
                SharedWolfAi.manualCommand(this, player);
                DigAi.eraseDigLocation((LivingEntity)this);
                return InteractionResult.CONSUME;
            }
            return animalInteractResult;
        }
        return mobInteract.get();
    }

    protected void m_142075_(Player player, InteractionHand hand, ItemStack stack) {
        AiUtil.animalEat((Animal)this, stack);
        super.m_142075_(player, hand, stack);
    }

    public boolean m_6898_(ItemStack stack) {
        FoodProperties foodProperties = stack.getFoodProperties((LivingEntity)this);
        return stack.m_204117_(ABABTags.DOG_FOOD) || foodProperties != null && foodProperties.m_38746_();
    }

    @Nullable
    public Dog getBreedOffspring(ServerLevel level, AgeableMob partner) {
        Dog offspring = (Dog)((EntityType)ABABEntityTypes.DOG.get()).m_20615_((Level)level);
        if (partner instanceof Dog) {
            Dog mate = (Dog)partner;
            if (offspring != null) {
                if (this.f_19796_.m_188499_()) {
                    offspring.setVariant(this.getVariant());
                } else {
                    offspring.setVariant(mate.getVariant());
                }
                if (this.m_21824_()) {
                    offspring.m_21816_(this.m_21805_());
                    offspring.m_7105_(true);
                    if (this.f_19796_.m_188499_()) {
                        offspring.m_30397_(this.m_30428_());
                    } else {
                        offspring.m_30397_(mate.m_30428_());
                    }
                }
            }
        }
        return offspring;
    }

    public boolean m_7848_(Animal partner) {
        if (partner == this) {
            return false;
        }
        if (!(partner instanceof Dog)) {
            return false;
        }
        Dog mate = (Dog)partner;
        if (this.m_21824_() != mate.m_21824_()) {
            return false;
        }
        if (!SharedWolfAi.canMove(this) || !SharedWolfAi.canMove(mate)) {
            return false;
        }
        return this.m_27593_() && mate.m_27593_();
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        SpawnGroupData spawnGroupData = super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, groupData, tag);
        Collection values = this.getVariantRegistry().getValues();
        RandomSource random = serverLevelAccessor.m_213780_();
        EntityVariant randomVariant = (EntityVariant)MiscUtil.getRandomObject(values, random);
        this.setVariant(randomVariant);
        ServerLevel serverlevel = serverLevelAccessor.m_6018_();
        if (serverlevel.m_215010_().m_220491_(this.m_20183_(), ABABTags.DOGS_SPAWN_AS_BLACK).m_73603_()) {
            this.setVariant((EntityVariant)ABABDogVariants.BLACK.get());
            this.m_21530_();
        }
        SharedWolfAi.initMemories(this, random);
        return spawnGroupData;
    }

    protected void m_6135_() {
        super.m_6135_();
        if (!this.f_19853_.f_46443_) {
            this.f_19853_.m_7605_((Entity)this, (byte)1);
        }
    }

    protected Brain.Provider<Dog> m_5490_() {
        return Brain.m_21923_(DogAi.MEMORY_TYPES, DogAi.SENSOR_TYPES);
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return DogBrain.makeBrain((Brain<Dog>)this.m_5490_().m_22073_(dynamic));
    }

    public Brain<Dog> m_6274_() {
        return super.m_6274_();
    }

    protected void m_8024_() {
        this.f_19853_.m_46473_().m_6180_("dogBrain");
        this.m_6274_().m_21865_((ServerLevel)this.f_19853_, (LivingEntity)this);
        this.f_19853_.m_46473_().m_7238_();
        super.m_8024_();
    }

    public boolean m_7243_(ItemStack stack) {
        return ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this) && this.m_21531_() && DogAi.wantsToPickup((Animal)this, stack);
    }

    public boolean m_21531_() {
        return !GenericAi.isOnPickupCooldown((LivingEntity)this);
    }

    public boolean m_7066_(ItemStack stack) {
        EquipmentSlot slot = Mob.m_147233_((ItemStack)stack);
        if (!this.m_6844_(slot).m_41619_()) {
            return false;
        }
        return slot == EquipmentSlot.MAINHAND && super.m_7066_(stack);
    }

    public boolean m_7252_(ItemStack itemStack) {
        ItemStack itemInMouth = this.m_21205_();
        return itemInMouth.m_41619_() || this.m_6898_(itemStack) && !this.m_6898_(itemInMouth);
    }

    protected void m_7581_(ItemEntity itemEntity) {
        this.m_21053_(itemEntity);
        DogAi.pickUpItem(this, itemEntity);
    }

    public SoundEvent m_7866_(ItemStack stack) {
        return SoundEvents.f_11947_;
    }

    protected void m_8025_() {
        super.m_8025_();
        DebugPackets.m_133695_((LivingEntity)this);
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            DebugUtil.sendEntityBrain((LivingEntity)this, serverLevel, (MemoryModuleType)ABABMemoryModuleTypes.FOLLOW_TRIGGER_DISTANCE.get(), (MemoryModuleType)ABABMemoryModuleTypes.IS_ALERT.get(), (MemoryModuleType)ABABMemoryModuleTypes.IS_FOLLOWING.get(), (MemoryModuleType)ABABMemoryModuleTypes.IS_ORDERED_TO_FOLLOW.get(), (MemoryModuleType)ABABMemoryModuleTypes.IS_ORDERED_TO_SIT.get());
        }
    }

    @Nullable
    public ItemStack m_142340_() {
        return ForgeSpawnEggItem.fromEntityType((EntityType)this.m_6095_()).m_7968_();
    }

    protected int m_5639_(float fallDistance, float fallDamageMultiplier) {
        MobEffectInstance jumpEffectInstance = this.m_21124_(MobEffects.f_19603_);
        float jumpEffectFallReduction = jumpEffectInstance == null ? 0.0f : (float)(jumpEffectInstance.m_19564_() + 1);
        return Mth.m_14167_((float)((fallDistance - 5.0f - jumpEffectFallReduction) * fallDamageMultiplier));
    }

    public boolean m_6785_(double distFromNearestPlayer) {
        return !this.m_21824_() && this.f_19797_ > 2400;
    }

    @Override
    public IForgeRegistry<EntityVariant> getVariantRegistry() {
        return ABABDogVariants.DOG_VARIANT_REGISTRY.get();
    }

    @Override
    public EntityVariant getVariant() {
        return (EntityVariant)this.f_19804_.m_135370_(DATA_VARIANT_ID);
    }

    @Override
    public void setVariant(EntityVariant variant) {
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)variant);
    }
}

