/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.entity;

import com.infamous.all_bark_all_bite.common.behavior.pet.FollowOwner;
import com.infamous.all_bark_all_bite.common.behavior.sleep.MoveToNonSkySeeingSpot;
import com.infamous.all_bark_all_bite.common.compat.CompatUtil;
import com.infamous.all_bark_all_bite.common.compat.DICompat;
import com.infamous.all_bark_all_bite.common.entity.wolf.WolfHooks;
import com.infamous.all_bark_all_bite.common.registry.ABABGameEvents;
import com.infamous.all_bark_all_bite.common.registry.ABABMemoryModuleTypes;
import com.infamous.all_bark_all_bite.common.util.MiscUtil;
import com.infamous.all_bark_all_bite.common.util.PetUtil;
import com.infamous.all_bark_all_bite.common.util.ai.AiUtil;
import com.infamous.all_bark_all_bite.common.util.ai.AngerAi;
import com.infamous.all_bark_all_bite.common.util.ai.CommandAi;
import com.infamous.all_bark_all_bite.common.util.ai.GenericAi;
import com.infamous.all_bark_all_bite.common.util.ai.HunterAi;
import com.infamous.all_bark_all_bite.config.ABABConfig;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.GoToWantedItem;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.gameevent.GameEvent;

public class SharedWolfAi {
    public static final float LEAP_YD = 0.4f;
    public static final UniformInt ADULT_FOLLOW_RANGE = UniformInt.m_146622_((int)5, (int)16);
    public static final UniformInt ANGER_DURATION = TimeUtil.m_145020_((int)20, (int)39);
    public static final UniformInt AVOID_DURATION = TimeUtil.m_145020_((int)5, (int)7);
    public static final UniformInt RETREAT_DURATION = TimeUtil.m_145020_((int)5, (int)20);
    public static final UniformInt TIME_BETWEEN_HOWLS = TimeUtil.m_145020_((int)30, (int)120);
    public static final UniformInt TIME_BETWEEN_HUNTS = TimeUtil.m_145020_((int)30, (int)120);
    public static final UniformInt LEAP_COOLDOWN = TimeUtil.m_145020_((int)4, (int)6);
    public static final float JUMP_CHANCE_IN_WATER = 0.8f;
    public static final float SPEED_MODIFIER_BREEDING = 1.0f;
    public static final float SPEED_MODIFIER_CHASING = 1.0f;
    public static final float SPEED_MODIFIER_FOLLOWING_ADULT = 1.0f;
    public static final float SPEED_MODIFIER_PANICKING = 1.0f;
    public static final float SPEED_MODIFIER_RETREATING = 1.0f;
    public static final float SPEED_MODIFIER_TEMPTED = 1.0f;
    public static final float SPEED_MODIFIER_WALKING = 1.0f;
    public static final int ATTACK_COOLDOWN_TICKS = 20;
    public static final int DESIRED_DISTANCE_FROM_DISLIKED = 6;
    public static final int DESIRED_DISTANCE_FROM_ENTITY_WHEN_AVOIDING = 12;
    public static final int MAX_LOOK_DIST = 8;
    public static final byte SUCCESSFUL_TAME_ID = 7;
    public static final byte FAILED_TAME_ID = 6;
    public static final int CLOSE_ENOUGH_TO_OWNER = 2;
    public static final int TOO_FAR_TO_SWITCH_TARGETS = 4;
    public static final int TOO_FAR_FROM_WALK_TARGET = 10;
    public static final int TOO_FAR_FROM_OWNER = 10;
    public static final float SPEED_MODIFIER_FETCHING = 1.0f;
    public static final int POUNCE_HEIGHT = 3;
    public static final int INTERACTION_RANGE = 8;
    public static final int ITEM_PICKUP_COOLDOWN = 60;
    public static final int MAX_FETCH_DISTANCE = 16;
    public static final int DISABLE_FETCH_TIME = 200;
    public static final int MAX_TIME_TO_REACH_ITEM = 200;
    public static final float FALL_REDUCTION = 5.0f;
    public static final int TOO_CLOSE_TO_LEAP = 2;
    public static final int TOO_FAR_TO_LEAP = 4;
    public static final int POUNCE_DISTANCE = 6;
    public static final int CLOSE_ENOUGH_TO_INTERACT = 2;
    public static final int CLOSE_ENOUGH_TO_LOOK_TARGET = 3;
    public static final int BABY_POUNCE_DISTANCE = 4;
    public static final int BABY_POUNCE_HEIGHT = 2;
    public static final float LONG_JUMPING_SCALE = 0.7f;
    private static final int HOWL_VOLUME = 4;
    public static final int EAT_COOLDOWN = MiscUtil.seconds(30.0);
    public static final long DIG_DURATION = 100L;
    public static final int DEFAULT_LISTENER_RANGE = 64;
    private static final int HOWL_EXPIRE_TIME = MiscUtil.seconds(30.0);

    public static void initMemories(Wolf wolf, RandomSource randomSource) {
        int huntCooldownInTicks = TIME_BETWEEN_HUNTS.m_214085_(randomSource);
        HunterAi.setHuntedRecently((LivingEntity)wolf, huntCooldownInTicks);
    }

    public static boolean shouldPanic(Wolf wolf) {
        return wolf.m_203117_() || wolf.m_6060_();
    }

    public static boolean canStartAttacking(Wolf wolf) {
        return !wolf.m_6162_() && SharedWolfAi.canMove(wolf) && !BehaviorUtils.m_217126_((LivingEntity)wolf);
    }

    public static float getSpeedModifierTempted(LivingEntity ignoredWolf) {
        return 1.0f;
    }

    public static Optional<? extends LivingEntity> findNearestValidAttackTarget(Wolf wolf) {
        Optional player;
        Brain brain = wolf.m_6274_();
        Optional angryAt = BehaviorUtils.m_22610_((LivingEntity)wolf, (MemoryModuleType)MemoryModuleType.f_26334_);
        if (angryAt.isPresent() && Sensor.m_182377_((LivingEntity)wolf, (LivingEntity)((LivingEntity)angryAt.get()))) {
            return angryAt;
        }
        if (brain.m_21874_(MemoryModuleType.f_26335_) && (player = brain.m_21952_(MemoryModuleType.f_148206_)).isPresent()) {
            return player;
        }
        return brain.m_21952_(MemoryModuleType.f_148194_);
    }

    public static boolean wantsToRetaliate(Wolf wolf, LivingEntity attacker) {
        LivingEntity owner = wolf.m_21826_();
        if (owner == null) {
            return true;
        }
        return wolf.m_7757_(attacker, owner);
    }

    public static boolean isDisliked(LivingEntity target, TagKey<EntityType<?>> disliked) {
        return target.m_6095_().m_204039_(disliked);
    }

    public static void setHowledRecently(LivingEntity wolf, int howlCooldownInTicks) {
        wolf.m_6274_().m_21882_((MemoryModuleType)ABABMemoryModuleTypes.HOWLED_RECENTLY.get(), (Object)true, (long)howlCooldownInTicks);
    }

    public static boolean canMove(Wolf wolf) {
        return !wolf.m_5803_() && !wolf.m_21825_();
    }

    public static void clearStates(TamableAnimal tamableAnimal, boolean resetSit) {
        if (tamableAnimal.m_217003_(Pose.CROUCHING)) {
            tamableAnimal.m_20124_(Pose.STANDING);
        }
        if (tamableAnimal.m_21825_() && resetSit) {
            tamableAnimal.m_21837_(false);
        }
        if (tamableAnimal.m_5803_()) {
            GenericAi.wakeUp((LivingEntity)tamableAnimal);
        }
    }

    public static void reactToAttack(Wolf wolf, LivingEntity attacker) {
        if (wolf.m_6162_()) {
            GenericAi.setAvoidTarget((LivingEntity)wolf, attacker, RETREAT_DURATION.m_214085_(wolf.f_19853_.f_46441_));
            if (Sensor.m_182377_((LivingEntity)wolf, (LivingEntity)attacker)) {
                AngerAi.broadcastAngerTarget(GenericAi.getNearbyAdults(wolf).stream().filter(w -> SharedWolfAi.wantsToRetaliate(w, attacker)).toList(), attacker, ANGER_DURATION);
            }
        } else if (!wolf.m_6274_().m_21954_(Activity.f_37991_)) {
            AngerAi.maybeRetaliate((LivingEntity)wolf, GenericAi.getNearbyAdults(wolf).stream().filter(w -> SharedWolfAi.wantsToRetaliate(w, attacker)).toList(), attacker, ANGER_DURATION, 4.0);
        }
    }

    public static boolean canSleep(Wolf wolf, boolean nocturnal) {
        return nocturnal ? wolf.f_19853_.m_46461_() : wolf.f_19853_.m_46462_() && SharedWolfAi.hasShelter(wolf) && !SharedWolfAi.isAlert((LivingEntity)wolf) && !wolf.f_146808_;
    }

    public static boolean isAlert(LivingEntity wolf) {
        return wolf.m_6274_().m_21874_((MemoryModuleType)ABABMemoryModuleTypes.IS_ALERT.get());
    }

    public static void followHowl(Wolf wolf, BlockPos blockPos) {
        GlobalPos howlPos = GlobalPos.m_122643_((ResourceKey)wolf.m_9236_().m_46472_(), (BlockPos)blockPos);
        wolf.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(blockPos));
        wolf.m_6274_().m_21882_((MemoryModuleType)ABABMemoryModuleTypes.HOWL_LOCATION.get(), (Object)howlPos, (long)HOWL_EXPIRE_TIME);
        wolf.m_6274_().m_21936_(MemoryModuleType.f_26370_);
    }

    public static Optional<PositionTracker> getHowlPosition(LivingEntity wolf) {
        Brain brain = wolf.m_6274_();
        Optional<GlobalPos> howlLocation = SharedWolfAi.getHowlLocation(wolf);
        if (howlLocation.isPresent()) {
            GlobalPos globalPos = howlLocation.get();
            if (wolf.m_9236_().m_46472_() == globalPos.m_122640_()) {
                return Optional.of(new BlockPosTracker(globalPos.m_122646_()));
            }
            brain.m_21936_((MemoryModuleType)ABABMemoryModuleTypes.HOWL_LOCATION.get());
        }
        return Optional.empty();
    }

    public static Optional<GlobalPos> getHowlLocation(LivingEntity wolf) {
        return wolf.m_6274_().m_21952_((MemoryModuleType)ABABMemoryModuleTypes.HOWL_LOCATION.get());
    }

    public static void howl(LivingEntity wolf) {
        wolf.m_5496_(SoundEvents.f_12620_, 4.0f, wolf.m_6100_());
        wolf.m_146850_((GameEvent)ABABGameEvents.ENTITY_HOWL.get());
    }

    public static boolean hasHowledRecently(LivingEntity wolf) {
        return wolf.m_6274_().m_21874_((MemoryModuleType)ABABMemoryModuleTypes.HOWLED_RECENTLY.get());
    }

    public static boolean alertable(Wolf wolf, TagKey<EntityType<?>> huntTargets, TagKey<EntityType<?>> alwaysHostiles, TagKey<EntityType<?>> disliked) {
        List<LivingEntity> nle = GenericAi.getNearestLivingEntities((LivingEntity)wolf);
        for (LivingEntity entity : nle) {
            if (!entity.m_216992_((Entity)wolf, (double)((Integer)ABABConfig.alertableMaxXZDistance.get()).intValue(), (double)((Integer)ABABConfig.alertableMaxYDistance.get()).intValue()) || !AiUtil.isEntityTargetableIgnoringLineOfSight((LivingEntity)wolf, entity) || !SharedWolfAi.canBeAlertedBy(wolf, entity, huntTargets, alwaysHostiles, disliked)) continue;
            return true;
        }
        return false;
    }

    private static boolean canBeAlertedBy(Wolf wolf, LivingEntity target, TagKey<EntityType<?>> huntTargets, TagKey<EntityType<?>> alwaysHostiles, TagKey<EntityType<?>> disliked) {
        if (AiUtil.isSameTypeAndFriendly((LivingEntity)wolf, target)) {
            return false;
        }
        if (CompatUtil.isDILoaded() && DICompat.isTamed((Entity)target)) {
            return false;
        }
        Optional<Boolean> tame = PetUtil.isTame((Entity)target);
        if (tame.isPresent()) {
            return tame.get() == false;
        }
        if (EntitySelector.f_20406_.test(target)) {
            if (wolf.m_21830_(target)) {
                return false;
            }
            return !target.m_5803_() && !target.m_20163_();
        }
        return target.m_6095_().m_204039_(huntTargets) || target.m_6095_().m_204039_(alwaysHostiles) || target.m_6095_().m_204039_(disliked);
    }

    public static boolean hasShelter(Wolf wolf) {
        BlockPos topOfBodyPos = new BlockPos(wolf.m_20185_(), wolf.m_20191_().f_82292_, wolf.m_20189_());
        return MoveToNonSkySeeingSpot.hasBlocksAbove(wolf.f_19853_, (LivingEntity)wolf, topOfBodyPos);
    }

    public static boolean canDefendOwner(Wolf tamableAnimal) {
        return tamableAnimal.m_21824_() && !tamableAnimal.m_21827_();
    }

    public static boolean wantsToAttack(Wolf tamableAnimal, LivingEntity target, LivingEntity owner) {
        return tamableAnimal.m_7757_(target, owner);
    }

    public static void setAteRecently(Animal animal) {
        animal.m_6274_().m_21882_(MemoryModuleType.f_26355_, (Object)true, (long)EAT_COOLDOWN);
    }

    public static void stopHoldingItemInMouth(LivingEntity livingEntity) {
        if (!livingEntity.m_21205_().m_41619_()) {
            SharedWolfAi.spitOutItem(livingEntity, livingEntity.m_21205_());
            livingEntity.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
            AiUtil.setItemPickupCooldown(livingEntity, 60);
        }
    }

    private static void spitOutItem(LivingEntity livingEntity, ItemStack itemStack) {
        if (!itemStack.m_41619_() && !livingEntity.f_19853_.f_46443_) {
            ItemEntity itemEntity = new ItemEntity(livingEntity.f_19853_, livingEntity.m_20185_() + livingEntity.m_20154_().f_82479_, livingEntity.m_20186_() + 1.0, livingEntity.m_20189_() + livingEntity.m_20154_().f_82481_, itemStack);
            itemEntity.m_32060_();
            itemEntity.m_32052_(livingEntity.m_20148_());
            AiUtil.playSoundEvent(livingEntity, SoundEvents.f_11952_);
            livingEntity.f_19853_.m_7967_((Entity)itemEntity);
        }
    }

    public static void holdInMouth(Mob mob, ItemStack stack) {
        SharedWolfAi.stopHoldingItemInMouth((LivingEntity)mob);
        mob.m_8061_(EquipmentSlot.MAINHAND, stack);
        mob.m_21508_(EquipmentSlot.MAINHAND);
        mob.m_21530_();
    }

    public static void pickUpAndHoldItem(Mob mob, ItemEntity itemEntity) {
        mob.m_7938_((Entity)itemEntity, 1);
        ItemStack singleton = MiscUtil.removeOneItemFromItemEntity(itemEntity);
        SharedWolfAi.holdInMouth(mob, singleton);
        AiUtil.setItemPickupCooldown((LivingEntity)mob, 60);
    }

    public static boolean isNotHoldingItem(LivingEntity livingEntity) {
        return livingEntity.m_21205_().m_41619_();
    }

    public static <E extends TamableAnimal> GoToWantedItem<E> createGoToWantedItem(boolean overrideWalkTarget) {
        return new GoToWantedItem(SharedWolfAi::isNotHoldingItem, 1.0f, overrideWalkTarget, 16);
    }

    public static boolean isAbleToPickUp(Mob mob, ItemStack stack) {
        if (!mob.m_6274_().m_21954_(Activity.f_37979_)) {
            return false;
        }
        if (mob.m_6095_() == EntityType.f_20499_ && CompatUtil.isRWLoaded()) {
            return WolfHooks.canWolfHoldItem(stack, (Animal)mob);
        }
        return mob.m_7252_(stack);
    }

    public static boolean wantsToFindShelter(LivingEntity livingEntity, boolean nocturnal) {
        return livingEntity.f_19853_.m_46470_() || nocturnal ? livingEntity.f_19853_.m_46461_() : livingEntity.f_19853_.m_46462_();
    }

    public static boolean isInDayTime(LivingEntity livingEntity) {
        return livingEntity.f_19853_.m_46461_();
    }

    public static boolean isInNightTime(LivingEntity livingEntity) {
        return livingEntity.f_19853_.m_46462_();
    }

    public static boolean wantsToWakeUp(Wolf wolf) {
        return !wolf.m_6274_().m_21954_(Activity.f_37982_) || GenericAi.getAttackTarget((LivingEntity)wolf).isPresent() || wolf.f_19853_.m_46470_() || wolf.m_20069_();
    }

    public static boolean isNearDisliked(Wolf wolf, MemoryModuleType<? extends LivingEntity> dislikedMemory) {
        return GenericAi.isNearTarget((LivingEntity)wolf, 6, dislikedMemory);
    }

    public static void handleSleeping(Wolf wolf) {
        if (wolf.m_5803_()) {
            if (wolf.m_21825_()) {
                wolf.m_21837_(false);
            }
            wolf.m_6862_(false);
            wolf.f_20900_ = 0.0f;
            wolf.f_20902_ = 0.0f;
        }
    }

    public static FollowOwner<Wolf> createFollowOwner(float speedModifier) {
        return new FollowOwner<Wolf>(SharedWolfAi::dontFollowIf, AiUtil::getOwner, speedModifier, 2, SharedWolfAi::getFollowOwnerTriggerDistance);
    }

    private static int getFollowOwnerTriggerDistance(Wolf tamableAnimal) {
        return SharedWolfAi.isFetching(tamableAnimal) ? 2 : CommandAi.getFollowTriggerDistance((LivingEntity)tamableAnimal);
    }

    private static boolean isFetching(Wolf tamableAnimal) {
        return tamableAnimal.m_6274_().m_21874_((MemoryModuleType)ABABMemoryModuleTypes.FETCHING_ITEM.get());
    }

    private static boolean dontFollowIf(Wolf wolf) {
        return wolf.m_21827_();
    }

    public static void tame(Wolf wolf, Player player) {
        wolf.m_21828_(player);
        wolf.m_21839_(true);
        CommandAi.yieldAsPet((PathfinderMob)wolf);
        CommandAi.resetFollowTriggerDistance((LivingEntity)wolf);
    }

    public static void manualCommand(Wolf wolf, Player player) {
        boolean orderedToSit = wolf.m_21827_();
        boolean isFollowingOwner = CommandAi.isOrderedToFollow((LivingEntity)wolf);
        if (orderedToSit && isFollowingOwner) {
            CommandAi.release((LivingEntity)wolf);
            isFollowingOwner = false;
        }
        CommandAi.resetFollowTriggerDistance((LivingEntity)wolf);
        if (!orderedToSit && !isFollowingOwner) {
            if (CompatUtil.isDILoaded()) {
                DICompat.setDICommand((Entity)wolf, (LivingEntity)player, 1);
            }
            wolf.m_21839_(true);
            CommandAi.release((LivingEntity)wolf);
        } else if (orderedToSit) {
            if (CompatUtil.isDILoaded()) {
                DICompat.setDICommand((Entity)wolf, (LivingEntity)player, 2);
            }
            wolf.m_21839_(false);
            CommandAi.orderToFollow((LivingEntity)wolf);
        } else {
            if (CompatUtil.isDILoaded()) {
                DICompat.setDICommand((Entity)wolf, (LivingEntity)player, 0);
            }
            CommandAi.release((LivingEntity)wolf);
        }
        SharedWolfAi.clearStates((TamableAnimal)wolf, false);
        CommandAi.yieldAsPet((PathfinderMob)wolf);
        SharedWolfAi.stopHoldingItemInMouth((LivingEntity)wolf);
    }

    public static boolean wantsToAttack(Wolf wolf, LivingEntity target) {
        if (!wolf.m_21824_()) {
            return true;
        }
        LivingEntity owner = wolf.m_21826_();
        if (owner != null) {
            return wolf.m_7757_(target, owner);
        }
        return true;
    }

    public static float maybeReduceDamage(float amount, DamageSource source) {
        Entity sourceEntity = source.m_7639_();
        if (sourceEntity != null && !(sourceEntity instanceof Player) && !(sourceEntity instanceof AbstractArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return amount;
    }
}

