/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.all_bark_all_bite.common.entity;

import com.infamous.all_bark_all_bite.common.util.ai.AiUtil;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;

public class EntityAnimationController<T extends LivingEntity> {
    public static final byte JUMPING_EVENT_ID = 1;
    public static final byte ATTACKING_EVENT_ID = 4;
    protected final T entity;
    protected final EntityDataAccessor<Pose> entityPose;
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState babyAnimationState = new AnimationState();
    public final AnimationState crouchAnimationState = new AnimationState();
    public final AnimationState digAnimationState = new AnimationState();
    public AnimationState idleAnimationState = new AnimationState();
    public final AnimationState idleDigAnimationState = new AnimationState();
    public AnimationState idleSleepAnimationState = new AnimationState();
    public final AnimationState jumpAnimationState = new AnimationState();
    public final AnimationState leapAnimationState = new AnimationState();
    public final AnimationState sleepAnimationState = new AnimationState();
    public final AnimationState sprintAnimationState = new AnimationState();
    public final AnimationState walkAnimationState = new AnimationState();
    private int jumpTicks;
    private int jumpDuration;
    private int attackAnimationRemainingTicks;
    private int idleDigDelayTicks;
    private int idleSleepDelayTicks;
    private boolean posed;

    public EntityAnimationController(T entity, EntityDataAccessor<Pose> entityPose) {
        this.entity = entity;
        this.entityPose = entityPose;
    }

    public void startAttackAnimation() {
        this.attackAnimationState.m_216977_(((LivingEntity)this.entity).f_19797_);
        this.attackAnimationRemainingTicks = 15;
    }

    public void startJumpAnimation() {
        this.jumpAnimationState.m_216977_(((LivingEntity)this.entity).f_19797_);
        this.jumpDuration = 10;
        this.jumpTicks = 0;
    }

    public void onSyncedDataUpdatedAnimations(EntityDataAccessor<?> dataAccessor) {
        if (this.entityPose.equals(dataAccessor)) {
            this.posed = false;
            this.handlePose(Pose.CROUCHING, this.crouchAnimationState);
            this.handleDiggingPose();
            this.handlePose(Pose.LONG_JUMPING, this.leapAnimationState);
            this.handleSleepingPose();
            if (this.posed) {
                this.stopAllNonePoseAnimations();
            }
        }
    }

    private void handleDiggingPose() {
        if (this.entity.m_20089_() == Pose.DIGGING) {
            if (!this.digAnimationState.m_216984_()) {
                this.idleDigDelayTicks = 10;
            }
            this.digAnimationState.m_216982_(((LivingEntity)this.entity).f_19797_);
            this.posed = true;
        } else {
            this.digAnimationState.m_216973_();
            this.idleDigAnimationState.m_216973_();
        }
    }

    private void handleSleepingPose() {
        if (this.entity.m_20089_() == Pose.SLEEPING) {
            if (!this.sleepAnimationState.m_216984_()) {
                this.idleSleepDelayTicks = 4;
            }
            this.sleepAnimationState.m_216982_(((LivingEntity)this.entity).f_19797_);
            this.posed = true;
        } else {
            this.sleepAnimationState.m_216973_();
            this.idleSleepAnimationState.m_216973_();
        }
    }

    private void handlePose(Pose pose, AnimationState poseAnimationState) {
        if (this.entity.m_20089_() == pose) {
            poseAnimationState.m_216982_(((LivingEntity)this.entity).f_19797_);
            this.posed = true;
        } else {
            poseAnimationState.m_216973_();
        }
    }

    protected void stopAllNonePoseAnimations() {
        this.attackAnimationState.m_216973_();
        this.idleAnimationState.m_216973_();
        this.jumpAnimationState.m_216973_();
        this.sprintAnimationState.m_216973_();
        this.walkAnimationState.m_216973_();
    }

    public void aiStepAnimations() {
        if (this.jumpTicks != this.jumpDuration) {
            ++this.jumpTicks;
        } else if (this.jumpDuration != 0) {
            this.jumpTicks = 0;
            this.jumpDuration = 0;
        }
        if (this.attackAnimationRemainingTicks > 0) {
            --this.attackAnimationRemainingTicks;
        }
        if (this.idleDigDelayTicks > 0) {
            --this.idleDigDelayTicks;
        }
        if (this.idleSleepDelayTicks > 0) {
            --this.idleSleepDelayTicks;
        }
    }

    public void tickAnimations() {
        this.tickBaby();
        this.tickBasicAnimations();
    }

    protected void tickBasicAnimations() {
        if (!this.entity.m_5803_()) {
            if (!this.posed) {
                this.tickNonPoseAnimations();
            } else if (this.entity.m_217003_(Pose.DIGGING) && this.idleDigDelayTicks == 0) {
                this.digAnimationState.m_216973_();
                this.idleDigAnimationState.m_216982_(((LivingEntity)this.entity).f_19797_);
            }
        } else if (this.idleSleepDelayTicks == 0) {
            this.sleepAnimationState.m_216973_();
            this.idleSleepAnimationState.m_216982_(((LivingEntity)this.entity).f_19797_);
        }
    }

    protected void tickBaby() {
        if (this.entity.m_6162_()) {
            this.babyAnimationState.m_216982_(((LivingEntity)this.entity).f_19797_);
        } else {
            this.babyAnimationState.m_216973_();
        }
    }

    private void tickNonPoseAnimations() {
        boolean inactive;
        boolean midAttack;
        boolean midJump;
        boolean bl = midJump = this.jumpDuration > 0;
        if (!midJump && this.jumpAnimationState.m_216984_()) {
            this.jumpAnimationState.m_216973_();
        }
        boolean bl2 = midAttack = this.attackAnimationRemainingTicks > 0;
        if (!midAttack && this.attackAnimationState.m_216984_()) {
            this.attackAnimationState.m_216973_();
        }
        boolean bl3 = inactive = !midJump && !midAttack;
        if (AiUtil.isMovingOnLandOrInWater(this.entity) && inactive) {
            this.idleAnimationState.m_216973_();
            if (this.entity.m_20142_()) {
                this.walkAnimationState.m_216973_();
                this.sprintAnimationState.m_216982_(((LivingEntity)this.entity).f_19797_);
            } else {
                this.sprintAnimationState.m_216973_();
                this.walkAnimationState.m_216982_(((LivingEntity)this.entity).f_19797_);
            }
        } else {
            if (inactive) {
                this.idleAnimationState.m_216982_(((LivingEntity)this.entity).f_19797_);
            }
            this.sprintAnimationState.m_216973_();
            this.walkAnimationState.m_216973_();
        }
    }

    public void handleEntityEventAnimation(byte id) {
        if (id == 1) {
            this.startJumpAnimation();
        } else if (id == 4) {
            this.startAttackAnimation();
        }
    }
}

